
local levers = {}

minetest.register_entity(":artifact:lever_display", {
    initial_properties = {
        visual = "mesh",
        mesh = "artifact_lever.gltf",
        textures = {"artifact_lever_wood.png"},
        seelctionbox = {
            
        }
    },
    _interact_time = 0.3,
    _interact_marker_offset = function(e)
        return vector.new(0, -0.4, 0):rotate(e.rotation)
    end,
    on_activate = function(e, data)
        if not minetest.get_node(e.object:get_pos()).name:find "lever" then
            e.object:remove()
            return
        end
        e._name = ""..math.random()
        e.object:set_armor_groups{immortal = 1}
        extend(e, minetest.deserialize(data) or {})
        if not e.rotation then e.rotation = vector.zero() end
        
        e.object:set_properties {
            selectionbox = artifact.rotate_selectionbox({
                -3/16, -0.5, -4/16,
                 3/16, -3/16, 4/16
            }, e.rotation)
        }
        
        levers[e.object:get_pos():round():to_string()] = e
    end,
    on_deactivte = function(e)
        levers[e.object:get_pos():round():to_string()] = nil
    end,
    get_staticdata = function(e)
        return minetest.serialize{rotation = e.rotation}
    end,
    on_interact = function(e)
        if e._active then
            e._active = false
            e._no_interact = true
            e.object:set_animation({x=1,y=2}, 2, 0.1, false)
            minetest.after(0.5, function()
                e._no_interact = nil
                e:trigger(false)
            end)
        else
            e._active = true
            e._no_interact = true
            e.object:set_animation({x=0,y=1}, 2, 0.1, false)
            minetest.after(0.5, function()
                e._no_interact = nil
                e:trigger(true)
            end)
        end
    end,
    trigger = function(e, state)
        local receivers = minetest.deserialize(minetest.get_meta(e.object:get_pos():round()):get("receivers") or "return nil")
        if receivers then
            artifact.dispatch_event(receivers, {type = state and "on" or "off"})
        end
    end,
    rotate = function(e, rot)
        if not rot then
            say "!"
            return
        end
        e.object:set_rotation(rot)
        e.rotation = rot
        e.object:set_properties {
            selectionbox = artifact.rotate_selectionbox({
                -3/16, -0.5, -4/16,
                 3/16, -3/16, 4/16
            }, e.rotation)
        }
    end
})


artifact.register_node("lever", {
    drawtype = "airlike",
    paramtype = "light",
    sunlight_propagates = true,
    paramtype2 = "facedir",
    collision_box = {
        type = "fixed",
        fixed = {
            -3/16, -0.5, -4/16,
             3/16, -3/16, 4/16
         }
    },
    selection_box = {
        type = "fixed",
        fixed = {
             -3/16, -0.5, -4/16,
              3/16, -3/16, 4/16
        }
    },
    pointable = false,
    on_construct = function(pos)
        local m = minetest.get_meta(pos)
        local rot = artifact.facedir_to_rotation(minetest.get_node(pos).param2)
        if m:contains("initialized") then
            levers[pos:to_string()]:rotate(rot)
        else
            m:set_string("initialized", "true")
            minetest.add_entity(pos, "artifact:lever_display", minetest.serialize{type = "wood"}):get_luaentity():rotate(rot)
        end
    end,
    on_destruct = function(pos)
        levers[pos:to_string()].object:remove()
        levers[pos:to_string()] = nil
    end,
    on_load = function(pos)
        local m = minetest.get_meta(pos)
        if not m:contains("initialized") then
            m:set_string("initialized", "true")
            local rot = artifact.facedir_to_rotation(minetest.get_node(pos).param2)
            minetest.add_entity(pos, "artifact:lever_display", minetest.serialize{type = "wood"}):get_luaentity():rotate(rot)
        end
    end,
    on_rightclick = function(pos)
        local rot = artifact.facedir_to_rotation(minetest.get_node(pos).param2)
        levers[pos:to_string()]:rotate(rot)
    end,
    on_rotate = function(pos, node, p, click, param2)
        node.param2 = param2
        minetest.swap_node(pos, node)
        local rot = artifact.facedir_to_rotation(param2)
        levers[pos:to_string()]:rotate(rot)
        return true
    end
})




artifact.register_node("target", {
    tiles = {"artifact_target.png"},
    on_impact = function(pos)
        local receivers = minetest.deserialize(minetest.get_meta(pos):get("receivers") or "return nil")
        if receivers then
            artifact.dispatch_event(receivers, {type = "pulse"})
        end
    end
})

artifact.register_node("target_off", {
    tiles = {"artifact_target_off.png"},
    on_impact = function(pos)
        local receivers = minetest.deserialize(minetest.get_meta(pos):get("receivers") or "return nil")
        if receivers then
            artifact.dispatch_event(receivers, {type = "on"})
        end
        minetest.swap_node(pos, {name = "target_on"})
    end
})

artifact.register_node("target_on", {
    tiles = {"artifact_target_on.png"},
    on_impact = function(pos)
        local receivers = minetest.deserialize(minetest.get_meta(pos):get("receivers") or "return nil")
        if receivers then
            artifact.dispatch_event(receivers, {type = "off"})
        end
        minetest.swap_node(pos, {name = "target_off"})
    end
})

