local ns = artifact

function ns.show_radial_menu(m, menu)
    m._menu = {
        name = menu.name,
        count = #menu,
        step = math.pi *2 /#menu,
        pos = vector.zero(),
        cursor = artifact.hud_add(m, {
            type = "image",
            pos = {x=0.5, y=0.5},
            offset = {x=0, y=0},
            image = "artifact_radial_cursor.png"
        })
    }
    for i, x in ipairs(menu) do
        local size = 150
        local angle = m._menu.step *(i -1) -math.pi
        local el = artifact.hud_add(m, {
            name = menu.name.."_"..i,
            item = x,
            type = "image",
            pos = {x=0.5,y=0.5},
            scale = {x=0.1,y=0.1},
            offset = {x=math.sin(angle) *size,y=math.cos(angle) *size},
            image = "artifact_construct_test_icon.png",
            opacity = 128
        })
        el:animate {
            scale = {
                value = {x=0.7, y=0.7},
                duration = 0.1
            }
        }
        m._menu[#m._menu +1] = el
    end
    m.object:hud_set_flags{crosshair = false}
end

function ns.dismiss_radial_menu(m, name)
    -- This is in case we only want to close a specific menu while leaving others intact.
    if name and (not m._menu or m._menu.name ~= name) then return end
    for _, x in ipairs(m._menu) do
        x:remove(m)
    end
    m._menu.cursor:remove(m)
    m._menu = nil
    m.object:hud_set_flags{crosshair = true}
end
