

minetest.register_entity(":artifact:device_block", {
    initial_properties = {
        visual = "cube",
        textures = {"artifact_device_block.png", "artifact_device_block.png", "artifact_device_block.png", "artifact_device_block.png", "artifact_device_block.png", "artifact_device_block.png"},
        use_texture_alpha = true,
        glow = 8,
        static_save = false,
    },
    _grabbable = true,
    on_activate = function(e)
        e.object:set_armor_groups{immortal = 1}
    end,
    on_hit = function(e, m)
        artifact.grab_device(m, e)
    end,
})


function artifact.grab_device(m, e)
    e._no_interact = true
    m._grabbed_item = e.object
    m._on_ungrab = function()
        e._no_interact = nil
    end
end

function artifact.summon_device(m, device)
    local e
    if device == "block" then
        e = minetest.add_entity(m.pos, "artifact:device_block"):get_luaentity()
    end
    if e then
        artifact.grab_device(m, e)
    end
end
