

local help_toasts = {}
function artifact.show_help_message(m, msg, icon)
    local box = {}
    local w = math.max(400, #msg *10) +(icon and 50 or 0)
    box.left = artifact.hud_add(m, {
        type = "image",
        pos = {x=1,y=0.7},
        offset={x=-w +500,y=0},
        align = {x=1,y=1},
        scale = {x=4,y=4},
        image = "artifact_chat_box_side.png"
    })
    box.middle = artifact.hud_add(m, {
        type = "image",
        pos = {x=1,y=0.7},
        offset={x=-w +4 +500,y=0},
        align = {x=1,y=1},
        scale = {x=w -24,y=4},
        image = "artifact_chat_box_middle.png"
    })
    box.right = artifact.hud_add(m, {
        type = "image",
        pos = {x=1,y=0.7},
        offset={x=-16 +500,y=0},
        align = {x=-1,y=1},
        scale = {x=4,y=4},
        image = "artifact_chat_box_side.png"
    })
    box.text = artifact.hud_add(m, {
        type = "text",
        pos = {x=1,y=0.7},
        padding_y = 10,
        offset={x=-w +8 +500 +(icon and 50 or 0),y=32},
        align = {x=1,y=0},
        scale = {x=4,y=4},
        text = msg
    })
    if icon then
        box.icon = artifact.hud_add(m, {
            type = "image",
            pos = {x=1,y=0.7},
            offset={x=-w +36 +500,y=32},
            align = {x=0,y=0},
            scale = {x=2,y=2},
            image = "artifact_icon_"..icon..".png"
        })
    end
    if #help_toasts > 0 then
        for i, toast in pairs(help_toasts) do
            for _, x in pairs(toast) do
                x:animate {
                    offset = {
                        value = {x=x.offset.x, y=x.offset.y -75},
                        duration = 0.3,
                    }
                }
            end
        end
    end
    table.insert(help_toasts, box)
    for _, x in pairs(box) do
        x:animate {
            offset = {
                value = {x=x.offset.x -500, y=x.offset.y},
                duration = 0.4,
                ease_fn = {0.42,0, 0.58,1.5}
            }
        }
    end
    minetest.after(10, function()
        for _, x in pairs(box) do
            x:animate {
                offset = {
                    value = {x=x.offset.x +500, y=x.offset.y},
                    duration = 0.4,
                    ease_fn = {0.42,-0.5, 0.58,1}
                }
            }
        end
        minetest.after(0.4, function()
            for _, x in pairs(box) do
                x:remove(m)
            end
            table.remove(help_toasts, table.indexof(help_toasts, box))
        end)
    end)
end

function artifact.show_hint_particles(def)
    minetest.add_particlespawner(extend({
        texture = "[fill:1x1:0,0:#fff"
    }, def))
end


if artifact.debug then
    minetest.register_chatcommand("h", {
        func = function(name, args)
            artifact.show_help_message(artifact.players[name], args or "This is a test")
        end
    })
end
