local ns = artifact


function ns.do_whack(m)
    if m.pointed_node then
        local pos = m.pointed_node.under
        local node = minetest.get_node(pos)
        local def = minetest.registered_nodes[node.name]
        if not def.groups.whackable then return end
        minetest.remove_node(pos)
        minetest.add_particlespawner {
            pos = {
                min = pos:offset(-0.5, -0.5, -0.5),
                max = pos:offset(0.5, 0.5, 0.5)
            },
            vel = {
                min = vector.new(-1, 0, -1) *1.5,
                max = vector.new(1, 2, 1) *1.5
            },
            acc = vector.new(0,-9.81,0),
            collisiondetection = true,
            amount = 50,
            node = {name = node.name},
            time = 0.1
        }
        if artifact.on_whacked then
            artifact.on_whacked("node", m.pointed_node)
        end
    elseif m.pointed_obj and m.pointed_obj.on_whack then
        if m.pointed_obj:on_whack() then
            -- For use in artifact_help.
            if artifact.on_whacked then
                artifact.on_whacked("object", m.pointed_obj)
            end
        end
    end
end