<?php
// This PHP script can be used to import an existing u_skins library into libskinupload.
// To do that, set $uskins to the path to the u_skins mod to source from and $world to the path to the target world and run the script.
// The script assumes that you are using a fresh install of libskinupload, i.e. no skins have been uploaded yet.

$uskins = '';
$world = '';

if($uskins == '' or $world == '') {
    exit('Make sure that $uskins and $world are set to the desired paths.');
}

$file = fopen("$world/libskinupload_meta.json", 'a');

fwrite($file, "{");

$lastid = 0;
foreach(glob("$uskins/textures/character_*.png") as $fname) {
    if(preg_match('#/textures/character_(\d+)\.png#', $fname, $matches)) {
        $id = $matches[1];
        if(intval($id) > $lastid) $lastid = $id;
        if($lastid != 0) fwrite($file, ",");
        fwrite($file, "\"$id\":");
        echo "Found skin ID $id:\n";
        echo "  |- Copying image file...\n";
        copy($fname, "$world/libskinupload_skins/libskinupload_uploaded_skin_$id.png");
        if(file_exists("$uskins/meta/character_$id.txt")) {
            echo "  |- Migrating meta...\n";
            $meta = file_get_contents("$uskins/meta/character_$id.txt");
            preg_match('#author = "([^"]+)"#', $meta, $author);
            preg_match('#name = "([^"]+)"#', $meta, $name);
            preg_match('#comment = "([^"]+)"#', $meta, $comment);
            if(!isset($author[1])) {
                echo "  |- Meta file seems invalid; falling back to default meta...\n";
                fwrite($file, json_encode([
                    'c' => '<Unknown>',
                    'n' => 'Unnamed',
                    'd' => ''
                ]));
            } else {
                fwrite($file, json_encode([
                    'c' => $author[1],
                    'n' => $name[1],
                    'd' => $comment[1]
                ]));
            }
        } else {
            echo "  |- Appending default meta...\n";
            fwrite($file, json_encode([
                'c' => '<Unknown>',
                'n' => 'Unnamed',
                'd' => ''
            ]));
        }
    }
}
++$lastid;

fwrite($file, "}");

fclose($file);

echo "Transfer complete, incrementing internal counter...\n";

file_put_contents("$world/libskinupload_nextid.txt", $lastid);
