--[[
    World Cross-Section — Cuts a Minetest world in half
    Created in 2022 by Silver Sandstone <@SilverSandstone@craftodon.social>

    To the extent possible under law, the author has dedicated all copyright
    and related and neighbouring rights to this software to the public
    domain worldwide. This software is distributed without any warranty.

    You should have received a copy of the CC0 Public Domain Dedication
    along with this software. If not, see
    <https://creativecommons.org/publicdomain/zero/1.0/>.
]]


minetest.register_node('crosssection:fill',
{
    description         = 'Cross-Section Filler';
    paramtype           = 'light';
    drawtype            = 'airlike';
    buildable_to        = true;
    walkable            = false;
    pointable           = false;
    light_source        = minetest.LIGHT_MAX;
    sunlight_propagates = true;
    is_ground_content   = false;
    groups              = {not_in_creative_inventory = 1};
});


local function filled_table(length, value)
    local result = {};
    for index = 0, length do
        result[index] = value;
    end;
    return result;
end;

local function clear_area(lvm)
    local fill = minetest.get_content_id('crosssection:fill');
    local minp, maxp = lvm:get_emerged_area();
    local area_size = maxp - minp;
    local length = area_size.x * area_size.y * area_size.z;
    lvm:set_data(filled_table(length, fill));
    lvm:set_light_data(filled_table(length, minetest.LIGHT_MAX * 16));
    lvm:set_param2_data(filled_table(length, 0));
    lvm:write_to_map(true);
end;

local function on_generated(minp, maxp, blockseed)
    if minp.z >= 0 then
        local lvm = minetest.get_mapgen_object('voxelmanip');
        clear_area(lvm);
    end;
end;

minetest.register_on_generated(on_generated);
