--[[
    Leads — Adds leads for transporting animals to Minetest.
    Copyright © 2023, Silver Sandstone <@SilverSandstone@craftodon.social>

    Permission is hereby granted, free of charge, to any person obtaining a
    copy of this software and associated documentation files (the "Software"),
    to deal in the Software without restriction, including without limitation
    the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and/or sell copies of the Software, and to permit persons to whom the
    Software is furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.
]]


--- Internal functions and overrides.
-- @module internal


leads.interaction_blockers = {};


function leads._after_register_item(name, def)
    local old_on_place = def.on_place;
    local function _on_place(itemstack, placer, pointed_thing, ...)
        -- Try knotting the placer's held lead:
        local node = pointed_thing.under and minetest.get_node_or_nil(pointed_thing.under);
        if node and leads.is_knottable(node.name) then
            if leads.knot(placer, pointed_thing.under) then
                return nil;
            end;
        end;
        -- Fallback to the item's old on_place function:
        return (old_on_place or minetest.item_place)(itemstack, placer, pointed_thing, ...);
    end;
    minetest.override_item(name, {on_place = _on_place});
end;


local old_is_protected = minetest.is_protected;
function minetest.is_protected(pos, name)
    if leads.interaction_blockers[name] then
        return true;
    end;
    return old_is_protected(pos, name);
end;


for name, def in pairs(minetest.registered_items) do
    leads._after_register_item(name, def);
end;

local old_register_item = minetest.register_item;
function minetest.register_item(name, def)
    old_register_item(name, def);
    leads._after_register_item(string.gsub(name, '^:+', ''), def);
end;
