--[[
    Raw Ore Blocks — adds block forms of metal lumps to Luanti
    Copyright © 2022-2026, Silver Sandstone <@SilverSandstone@craftodon.social>

    Permission is hereby granted, free of charge, to any person obtaining a
    copy of this software and associated documentation files (the "Software"),
    to deal in the Software without restriction, including without limitation
    the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and/or sell copies of the Software, and to permit persons to whom the
    Software is furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.
]]


--- Block definitions.
-- @module definitions


local S = core.get_translator('lumpblocks');


-- Minetest:
lumpblocks.register_lump_block('lumpblocks:copper_block',
{
    lump        = 'default:copper_lump';
    description = S'Raw Copper Block';
    colours     = {'#973F23', '#F4D352'};
});

lumpblocks.register_lump_block('lumpblocks:gold_block',
{
    lump        = 'default:gold_lump';
    description = S'Raw Gold Block';
    colours     = {'#BD4B00', '#FFF444'};
});

lumpblocks.register_lump_block('lumpblocks:iron_block',
{
    lump        = 'default:iron_lump';
    description = S'Raw Iron Block';
    colours     = {'#7F3E24', '#D47F4E'};
});

lumpblocks.register_lump_block('lumpblocks:tin_block',
{
    lump        = 'default:tin_lump';
    description = S'Raw Tin Block';
    colours     = {'#878787', '#C3C3C3'};
});

-- Repixture:
lumpblocks.register_lump_block('lumpblocks:bronze_block',
{
    lump        = 'rp_default:lump_bronze';
    description = S'Raw Bronze Block';
    colours     = {'#B13F07', '#FBA24F'};
});

lumpblocks.register_lump_block('lumpblocks:copper_block',
{
    lump        = 'rp_default:lump_copper';
    description = S'Raw Copper Block';
    colours     = {'#973F23', '#F4D352'};
});

lumpblocks.register_lump_block('lumpblocks:iron_block',
{
    lump        = 'rp_default:lump_iron';
    description = S'Raw Iron Block';
    colours     = {'#7F3E24', '#D47F4E'};
});

lumpblocks.register_lump_block('lumpblocks:tin_block',
{
    lump        = 'rp_default:lump_tin';
    description = S'Raw Tin Block';
    colours     = {'#878787', '#C3C3C3'};
});

lumpblocks.register_lump_block('lumpblocks:gold_block',
{
    lump        = 'rp_gold:lump_gold';
    description = S'Raw Gold Block';
    colours     = {'#BD4B00', '#FFF444'};
});

-- More Ores:
lumpblocks.register_lump_block('lumpblocks:mithril_block',
{
    lump        = 'moreores:mithril_lump';
    description = S'Raw Mithril Block';
    colours     = {'#1C2D7E', '#806DD5'};
});

lumpblocks.register_lump_block('lumpblocks:silver_block',
{
    lump        = 'moreores:silver_lump';
    description = S'Raw Silver Block';
    colours     = {'#7488AA', '#F4F8FD'};
});

-- Technic:
lumpblocks.register_lump_block('lumpblocks:chromium_block',
{
    lump        = 'technic:chromium_lump';
    description = S'Raw Chromium Block';
    colours     = {'#8AB0B0', '#F5F8F8'};
});

lumpblocks.register_lump_block('lumpblocks:lead_block',
{
    lump        = 'technic:lead_lump';
    description = S'Raw Lead Block';
    colours     = {'#454545', '#EBEBEB'};
});

lumpblocks.register_lump_block('lumpblocks:sulfur_block',
{
    lump        = 'technic:sulfur_lump';
    description = S'Raw Sulphur Block';
    colours     = {'#B69A00', '#FFE400'};
});

lumpblocks.register_lump_block('lumpblocks:uranium_block',
{
    lump        = 'technic:uranium_lump';
    description = S'Raw Uranium Block';
    colours     = {'#00592A', '#99ED1A'};
    groups      = {radioactive = 1};
});

lumpblocks.register_lump_block('lumpblocks:zinc_block',
{
    lump        = 'technic:zinc_lump';
    description = S'Raw Zinc Block';
    colours     = {'#6CB5C9', '#DCF2F8'};
});

-- Nether:
lumpblocks.register_lump_block('lumpblocks:nether_block',
{
    lump        = 'nether:nether_lump';
    description = S'Raw Nether Block';
    colours     = {'#586628', '#AEBF72'};
});

-- Glooptest:
lumpblocks.register_lump_block('lumpblocks:akalin_block',
{
    lump        = 'glooptest:akalin_lump';
    description = S'Raw Akalin Block';
    colours     = {'#8A84C6', '#A5B4EB'};
});

lumpblocks.register_lump_block('lumpblocks:alatro_block',
{
    lump        = 'glooptest:alatro_lump';
    description = S'Raw Alatro Block';
    colours     = {'#4B1778', '#C290EC'};
});

lumpblocks.register_lump_block('lumpblocks:arol_block',
{
    lump        = 'glooptest:arol_lump';
    description = S'Raw Arol Block';
    colours     = {'#197115', '#84D97D'};
});

lumpblocks.register_lump_block('lumpblocks:kalite_block',
{
    lump        = 'glooptest:kalite_lump';
    description = S'Raw Kalite Block';
    colours     = {'#700000', '#B90000'};
});

lumpblocks.register_lump_block('lumpblocks:talinite_block',
{
    lump        = 'glooptest:talinite_lump';
    description = S'Raw Talinite Block';
    colours     = {'#259496', '#42D5D7'};
    def         = {light_source = 6};
});

-- Techage:
lumpblocks.register_lump_block('lumpblocks:baborium_block',
{
    lump        = 'techage:baborium_lump';
    description = S'Raw Baborium Block';
    colours     = {'#6D1414', '#D4691A'};
});

-- Silver:
lumpblocks.register_lump_block('lumpblocks:silver_block',
{
    lump        = 'silver:silver_lump';
    description = S'Raw Silver Block';
    colours     = {'#746E6E', '#DDDDDD'};
});

-- Elepower:
lumpblocks.register_lump_block('lumpblocks:lead_block',
{
    lump        = 'elepower_dynamics:lead_lump';
    description = S'Raw Lead Block';
    colours     = {'#283240', '#3E4E66'},
});

lumpblocks.register_lump_block('lumpblocks:nickel_block',
{
    lump        = 'elepower_dynamics:nickel_lump';
    description = S'Raw Nickel Block';
    colours     = {'#7A7659', '#959275'};
});

lumpblocks.register_lump_block('lumpblocks:viridisium_block',
{
    lump        = 'elepower_dynamics:viridisium_lump';
    description = S'Raw Viridisium Block';
    colours     = {'#46783E', '#65B151'};
});

lumpblocks.register_lump_block('lumpblocks:zinc_block',
{
    lump        = 'elepower_dynamics:zinc_lump';
    description = S'Raw Zinc Block';
    colours     = {'#5E8DA1', '#82A7B9'};
});

lumpblocks.register_lump_block('lumpblocks:uranium_block',
{
    lump        = 'elepower_nuclear:uranium_lump';
    description = S'Raw Uranium Lump';
    colours     = {'#036403', '#038F03'};
});

-- Terumet:
lumpblocks.register_lump_block('lumpblocks:terumet_block',
{
    lump        = 'terumet:lump_raw';
    description = S'Raw Terumet Lump';
    colours     = {'#411117', '#CA767A'};
});
