Repixture Crafting Compatibility
================================

This mod converts crafting recipes from Minetest format to Repixture format,
making it easier for mods to support Repixture.

You can use this mod as a library, or have it automatically convert all
registered recipes.


Library Use
-----------

You can register a crafting recipe for both Minetest and Repixture by using
`rp_craftcompat.register_craft()` in place of `minetest.register_craft()`.

The easiest way to do this is to keep a local reference to the function:

    local register_craft = minetest.get_modpath('rp_craftcompat') and rp_craftcompat.register_craft or minetest.register_craft;

Alternatively, you can manually convert a Minetest crafting recipe to
Repixture format using `rp_craftcompat.convert_recipe()`.


Automatic Conversion
--------------------

This mod also has an option to automatically convert all crafting recipes
registered with `minetest.register_craft()` to Repixture's crafting system.

For automatic conversion, this mod does not need to be listed as a dependency.


License
-------

Repixture Crafting Compatibility by Silver Sandstone is dedicated to the
public domain via CC0.

See `LICENSE.txt` for more information.
