#!/usr/bin/env bash


###############################################################################
#                                                                             #
#  Build script for Repixture Crafting Compatibility                          #
#  Written in 2022 by Silver Sandstone <@SilverSandstone@craftodon.social>    #
#                                                                             #
#  To the extent possible under law, the author has dedicated all copyright   #
#  and related and neighbouring rights to this software to the public         #
#  domain worldwide. This software is distributed without any warranty.       #
#                                                                             #
#  You should have received a copy of the CC0 Public Domain Dedication        #
#  along with this software. If not, see                                      #
#  <https://creativecommons.org/publicdomain/zero/1.0/>.                      #
#                                                                             #
###############################################################################


function status()
{
    printf '\n\e[1m%s\e[m\n' "$*"
}


set -eu
cd "$(dirname "$0")"


status 'Generating documentation...'
ldoc 'init.lua' --dir 'doc/' --title 'Repixture Crafting Compatibility API Reference'


status 'Creating distribution...'
archive='rp_craftcompat.zip'
[[ -e "$archive" ]] && rm "$archive"
zip -r "$archive" \
    init.lua \
    mod.conf \
    settingtypes.txt \
    build.sh \
    README.md \
    LICENSE.txt \
    screenshot.png \
    doc/


status 'Build complete.'
