--[[
    Subtitles — adds subtitles to Minetest.

    This module provides the CornerSubtitleDisplay class, which displays
    subtitles in a corner of the screen.

    Copyright © 2022, Silver Sandstone <@SilverSandstone@craftodon.social>

    Permission is hereby granted, free of charge, to any person obtaining a
    copy of this software and associated documentation files (the "Software"),
    to deal in the Software without restriction, including without limitation
    the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and/or sell copies of the Software, and to permit persons to whom the
    Software is furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included
    in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
    THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.
]]


local S = subtitles.S;


subtitles.CornerSubtitleDisplay = subtitles.BaseTextSubtitleDisplay:extend();

subtitles.CornerSubtitleDisplay.NAME        = 'corner';
subtitles.CornerSubtitleDisplay.ICON        = 'subtitles_mode_corner.png';
subtitles.CornerSubtitleDisplay.TITLE       = S'Text in corner';
subtitles.CornerSubtitleDisplay.DESCRIPTION = S'Displays a list of subtitles in the corner of the screen.';

function subtitles.CornerSubtitleDisplay:init()
    self.super.init(self);

    self.margin    = 56;
    self.size      = {x = 360, y = 40};
    self.offset    = {x = -(self.margin + self.size.x / 2), y = -self.margin};
    self.alignment = {x = 0, y = -1};
end;

function subtitles.CornerSubtitleDisplay:get_huds(entry)
    local offset = entry:get_offset();
    local huds = {};
    huds.text =
    {
        hud_elem_type = 'text';
        name          = S'Subtitle';
        text          = entry.sound:get_description();
        offset        = {x = offset.x, y = offset.y - 2};
        scale         = self.size;
        number        = 0xFFFFFF;
        size          = {x = self.font_size, y = self.font_size};
        style         = self.style;
    };
    huds.background =
    {
        hud_elem_type = 'image';
        name          = S'Subtitle background';
        text          = ('subtitles_subtitle_background.png^[resize:%dx%d'):format(self.size.x, self.size.y);
        offset        = offset;
        scale         = {x = 1, y = 1};
    };
    return huds;
end;

subtitles.CornerSubtitleDisplay:register();
