--[[
    Subtitles — adds subtitles to Minetest.

    This module provides the ClassicSubtitleDisplay class, which displays
    subtitles at the bottom of the screen.

    Copyright © 2022, Silver Sandstone <@SilverSandstone@craftodon.social>

    Permission is hereby granted, free of charge, to any person obtaining a
    copy of this software and associated documentation files (the "Software"),
    to deal in the Software without restriction, including without limitation
    the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and/or sell copies of the Software, and to permit persons to whom the
    Software is furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included
    in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
    THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.
]]


local S = subtitles.S;


subtitles.ClassicSubtitleDisplay = subtitles.BaseTextSubtitleDisplay:extend();

subtitles.ClassicSubtitleDisplay.NAME        = 'classic';
subtitles.ClassicSubtitleDisplay.ICON        = 'subtitles_mode_classic.png';
subtitles.ClassicSubtitleDisplay.TITLE       = S'Classic subtitles';
subtitles.ClassicSubtitleDisplay.DESCRIPTION = S'Displays outlined subtitles at the bottom of the screen.';

function subtitles.ClassicSubtitleDisplay:init()
    self.super.init(self);

    self.margin = 80;
    self.font_size = 3.0;
    self.size = {x = 640, y = 60};
    self.offset = {x = 0, y = -self.margin};
    self.position = {x = 0.5, y = 1.0};
end;

function subtitles.ClassicSubtitleDisplay:get_huds(entry)
    local offset = entry:get_offset();
    local huds = {};
    local radius = 3;
    for x = -radius, radius do
        for y = -radius, radius do
            if math.sqrt(x ^ 2 + y ^ 2) < radius + 1 then
                local hud =
                {
                    hud_elem_type = 'text';
                    name          = S'Subtitle';
                    text          = entry.sound:get_description();
                    offset        = {x = offset.x + x, y = offset.y + y - 2};
                    scale         = self.size;
                    number        = 0x003FDF;
                    size          = {x = self.font_size, y = self.font_size};
                    z_index       = self.z_index + 1;
                    style         = self.style;
                };
                if x == 0 and y == 0 then
                    hud.number = 0xFFFFFF;
                    hud.z_index = hud.z_index + 1;
                end;
                huds[x .. ',' .. y] = hud;
            end;
        end;
    end;
    return huds;
end;

subtitles.ClassicSubtitleDisplay:register();
