--[[
    Subtitles — adds subtitles to Minetest.

    This module provides the `/subtitles` command.

    Copyright © 2022, Silver Sandstone <@SilverSandstone@craftodon.social>

    Permission is hereby granted, free of charge, to any person obtaining a
    copy of this software and associated documentation files (the "Software"),
    to deal in the Software without restriction, including without limitation
    the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and/or sell copies of the Software, and to permit persons to whom the
    Software is furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included
    in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
    THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.
]]


local S = subtitles.S;


local usage = '[on|off|modes|version|<mode>]';
minetest.register_chatcommand('subtitles',
{
    description = S'Manages your subtitle preferences.';
    params      = usage;
    func =
    function(name, param)
        param = param:trim();
        local agent = subtitles.get_agent(name);
        if param == '' then
            -- /subtitles
            subtitles.show_menu(name);
        elseif param == 'on' then
            -- /subtitles on
            agent:set_enabled(true);
        elseif param == 'off' then
            -- /subtitles off
            agent:set_enabled(false);
        elseif param == 'modes' then
            -- /subtitles modes
            for __, impl in ipairs(subtitles.SubtitleDisplay.implementations) do
                minetest.chat_send_player(name, ('%-12s%s'):format(impl.NAME, impl.TITLE));
            end;
        elseif param == 'version' then
            -- /subtitles version
            minetest.chat_send_player(name, subtitles.ABOUT);
        elseif subtitles.SubtitleDisplay.get_by_name(param) then
            -- /subtitles <mode>
            agent:set_display_name(param);
        else
            -- ☹
            minetest.chat_send_player(name, S('Invalid option: ‘@1’.', param));
            minetest.chat_send_player(name, S('Usage: /subtitles @1', usage));
        end;
    end;
});
