-- Befehl zum Öffnen des Formulars
minetest.register_chatcommand("set_hearts", {
    params = "[player_name]",
    description = "Opens a form to set hearts (HP) for yourself or another player.",
    privs = {server = true}, -- Nur Spieler mit 'server'-Privileg können diesen Befehl ausführen
    func = function(name, param)
        local target = param ~= "" and param or name -- Bestimme den Zielspieler (oder verwende den eigenen Namen)
        if not minetest.get_player_by_name(target) then
            return false, "Player not found!"
        end

        -- Formular anzeigen
        minetest.show_formspec(name, "change_hearts:form", 
            "size[6,3]" ..
            "field[0.5,1;5.5,1;hp;Set HP for player '" .. target .. "';]" ..
            "field[0.5,2;5.5,1;extra_hearts;Extra Hearts;]" ..
            "button_exit[2,2.5;2,1;set;Set]")

        -- Speichere den Zielspieler, um ihn später zu verarbeiten
        local player = minetest.get_player_by_name(name)
        player:get_meta():set_string("target_player", target)
    end,
})

-- Eingaben aus dem Formular verarbeiten
minetest.register_on_player_receive_fields(function(player, formname, fields)
    if formname ~= "change_hearts:form" or not fields.set then
        return
    end

    local name = player:get_player_name()
    local target_name = player:get_meta():get_string("target_player")  -- Verwende 'player:get_meta()' hier
    local target_player = minetest.get_player_by_name(target_name)

    if not target_player then
        minetest.chat_send_player(name, "Target player not found.")
        return
    end

    -- HP und zusätzliche Herzen aus den Feldern des Formulars abrufen
    local hp = tonumber(fields.hp)
    local extra_hearts = tonumber(fields.extra_hearts)

    -- Überprüfen, ob die HP und extra_hearts gültige Zahlen sind und > 0
    if not hp or hp <= 0 then
        minetest.chat_send_player(name, "Invalid HP value. Must be a number greater than 0.")
        return
    end

    if not extra_hearts or extra_hearts < 0 then
        minetest.chat_send_player(name, "Invalid extra hearts value. Must be a number greater than or equal to 0.")
        return
    end

    -- Setze die Standard-HP
    target_player:set_hp(hp)

    -- Berechne die Gesamtzahl der Herzen (Standard + Extra Herzen)
    local total_hp = hp + extra_hearts -- Extra Herzen wird direkt zu den HP hinzugefügt
    
    -- Setze die Gesamt-HP des Zielspielers (über den Standardwert von 20 hinaus)
    target_player:set_hp(total_hp)

    -- Speichern der zusätzlichen Herzen in den Metadaten des Spielers
    target_player:get_meta():set_int("extra_hearts", extra_hearts)

    -- Bestätigung an den Admin und Zielspieler
    minetest.chat_send_player(name, "Set HP for " .. target_name .. " to " .. total_hp .. " (including " .. extra_hearts .. " extra hearts).")
    minetest.chat_send_player(target_name, "Your HP has been set to " .. total_hp .. " (including " .. extra_hearts .. " extra hearts) by " .. name .. ".")
end)

-- Neuer Befehl zum Auffüllen der Herzen
minetest.register_chatcommand("fill", {
    description = "Fills your hearts to the maximum value, including extra hearts.",
    func = function(name)
        local player = minetest.get_player_by_name(name)
        if not player then
            return false, "Player not found!"
        end

        -- Hole die zusätzlichen Herzen aus den Metadaten
        local extra_hearts = player:get_meta():get_int("extra_hearts") or 0

        -- Berechne die Gesamt-HP (Standard-HP von 20 + zusätzliche Herzen)
        local total_hp = 20 + extra_hearts

        -- Setze die HP des Spielers auf den Gesamtwert
        player:set_hp(total_hp)

        -- Bestätigung an den Spieler
        minetest.chat_send_player(name, "Your HP has been filled to " .. total_hp .. ".")
        return true
    end,
})

-- Alias für den Befehl "/fill"
minetest.register_chatcommand("f", {
    description = "Alias for /fill. Fills your hearts to the maximum value, including extra hearts.",
    func = function(name)
        return minetest.registered_chatcommands["fill"].func(name)
    end,
})
