minetest.register_privilege("adminfill", {
    description = "Allows using heart fill, regeneration and extra heart commands",
    give_to_singleplayer = false
})

local active_regen = {}


local function get_max_hp(player)
    local extra = player:get_meta():get_int("extra_hearts")
    return 20 + extra
end


minetest.register_chatcommand("hf", {
    params = "[player]",
    description = "Fill hearts to max HP",
    privs = {adminfill = true},
    func = function(name, param)
        local target = param ~= "" and param or name
        local player = minetest.get_player_by_name(target)
        if not player then
            return false, "Player not found."
        end

        player:set_hp(get_max_hp(player))
        return true, "Hearts filled for " .. target
    end
})

minetest.register_chatcommand("he", {
    params = "<hearts> <time>",
    description = "Give extra hearts for a limited time (seconds)",
    privs = {adminfill = true},
    func = function(name, param)
        local hearts, time = param:match("^(%d+)%s+(%d+)$")
        hearts, time = tonumber(hearts), tonumber(time)

        if not hearts or not time or hearts <= 0 or time <= 0 then
            return false, "Invalid values."
        end

        local player = minetest.get_player_by_name(name)
        local meta = player:get_meta()

        meta:set_int("extra_hearts", hearts * 2)
        meta:set_int("extra_hearts_time", time)

        player:set_hp(get_max_hp(player))
        return true, "Extra hearts granted."
    end
})

minetest.register_chatcommand("hr", {
    params = "[player] <amount> <time>",
    description = "Regenerate hearts over time (HP per second)",
    privs = {adminfill = true},
    func = function(name, param)
        local p, amount, time = param:match("^(%S+)%s+(%d+)%s+(%d+)$")
        if not p then
            amount, time = param:match("^(%d+)%s+(%d+)$")
            p = name
        end

        amount, time = tonumber(amount), tonumber(time)
        if not amount or not time or amount <= 0 or time <= 0 then
            return false, "Invalid values."
        end

        local player = minetest.get_player_by_name(p)
        if not player then
            return false, "Player not found."
        end

        local meta = player:get_meta()
        meta:set_int("regen_amount", amount)
        meta:set_int("regen_time", time)
        meta:set_int("regen_remaining", time)

        active_regen[p] = true
        return true, "Regeneration started for " .. p
    end
})


local timer = 0
minetest.register_globalstep(function(dtime)
    timer = timer + dtime
    if timer < 1 then return end
    timer = 0

    for _, player in ipairs(minetest.get_connected_players()) do
        local name = player:get_player_name()
        local meta = player:get_meta()
        local remaining = meta:get_int("regen_remaining")

        if remaining > 0 then
            local hp = player:get_hp()
            local max_hp = get_max_hp(player)

            if hp < max_hp then
                local amount = meta:get_int("regen_amount")
                player:set_hp(math.min(hp + amount, max_hp))
            end

            meta:set_int("regen_remaining", remaining - 1)
        end
    end
end)


minetest.register_globalstep(function(dtime)
    for _, player in ipairs(minetest.get_connected_players()) do
        local meta = player:get_meta()
        local t = meta:get_int("extra_hearts_time")
        if t > 0 then
            meta:set_int("extra_hearts_time", t - dtime)
            if t - dtime <= 0 then
                meta:set_int("extra_hearts", 0)
                player:set_hp(math.min(player:get_hp(), 20))
            end
        end
    end
end)
