-- For replacing all tardis_new items, nodes, values, etc with drwho_tardis versions
for name, _ in pairs(minetest.registered_nodes) do
    local split_name = {}
    --split name in modname:name
    for str in (string.gmatch(name, "([^:]+)")) do
        table.insert(split_name, str)
    end
    if split_name[1] == "drwho_tardis" then
        minetest.log("registered alias for " .. name)
        minetest.register_alias(name, "tardis_new:" .. split_name[2])
    end
end


-- Hard-Coded Aliases

-- Console Units
minetest.register_alias("tardis_new:consle_y", "drwho_tardis:console_y")
minetest.register_alias("tardis_new:consle_y_2", "drwho_tardis:console_y_2")
minetest.register_alias("tardis_new:consle_y_3", "drwho_tardis:console_y_3")
minetest.register_alias("tardis_new:consle_x", "drwho_tardis:console_x")
minetest.register_alias("tardis_new:consle_x_2", "drwho_tardis:console_x_2")
minetest.register_alias("tardis_new:consle_x_3", "drwho_tardis:console_x_3")
minetest.register_alias("tardis_new:consle_z", "drwho_tardis:console_z")
minetest.register_alias("tardis_new:consle_z_2", "drwho_tardis:console_z_2")
minetest.register_alias("tardis_new:consle_z_3", "drwho_tardis:console_z_3")
minetest.register_alias("tardis_new:consle_f", "drwho_tardis:console_f")
minetest.register_alias("tardis_new:consle_f_2", "drwho_tardis:console_f_2")
minetest.register_alias("tardis_new:consle_f_3", "drwho_tardis:console_f_3")
minetest.register_alias("tardis_new:consle_s", "drwho_tardis:console_s")
minetest.register_alias("tardis_new:consle_s_2", "drwho_tardis:console_s_2")
minetest.register_alias("tardis_new:consle_s_3", "drwho_tardis:console_s_3")
minetest.register_alias("tardis_new:consle_go", "drwho_tardis:console_go")
minetest.register_alias("tardis_new:consle_go_2", "drwho_tardis:console_go_2")
minetest.register_alias("tardis_new:consle_go_3", "drwho_tardis:console_go_3")
minetest.register_alias("tardis_new:consle_c", "drwho_tardis:console_c")
minetest.register_alias("tardis_new:consle_c_2", "drwho_tardis:console_c_2")
minetest.register_alias("tardis_new:consle_c_3", "drwho_tardis:console_c_3")
minetest.register_alias("tardis_new:consle_o", "drwho_tardis:console_o")
minetest.register_alias("tardis_new:consle_o_2", "drwho_tardis:console_o_2")
minetest.register_alias("tardis_new:consle_o_3", "drwho_tardis:console_o_3")

-- TARDIS Monitor Screen
minetest.register_alias("tardis_new:screen", "drwho_tardis:monitor")

-- Time Rotors
minetest.register_alias("tardis_new:rotor", "drwho_tardis:rotor")
minetest.register_alias("tardis_new:rotor_2", "drwho_tardis:rotor_2")
minetest.register_alias("tardis_new:rotor_3", "drwho_tardis:rotor_3")
minetest.register_alias("tardis_new:rotor_active", "drwho_tardis:rotor_active")
minetest.register_alias("tardis_new:rotor_active_2", "drwho_tardis:rotor_active_2")
minetest.register_alias("tardis_new:rotor_active_3", "drwho_tardis:rotor_active_3")

-- TARDIS Lights
minetest.register_alias("tardis_new:light", "drwho_tardis:light")
minetest.register_alias("tardis_new:light_2", "drwho_tardis:light_2")
minetest.register_alias("tardis_new:light_3", "drwho_tardis:light_3")

-- TARDIS Exterior Nodes
minetest.register_alias("tardis_new:tardis", "drwho_tardis:tardis")
minetest.register_alias("tardis_new:tardis_locked", "drwho_tardis:tardis_locked")
minetest.register_alias("tardis_new:tardis_pink", "drwho_tardis:tardis_pink")
minetest.register_alias("tardis_new:tardis_pink_locked", "drwho_tardis:tardis_pink_locked")
minetest.register_alias("tardis_new:tardis_yellow", "drwho_tardis:tardis_yellow")
minetest.register_alias("tardis_new:tardis_yellow_locked", "drwho_tardis:tardis_yellow_locked")
minetest.register_alias("tardis_new:tardis_old", "drwho_tardis:tardis_old")
minetest.register_alias("tardis_new:tardis_old_locked", "drwho_tardis:tardis_old_locked")
minetest.register_alias("tardis_new:tardis_stone", "drwho_tardis:tardis_stone")
minetest.register_alias("tardis_new:tardis_stone_locked", "drwho_tardis:tardis_stone_locked")
minetest.register_alias("tardis_new:tardis_empty", "drwho_tardis:tardis_empty")
minetest.register_alias("tardis_new:tardis_empty_locked", "drwho_tardis:tardis_empty_locked")
minetest.register_alias("tardis_new:tardis_cool", "drwho_tardis:tardis_cool")
minetest.register_alias("tardis_new:tardis_cool_locked", "drwho_tardis:tardis_cool_locked")
minetest.register_alias("tardis_new:tardis_leave", "drwho_tardis:tardis_leave")
minetest.register_alias("tardis_new:tardis_leave_locked", "drwho_tardis:tardis_leave_locked")
minetest.register_alias("tardis_new:tardis_funky", "drwho_tardis:tardis_funky")
minetest.register_alias("tardis_new:tardis_funky_locked", "drwho_tardis:tardis_funky_locked")

-- TARDIS Interior Nodes
minetest.register_alias("tardis_new:wall", "drwho_tardis:wall")
minetest.register_alias("tardis_new:wall_craftable", "drwho_tardis:wall_craftable")
minetest.register_alias("tardis_new:stone", "drwho_tardis:stone")
minetest.register_alias("tardis_new:in_door", "drwho_tardis:in_door")

-- Craftitems
minetest.register_alias("tardis_new:arton", "drwho_tardis:arton_crystal")
minetest.register_alias("tardis_new:biscut", "drwho_tardis:biscuit")
minetest.register_alias("tardis_new:shard", "drwho_tardis:azbantium_shard")
minetest.register_alias("tardis_new:azbantium", "drwho_tardis:azbantium")
minetest.register_alias("tardis_new:spacetime", "drwho_tardis:spacetime")
minetest.register_alias("tardis_new:board", "drwho_tardis:circuitry_board")
minetest.register_alias("tardis_new:bar", "drwho_tardis:dalekanium_ingot")

-- Dalekanium Tools
minetest.register_alias("tardis_new:pick_dalek", "drwho_tardis:pick_dalek")
minetest.register_alias("tardis_new:shovel_dalek", "drwho_tardis:shovel_dalek")
minetest.register_alias("tardis_new:axe_dalek", "drwho_tardis:axe_dalek")
minetest.register_alias("tardis_new:sword_dalek", "drwho_tardis:sword_dalek")

-- Other tools + weapons
minetest.register_alias("tardis_new:gaunlet", "drwho_tardis:rassilon_gauntlet")
minetest.register_alias("tardis_new:vortex", "drwho_tardis:vortex_manipulator")
minetest.register_alias("tardis_new:sonic", "drwho_tardis:sonic_screwdriver")

-- Gallifreyan Lab + Chest
minetest.register_alias("tardis_new:lab", "drwho_tardis:lab")
minetest.register_alias("tardis_new:chest", "drwho_tardis:chest")