times_travelled_in_tardis = 0 --defined in console.lua --increased by 1 every time you travel in YOUR Tardis

check_drwho_awards = function(name)
    if times_travelled_in_tardis >= 1 then
        awards.unlock(name, "drwho_tardis:travel_in_tardis") -- unlock award (travel 1)
    end
    if times_travelled_in_tardis >= 10 then
        awards.unlock(name, "drwho_tardis:travel_in_tardis_10") -- unlock award (travel 10)
    end
    if times_travelled_in_tardis >= 50 then
        awards.unlock(name, "drwho_tardis:travel_in_tardis_50") -- unlock award (travel 50)
    end
    if times_travelled_in_tardis >= 500 then
        awards.unlock(name, "drwho_tardis:travel_in_tardis_500") -- unlock award (travel 500)
    end
end

awards.register_award("drwho_tardis:get_sonic_screwdriver", {
	title = "Have you never seen a Sonic Screwdriver before?",
	description = "Obtain a Sonic Screwdriver",
    -- trigger is in the Functions Console Unit line ~185
})

awards.register_award("drwho_tardis:craft_tardis", {
	title = "Craft a TARDIS",
	description = "Craft a TARDIS",
    trigger = {
        type = "craft",
        item = "drwho_tardis:tardis_old", -- item, alias, or group
        target = 1,
    }
})

awards.register_award("drwho_tardis:place_tardis", {
	title = "Place a TARDIS",
	description = "Place down a TARDIS",
    trigger = {
        type = "place",
        node = "drwho_tardis:tardis_old", -- item, alias, or group
        target = 1,
    }
})

awards.register_award("drwho_tardis:command_summon_tardis", {
	title = "Come here!",
	description = "Summon your TARDIS using the chat command",
    -- trigger = -- Awarded in the code for the command, in init.lua around line 410.
})

awards.register_award("drwho_tardis:go_inside_tardis", {
	title = "It's bigger on the inside!",
	description = "Walk inside a TARDIS",
    --trigger is in exterior.lua in function tardis_timer around line 55
})

awards.register_award("drwho_tardis:tardis_attack", {
	title = "Threat nullified.",
	description = "Attack a nearby player using the TARDIS defense system.",
    --trigger is in console.lua in function fields.attack around line 240
})

awards.register_award("drwho_tardis:tardis_invisible_award", {
	title = "Master of disguise",
	description = "Make your TARDIS invisible",
    --trigger is in console.lua in function fields.attack around line 240
})

-- Travel in your TARDIS (1, 10, 50, 500)
awards.register_award("drwho_tardis:travel_in_tardis", {
	title = "Allons-y!",
	description = "Travel using your TARDIS",
    --if times_travelled_in_tardis >= 1 then unlock award
})

awards.register_award("drwho_tardis:travel_in_tardis_10", {
	title = "Geronimo!",
	description = "Travel inside your TARDIS 10 times",
    requires = {"drwho_tardis:travel_in_tardis",},
    --if times_travelled_in_tardis >= 10 then unlock award
})

awards.register_award("drwho_tardis:travel_in_tardis_50", {
	title = "Just passing by",
	description = "Travel inside your TARDIS 50 times",
    requires = {"drwho_tardis:travel_in_tardis_10",},
    --if times_travelled_in_tardis >= 50 then unlock award
})

awards.register_award("drwho_tardis:travel_in_tardis_500", {
	title = "My way to travel",
	description = "Travel inside your TARDIS 500 times",
    requires = {"drwho_tardis:travel_in_tardis_50",},
    --if times_travelled_in_tardis >= 500 then unlock award
})


-- Biscuit awards (1, 50, 100, 1000)
awards.register_award("drwho_tardis:eat_biscuit_1", {
	title = "It's just a normal biscuit, right?",
	description = "Eat one TARDIS Biscuit. Hint: Look at the Functions Console Unit",
    icon = "tardis_biscuit.png",
    trigger = {
        type   = "eat",
        item   = "drwho_tardis:biscuit", -- item, alias, or group
        target = 1,
    },
})

awards.register_award("drwho_tardis:eat_biscuit_50", {
	title = "They taste really good!",
	description = "Eat fifty TARDIS Biscuits in total.",
    requires = {"drwho_tardis:eat_biscuit_1",},
    icon = "tardis_biscuit.png",
    trigger = {
        type   = "eat",
        item   = "drwho_tardis:biscuit", -- item, alias, or group
        target = 50,
    },
})

awards.register_award("drwho_tardis:eat_biscuit_100", {
	title = "My favourite snack",
	description = "Eat one hundred TARDIS Biscuits in total.",
    requires = {"drwho_tardis:eat_biscuit_50",},
    icon = "tardis_biscuit.png",
    trigger = {
        type   = "eat",
        item   = "drwho_tardis:biscuit", -- item, alias, or group
        target = 100,
    },
})

awards.register_award("drwho_tardis:eat_biscuit_1000", {
	title = "Is this even healthy?",
	description = "Eat one thousand TARDIS Biscuits in total.",
    requires = {"drwho_tardis:eat_biscuit_100",},
    icon = "tardis_biscuit.png",
    trigger = {
        type   = "eat",
        item   = "drwho_tardis:biscuit", -- item, alias, or group
        target = 1000,
    },
})