-- Attempt to make a basic Dalek using Mobs Redo API
-- [8] Brown Dalek (new who) (can fly)
-- [110] Grey Dalek (classic who) (can't fly)




-- Brown New Who Dalek
mobs:register_mob("drwho_tardis:dalek", {
    type = "monster",
    passive = false,
    armor = 50, -- Takes 50% of damage usually dealt
    hp_min = 85,
    hp_max = 90, -- Spawns with between 85 and 90 hp

    --attack
    reach = 6, -- Shoots when within 6 nodes of the target
    attack_monsters = true,
    attack_animals = true,
    attack_npcs = true,
    attack_players = true,
    attack_type = "shoot",
    arrow = "drwho_tardis:glaser", --Arrow object it attacks with (laser)
    shoot_interval = 7, -- Shoots once every 7 seconds

    group_attack = true, -- Attacks in groups
    group_helper = "drwho_tardis:classic_dalek", -- Attacks alongside classic dalek

    immune_to = { -- Immune to wood tools
		{"default:pick_wood", 0},
		{"default:shovel_wood", 0},
		{"default:axe_wood", 0},
		{"default:sword_wood", 0}
	},

    shoot_offset = 1,
	collisionbox = {-0.4, -0.65, -0.4, 0.4, 0.6, 0.4},
    selectionbox = {-0.4, -0.65, -0.4, 0.4, 0.6, 0.4},

    drops = {
        {
        name = "drwho_tardis:dalekanium_ingot",
        chance = 1, -- Always drops
        min = 2,
        max = 4, -- Drop between 2 and 4 Dalekanium Ingots
        },
    },

    -- Mechanics
    pathfinding = 1, -- Chase player
    view_range = 30, -- Can see target when within 30 nodes
    pushable = false, -- Does not get pushed when attacked
    floats = 0, -- Sinks in water
    fly = true, -- Can fly
    fly_in = "air", -- Flies in air
    keep_flying = false, -- hopefully makes them come back to the ground
    follow = {"group:sonic"}, -- Follow someone if they are holding a sonic
    makes_footstep_sound = false,
	walk_velocity = 1.7,
	run_velocity = 3,
    jump = false,
	water_damage = 1, -- Slowly dies from drowning (1 hp / second)
	lava_damage = 2,
	light_damage = 0,

    -- Visual
    blood_amount = 0, -- Does not spurt out blood
    visual = "mesh",
    mesh = "dalek.b3d",
    textures = { {"scifi_dalek.png"}, },
    visual_size = {x = 2, y = 2},
    randomly_turn = true, -- Turn to look at player, and turn randomly otherwise
    animation = { -- All copied from SciFi Mobs code
		speed_normal = 2,
		speed_run = 3,
		walk_start = 1,
		walk_end = 30,
		stand_start = 30,
		stand_end = 50,
		run_start = 1,
		run_end = 1,
		punch_start = 50,
		punch_end = 60,

	},

    sounds = {
        war_cry = "Shortened_Dalek_Voice",-- Played when attacked and when attacking. 
        shoot = "Laser", -- Laser sound
        random = "Dalek_Voice"
    },
})

-- Spawn Egg
mobs:register_egg("drwho_tardis:dalek", "Dalek", "scifi_dalec_inv.png", 1)

-- Natural Spawning
mobs:spawn({
    name = "drwho_tardis:dalek",
    nodes = { -- The nodes it can spawn on
        "group:dirt", 
        "group:stone", 
        "group:sand", 
        "default:mossycobble", -- In dungeons 
        "default:cobble"
    }, 
    active_object_count = 2, -- Can spawn up to 2 Daleks at a time
    chance = 130000, -- default is 5000. Should be at or above 60000, except when testing.
    -- Everything else is handled by the default values
 })


-- Grey Classic Who Dalek
 mobs:register_mob("drwho_tardis:classic_dalek", {
    type = "monster",
    passive = false,
    armor = 50, -- Takes 50% of damage usually dealt
    hp_min = 80,
    hp_max = 85, -- Spawns with between 80 and 85 hp

    --attack
    reach = 6, -- Shoots when within 6 nodes of the target
    attack_monsters = true,
    attack_animals = true,
    attack_npcs = true,
    attack_players = true,
    attack_type = "shoot",
    arrow = "drwho_tardis:glaser", --Arrow object it attacks with (laser)
    shoot_interval = 7, -- Shoots once every 7 seconds

    group_attack = true, -- Attacks in groups
    group_helper = "drwho_tardis:dalek", -- Attacks alongside classic dalek

    immune_to = { -- Immune to wood tools
		{"default:pick_wood", 0},
		{"default:shovel_wood", 0},
		{"default:axe_wood", 0},
		{"default:sword_wood", 0}
	},

    shoot_offset = 1,
	collisionbox = {-0.4, -0.65, -0.4, 0.4, 0.6, 0.4},
    selectionbox = {-0.4, -0.65, -0.4, 0.4, 0.6, 0.4},

    drops = {
        {
        name = "drwho_tardis:dalekanium_ingot",
        chance = 1, -- Always drops
        min = 2,
        max = 3, -- Drop between 2 and 3 Dalekanium Ingots
        },
    },

    -- Mechanics
    pathfinding = 1, -- Chase player
    view_range = 30, -- Can see target when within 30 nodes
    pushable = false, -- Does not get pushed when attacked
    floats = 0, -- Sinks in water
    fly = false, -- Can't fly
    follow = {"group:sonic"}, -- Follow someone if they are holding a sonic
    makes_footstep_sound = false,
	walk_velocity = 1.7,
	run_velocity = 3,
    jump = false,
	water_damage = 1, -- Slowly dies from drowning (1 hp / second)
	lava_damage = 2,
	light_damage = 0,

    -- Visual
    blood_amount = 0, -- Does not spurt out blood
    visual = "mesh",
    mesh = "dalek.b3d",
    textures = { {"scifi_dalek1.png"}, },
    visual_size = {x = 2, y = 2},
    randomly_turn = true, -- Turn to look at player, and turn randomly otherwise
    animation = { -- All copied from SciFi Mobs code
		speed_normal = 2,
		speed_run = 3,
		walk_start = 1,
		walk_end = 30,
		stand_start = 30,
		stand_end = 50,
		run_start = 1,
		run_end = 1,
		punch_start = 50,
		punch_end = 60,

	},

    sounds = {
        war_cry = "Shortened_Dalek_Voice", -- Played when attacked and when attacking. 
        shoot = "Laser", -- Laser sound
        random = "Dalek_Voice"
    },
})

-- Spawn Egg
mobs:register_egg("drwho_tardis:classic_dalek", "Classic Dalek", "scifi_dalec_inv.png", 1)

-- Natural Spawning
mobs:spawn({
    name = "drwho_tardis:clasic_dalek",
    nodes = { -- The nodes it can spawn on
        "group:dirt", 
        "group:stone", 
        "group:sand", 
        "default:mossycobble", -- In dungeons 
        "default:cobble"
    }, 
    active_object_count = 2, -- Can spawn up to 2 Daleks at a time
    chance = 130000, -- default is 5000. Should be at or above 130000, except when testing.
    -- Everything else is handled by the default values
 })


-- Laser
-- Adapted from the Glaser arrow from Scifi Mobs, under LGPL
mobs:register_arrow("drwho_tardis:glaser", {
    visual = "sprite",
    visual_size = {x = 0.5, y = 0.5},
    textures = {"scifi_mobs_glaser.png"},
    velocity = 50, -- Used to be 24
    tail = 1, -- enable tail
    tail_texture = "scifi_mobs_glaser.png",
    glow = 6, -- Let there be light!
 
    hit_player = function(self, player)
       player:punch(self.object, 1.0, {
          full_punch_interval = 1.0,
          damage_groups = {fleshy = 12},
       }, nil)
    end,
    
    hit_mob = function(self, player)
       player:punch(self.object, 1.0, {
          full_punch_interval = 1.0,
          damage_groups = {fleshy = 13},
       }, nil)
    end,
 
    hit_node = function(self, pos, node)
       mobs:explosion(pos, 1, 1, 1)
    end,
 })