-- CONTENTS
-- TARDIS exterior functions
-- drwho_tardis:register_tardis_exterior() API
-- TARDIS Node Definitions (using API)

local S = minetest.get_translator("drwho_tardis")

-- TARDIS EXTERIOR FUNCTIONS
local tardis_on_place = function(pos, placer, itemstack, pointed_thing)
	if placer:get_player_name() == "" then return else
		local meta = minetest.get_meta(pos)
		local name = placer:get_player_name()
		local timer = minetest.get_node_timer(pos)
		if data:get_string(name.."in_pos") == "" then
			data:set_string(name.."out_pos", minetest.serialize(pos)) --set exterior position
			pos.y = pos.y-300
			minetest.place_schematic(pos, minetest.get_modpath("drwho_tardis") .. "/schems/console_room.mts")
			pos.y = pos.y+2
			pos.x = pos.x+7
			pos.z = pos.z+16
			local ometa = minetest.get_meta(pos)
			local otimer = minetest.get_node_timer(pos)
			otimer:start(0.2) --start door timer (in case it doesn't start on construct)
			ometa:set_string("id", name) --set door id
			meta:set_string("id", name) -- set exterior id
			data:set_string(name.."in_pos", minetest.serialize(pos)) --set interior position
			data:set_int(name.."power", 0) --set power
			data:set_int(name.."factor", 1) -- set travel factor
			data:set_string(name.."look", "drwho_tardis:tardis_old") --set skin
			data:set_int(name.."y_dest", 0)
			data:set_int(name.."x_dest", 0)
			data:set_int(name.."z_dest", 0)
			data:set_string(name.."way1", minetest.serialize({x=0, y=0, z=0}) )
			data:set_string(name.."way2", minetest.serialize({x=0, y=0, z=0}) )
			data:set_string(name.."way3",minetest.serialize({x=0, y=0, z=0}) )
			data:set_string(name.."r_pos", "") 
			timer:start(0.2)
		else minetest.set_node(pos, {name = "air"}) minetest.add_item(pos, "drwho_tardis:tardis_old") end
	end
end

-- Check if there are any players or mobs entering a TARDIS and teleport them
local tardis_timer = function(pos)
	local objs = minetest.get_objects_inside_radius(pos, 0.9)
	--for idx,obj in pairs(objs) do -- loop incase there are multiple objs there at once
	local obj = objs[1]
		if obj == nil then return true else --only do code if there is something there
			if obj:is_player() then -- if obj is a player
				local meta = minetest.get_meta(pos)
				local pmeta = obj:get_meta()
				local id = meta:get_string("id")
				local go_pos = minetest.deserialize(data:get_string(id.."in_pos"))
				local name = obj:get_player_name()
				go_pos.z = go_pos.z-1
				obj:set_look_horizontal( math.rad( 180 ))
				obj:set_look_vertical( math.rad( 0 ))
				obj:set_pos(go_pos)
				if minetest.get_modpath("awards") then
					awards.unlock(name, "drwho_tardis:go_inside_tardis") -- unlock award
				end
				pmeta:set_string("id", id)
			else -- if obj is not a player (probably a mob)
				local meta = minetest.get_meta(pos)
				local id = meta:get_string("id")
				local go_pos = minetest.deserialize(data:get_string(id.."in_pos"))
				go_pos.z = go_pos.z-2
				obj:set_pos(go_pos)
			end
		end
		return true
	--end
end

-- Global definition for the API functions
drwho_tardis = {}

-- See API.md for more information about this function
function drwho_tardis:register_tardis_exterior(def) 
	data = minetest.get_mod_storage()
	-- REQUIRED: {name, texture}
	local name = "_"..def.name -- e.g. "_blue" if def.name == "blue"
	
	if def.name == "" then 
		name = ""  -- ONLY FOR THE DEFAULT BLUE TARDIS
		def.name = "blue"
	end 
	local texture = def.texture
	-- OPTIONAL: {light, description, drawtype, title, groups}
	local light = def.light or 10 -- In case one doesn't want it to glow
	local description = def.description or S("Tardis") -- allow for custom description titles
	local drawtype = def.drawtype or "mesh" -- default to mesh
	local title = def.title or name -- Title to be shown on exterior selector
	local groups = def.groups or {not_in_creative_inventory = 1, tardis = 1}

	local exteriorlist = minetest.deserialize(data:get_string("exteriorlist")) or {}
	table.insert(exteriorlist, {def.name, title})
	data:set_string("exteriorlist", minetest.serialize(exteriorlist))

	-- Register normal TARDIS
	minetest.register_node("drwho_tardis:tardis"..name, {
		description = description,
		tiles = {texture},
		drawtype = drawtype,
		mesh = "tardis_2.obj", -- Only used when drawtype == "mesh"
		node_box = {type = "fixed", fixed = { { -0.5, -0.5, -0.5, 0.5, 1.5, 0.5 } }}, -- Only used when drawtype == "nodebox"
		selection_box = {type = "fixed", fixed = { { -0.5, -0.5, -0.5, 0.5, 1.5, 0.5 } }},
		collision_box = {type = "fixed", fixed = { { 0.48, -0.5,-0.5,  0.5,  1.5, 0.5}, {-0.5 , -0.5, 0.48, 0.48, 1.5, 0.5}, {-0.5,  -0.5,-0.5 ,-0.48, 1.5, 0.5}, { -0.8,-0.6,-0.8,0.8,-0.48, 0.8} }},
		light_source = light,
		groups = groups,
		after_place_node = tardis_on_place,
		diggable = false,
		on_timer = tardis_timer
	})
	-- Register locked TARDIS
	minetest.register_node("drwho_tardis:tardis"..name.."_locked", {
			description = title.." (locked)",
			tiles = {texture},
			drawtype = drawtype,
			mesh = "tardis_2.obj", -- Only used when drawtype == "mesh"
			node_box = {type = "fixed", fixed = { { -0.5, -0.5, -0.5, 0.5, 1.5, 0.5 } }}, -- Only used when drawtype == "nodebox"
			selection_box = {type = "fixed", fixed = { { -0.5, -0.5, -0.5, 0.5, 1.5, 0.5 } }},
			collision_box = {type = "fixed", fixed = { { -0.5, -0.5, -0.5, 0.5, 1.5, 0.5 } }},
			light_source = 10,
			groups = {not_in_creative_inventory = 1, tardis_locked = 1},
			diggable = false
	})
	if drawtype ~= "nodebox" and drawtype ~= "mesh" then
		minetest.chat_send_all(S("[ERROR] - TARDIS exterior registration was not given a proper drawtype because the drawtype was either not specified or is not equal to 'nodebox' or 'mesh'. ").. 
		S("See API.md of drwho_tardis for more information."))
	end
end

--------------------
--NODE DEFINITIONS--
--------------------

-- Normal mesh drawtypes
drwho_tardis:register_tardis_exterior({
	name = "", -- Empty because it is the default TARDIS
	texture = "tardis_main.png", -- BLUE
	title = "Blue",
})
drwho_tardis:register_tardis_exterior({
	name = "pink", 
	texture = "tardis_pink.png",
	title = "Pink",
})
drwho_tardis:register_tardis_exterior({
	name = "yellow", 
	texture = "tardis_yellow.png",
	title = "Yellow",
})
drwho_tardis:register_tardis_exterior({
	name = "green", 
	texture = "tardis_green.png",
	title = "Green"
})
drwho_tardis:register_tardis_exterior({
	name = "old", 
	texture = "tardis_old.png",
	title = "Default",
	groups = {tardis = 1} -- Be not in creative inventory
})
drwho_tardis:register_tardis_exterior({
	name = "cool", 
	texture = "tardis_cool.png",
	light = 0,
	title = "Classic",
})
drwho_tardis:register_tardis_exterior({
	name = "funky", 
	texture = "tardis_funky.png",
	title = "Funky",
})

-- Nodebox drawtypes
drwho_tardis:register_tardis_exterior({
	name = "leave", 
	texture = "default_leaves.png",
	drawtype = "nodebox",
	light = 0,
	title = "Leaves",
})
drwho_tardis:register_tardis_exterior({
	name = "empty", 
	texture = "empty.png",
	drawtype = "nodebox",
	light = 0,
	title = "Invisible"
})
drwho_tardis:register_tardis_exterior({
	name = "stone", 
	texture = "default_stone.png",
	drawtype = "nodebox",
	light = 0,
	title = "Stone"
})