# DrWho_Tardis API

This mod has a couple API functions to make life easier for developers of it, and also support other mods adding their own things to it.

Please note: 

- The functions use a colon `:`, not a dot `.` after `drwho_tardis`

- We will refer to the player piloting the TARDIS as the pilot. 

- These API may change in future updates

## `drwho_tardis:register_tardis_exterior(def)`

Makes it very simple to add another TARDIS exterior, which is also added to the exterior console unit.

### Parameters

- `def`: A table with all possible parameters in it:
  
  **Required:**
  
  - `name`: The short name for the exterior. It will be inserted into the itemstring as so: `drwho_tardis:tardis_<name>` and `drwho_tardis:tardis_<name>_locked`.
  
  - `texture`: The texture used for the TARDIS. Defaults to using the "mesh" format, just use one of the existing textures as a base. If you want to use "nodebox" to draw a node's texture on it, set that in `drawtype`.
  
  **Optional:**
  
  - `light`: (default: 10): Allows you to make the exterior glow less, more, or not at  all (0). Make sure it is a value between 0 and 14.
  
  - `description`: (default: "Tardis"): The player-facing title of the actual item. Not recommended to be changed.
  
  - `title`: (default: `name`^): The title of the exterior when listed on the exterior console unit. Defaults to `name`, but that is usually all lowercase so it is a good idea to set this with a capitalised word.
  
  - `drawtype`: (default: "mesh"): As mentioned above, this allows the modder to set the drawtype to "nodebox". Then you can pass a single node texture to `texture` which will be put all over the TARDIS. This is used in the default Stone, Leaves and Invisible textures.
  
  - `groups`: THIS IS ONLY USED BY THE DEFAULT TARDIS TEXTURE! The one that is avaliable in the creative inventory, so instead of the default `{not_in_creative_inventory = 1, tardis = 1}`, it is only passed `{tardis = 1}`. If you would like to use this, make sure you still put `tardis = 1` in there, and keep in mind it only affects the unlocked version of it.

### Additional notes

- Does not return anything. 
- Currently, only default exteriors are selectable from the console unit.

## `drwho_tardis:register_sonic_device(def)`

Registers a sonic device, whether that be a screwdriver or lipstick (Sarah Jane's, planned). Any item that has the functionality of a sonic.

### Parameters

- `def` is a table with all the parameters in it:

**Required:**

- `gentype`: Tell the function if you are setting your own texture (`custom`), choosing from the 1/3 textures (`choose`), or making it random (`random`). 
  
  - If you do the arithmetic for randomising the numbers before giving the values to the function, set it to `choose`.

- `sonictype`: Either "screwdriver" or a custom one, such as "lipstick". It will default to "screwdriver" but should be specified.

- `no_creative`: If `true`, the new sonic device will *not* appear in the creative inventory. If `false`, it will appear in the creative inventory. 
  
  - This can be useful for player-only sonics, or if you are registering lots that don't need to flood the inventory.

**Optional:**

- `texture`: If the modder wants to use a custom texture that does not use the sonic screwdriver section textures. If so, a `customname` and `customdescription` must be given.

- `top`: The number for what texture to be used in the top third of a sonic, defaults to random.

- `mid`: The number for what texture to be used in the middle third of a sonic, defaults to random.

- `bottom`: The number for what texture to be used in the bottom third of a sonic, defaults to random.

- `customname`: This is the itemstring. It defaults to `"drwho_tardis:sonic_"..sonictype.."_"..top.."_"..mid.."_"..bottom`, so if you want it to be part of your mod's modname space, you must use this value, as well as appending the modname with `:` to tell the engine to not care that the modname isn't `drwho_tardis` even though it appears to be registered from that because of the function. 
  
  - For example, `:extra_sonics:sonic_playingcards_3` if, for some reason you wanted a pack of cards to have sonic ability.  Actually, that doesn't sound like a bad idea...



### Return value

Returns the full `item_name`.

- It may include the extra `:` if you put your own modname in the `customname`, if so you can remove it with `item_name = item_name:match"^.-:(.+)"`.

### Additional notes

* A different API may be added in the future that allows custom sonic functions to be added as long as they don't break the default ones.
