[![Minetest](https://img.shields.io/badge/Minetest-5.0+-blue.svg)](https://www.minetest.net) [![License](https://img.shields.io/badge/License-GPLv3%20and%20CC%20BY--SA%204.0-green.svg)](LICENSE.md) [![Join the community](https://img.shields.io/badge/mtrx.nz-join_community-teal?style=flat-square&logo=matrix)](https://matrix.to/#/#drwho_tardis:mtrx.nz) [![ContentDB](https://content.minetest.net/packages/Skivling/drwho_tardis/shields/downloads/)](https://content.minetest.net/packages/Skivling/drwho_tardis/)

# DrWho_Tardis

A [Minetest](https://minetest.net) mod that adds various items, nodes, Daleks, and a working TARDIS from the sci-fi show Doctor Who. Forked from PiDemon's `tardis_new`, which is unmaintained.

For a more detailed explanation of everything included, see the [**wiki**](https://codeberg.org/Skivling/DrWho_Tardis/wiki). Download from the in-game content manager, [ContentDB](https://content.minetest.net/packages/skivling/drwho_tardis), or here on Codeberg.

## Features:

- **TARDISes**: Simply craft a tardis, place it on the ground, and walk through the door.  You'll have to craft seperate console units to control and fly your tardis.
- Console Units: Console units control your tardis. Place them in your tardis, and right click on them to use them.  Most consle units should be pretty self-explainatory if you understand X/Y/Z coordinates.
- **Daleks**: The enemy of the TIme Lords, now in Minetest! Brown variants can fly, and Gray ones can't. They have high health, shield, deal a lot of damage and can also set things on fire and blow things up. Turn off 'Mob Griefing' in Mobs Redo API settings to disable that.
- **Cybermen**: You will also be able to find Cybermen, who are weaker than Daleks but will still try to kill you. They drop steel ingots.
- Time Rotor: Used to power the tardis. It will slowly generate power that is used for all tardis operations. Having multiple time rotors in your tardis will not generate power -faster. Right click on it to see how much power your Tardis has.
- Monitor: Displays your current position, destination, power, ect. RIght click to view.
- **Sonic Screwdriver**: Can be created from a button on the fuctions console unit. You get a randomized texture, out of 4 textures for each third of the screwdriver,  creating the possibility for 64 (4^3) unique combinations.
- Gallifreyan Lab: Used to create arton crytals (from mese) and compressed space time (from diamond blocks). It does not require fuel, but is notably bad for your health!
- Vortex Manipulator: Easy time travel (also notably bad for your health)
- **Dalekanium Tools**: Better than diamond, Dalekanium made from azbantium, gold, steel, and obsidian, or dropped from Daleks.
- **Dalekanium Armor**: Protect yourself against all foes, including Daleks. Very strong armor.
- Gaunlet of Rassilon: A powerful weapon, once held by [Rassilon](https://tardis.fandom.com/wiki/Rassilon) himself.
- **Achievements**: Using the `awards` API mod, there are several achievements for you to reach while playing.
- Gallifreyan Chests: Very large, very expensive. 
- Chat command (/summon_tardis) can be used to summon your Tardis (if you have the `bring` privelege).
- See TODO.md to see what new features are planned.

### Console Units:

- XYZ Axis Console Units: Use this to set your 
  destination. There are 6 levers - increase and decrease for each X, Y, 
  and Z. Clicking these will change the destination coordinate by the 
  Travel Factor, which is set at the top of the screen.
- Exterior Control Console Unit (Chameleon Circuitry): Changes how the outside of your Tardis looks.
- Warp Lever Console Unit: The go button. Teleports your Tardis to your set destination.
- Waypoint Console Unit: Used to set up to three waypoints. Using a waypoint will automatically set your destination to the position the Tardis was in when the waypoint was set. Useful for travelling back to home base or deep underground for mining.
- Functions Console Unit: Can locate a player, create diamond tools, biscuits, sonic screwdrivers, and heal you.
- Find Biome Console Unit: Allows you to travel to a 
  specific biome, and shows a list of all biomes in your world on the 
  right. It will not work 100% of the time, but should be good enough.
- Tardis Monitor Screen: Displays your current position, destination, power, etc. RIght click to view.

### Sonic Screwdriver Functions:

- Lockpick: Click on a steel door/trap door to unlock it (even if it isn't yours!)
- Summoning: Sneak and click a block to summon your tardis (requires three power)
- Sonic Knock Back: Sneak and click to an entity to knock the entity backwards (works better the farther away you are from the entity)
- Sand Conversion: Click (and not sneak) on sand to convert it to silver sand.
- Glass Conversion: Click on glass to turn it into obsidian glass.
- Obsidian Reversal: Click on obsidian to turn it into lava.
- **Mesecon Hacking**: Click on mesecon wires to turn them on/off.
- Digiline Hacking: Click on digiline wires to send messages through them. (only works if no message currently is being sent to the channel)
- Scan: Click (and not sneak) on an entity to scan it.
- Locking: Click on your Tardis to lock/unlock it.
- Accelerated Growth: Click on dirt to grow grass on it (in a later update growing crops with be supported).
- **Unique, randomized texture**: Currently there are 4 textures for each third of the screwdriver, and they are all randomised together to create the possibility for 64 (4^3) unique combinations when you create the Sonic Screwdriver.

### Gallifreyan Lab Recipes

- Diamond Blocks to Compressed Space Time.
- Diamonds to Azbantium Shards
- Mese Blocks to Diamonds
- Mese to Arton Crystals
- Copper Ingot to Steel Ingots
- Coal Lump to Tin Lumps
- Steel Block to Mese Crystals
- Dirt to Coal Lumps

### Dependencies

###### Required:

- `default` for crafting recipes and basic functionality. This mod is made for MTG and ones based on it, none others. MineClone support may be added in the future.

- `mobs` (Mobs Redo API) is used to make the Daleks and Cybermen.

- `findbiome` is used to make the Find Biome Console Unit work.
  
  - `biomeinfo` is required if you use v6 mapgen

###### Recommended, but optional:

- `3d_armor` for the Dalekanium Armor set. Makes fighting Daleks and Cybermen a lot easier!

- `doors` so that the Sonic Screwdriver can interact with, lock and unlock doors and trapdoors. Included in MTG by default.

###### Optional:

- `awards` to get achievements in game.

- `pick_axe_tweaks` support for Dalekanium Pickaxe

- `toolranks` support for Dalekanium tools.

- `mesecons` to allow for Mesecon Hacking with the Sonic.

- `digilines` to be able to use the Sonic to send messages through them.

- `subtitles` for sound effects.

### Known Bugs

- Some mobs die when they enter the Tardis.
- Gallifreyan Chests sometimes have to be double clicked to open.
- Cave generation occasionally breaks through the Tardis.
  - Will be fixed when the TARDIS interiors are in a separate dimension.
- Sometimes the TIme Rotors are not able to generate power.
  - To fix this, just break it and re-place it.

##### Migrate from `tardis_new` to `drwho_tardis`

A full step-by-step guide for migrating can be found on the Wiki [here](https://codeberg.org/Skivling/DrWho_Tardis/wiki/Migrating-from-%60tardis_new%60).

### Contribute + Follow Development

- Star and follow this repository.

- Join the Matrix space: [#drwho_tardis:mtrx.nz](https://matrix.to/#/#drwho_tardis:mtrx.nz)
  
  - General: For general discussions about the mod, Doctor Who in Minetest, and anything else that makes sense.
  
  - Dev: For developer discussions about the mod. 
  
  - Announcements: Any announcements I feel need to be shared. These are also put on Mastodon.
  
  - All the rooms are end-to-end encrypted, so it might take a bit of time to synchronise messages when you join. Don't message in the first 20+ minutes to aid this and avoid sending messages incorrectly.

- Submit bug reports - either here on Codeberg or on Matrix. The more detail the better, it would be best to have the full error message. Make sure you are running the latest version of MInetest first though.

- Help write the wiki / documentation. Ask in the matrix dev channel and we'll give you some pages to work on. This will be barely written by the core devs as we focus on the mod itself.

- Help translate - there are 143 strings, you will find the template in the locale folder. Search up translating on the [Minetest wiki](https://wiki.minetest.net) for more info.

- Help design textures - It would be great to have better Tardis textures, console sets, etc. 

### Screenshots & Promotional Images

<p align='left'>  
 <img src='images/Fight Daleks.jpg' width='24%'/>  
 <img src='images/Dalekanium Tools, Armour, and more.jpg' width='24%'/>    
 <img src='images/Customize your Tardis.jpg' width='24%'/>
 <img src='screenshot.png' width='24%'/>
</p>

### License Details

This mod is fan-made Doctor Who content. It is the work of Skivling and other individual contributors, working from the previous work of PiDemon. It is not endorsed by, associated with, or approved by the BBC. Doctor Who and all related Trademarks are property of the BBC and no infringement is being attempted.

---

`DrWho_Tardis` Minetest Mod
Copyright (C) 2024 Skivling

This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details in the [LICENCE.txt](https://codeberg.org/Skivling/DrWho_Tardis/src/branch/main/LICENSE.txt).

-----

It was forked from [Tardis_New](https://github.com/PiDemon/Taridis_New), under the MIT License.

---

All textures, models and logos included in the `DrWho_Tardis` Minetest Mod are licensed under CC BY-SA 4.0, unless otherwise noted. To view a copy of this license, visit http://creativecommons.org/licenses/by-sa/4.0/.
Individual asset license details are avaliable on [asset-info.md](https://codeberg.org/Skivling/DrWho_Tardis/src/branch/main/asset-info.md), which includes who created it, the original name and the source of the asset.

---

More license details and a copy of the license can be found in LICENSE.txt
