-- CONTENTS
-- Init for dependencies and lua files
-- Special Item registrations and logic
--      e.g. sonic screwdriver, vortex manipulator

local S = minetest.get_translator("drwho_tardis")

-- INIT FOR DEPENDENCIES AND LUA FILES

local MP = minetest.get_modpath("drwho_tardis")

dofile(MP .. "/exterior.lua") -- TARDIS Exterior logic and node definitions
dofile(MP .. "/interior.lua") -- TARDIS Interior logic and node definitions
dofile(MP .. "/console.lua") -- TARDIS Functions, Console logic and console node definitions
dofile(MP .. "/tools.lua") -- Dalekanium Tools 
dofile(MP .. "/craftitems.lua") -- All Craftitems
dofile(MP .. "/recipes.lua") -- Most Recipes
dofile(MP .. "/sonic.lua") -- Sonic Registration API and default sonic devices

-- Doctor Who Monsters (can be disabled in settings)
if minetest.settings:get_bool("drwho_tardis.enable_daleks") == false then
	return
else dofile(MP .. "/dalek.lua") end -- Daleks

if minetest.settings:get_bool("drwho_tardis.enable_cybermen") == false then
	return
else dofile(MP .. "/cybermen.lua") end -- Cybermen

-- Migration logic (tardis_new to drwho_tardis)
-- aliases for items and nodes
-- modstorage is not migrated
dofile(MP .. "/migration.lua")

-- Dalekanium Armor (if 3d_armor is enabled)
if minetest.get_modpath("3d_armor") then
	dofile(MP .. "/armor.lua")
end

-- Various achievements (if awards is enabled)
if minetest.get_modpath("awards") then
	dofile(MP .. "/awards.lua")
end


-- Toolranks support
if minetest.get_modpath("toolranks") then

    minetest.override_item("drwho_tardis:sword_dalek", {
        description = toolranks.create_description(S("Dalekanium Sword"), 0, 1),
        original_description = S("Dalekanium Sword"),
        after_use = toolranks.new_afteruse
    })
    minetest.override_item("drwho_tardis:pick_dalek", {
        description = toolranks.create_description(S("Dalekanium Pickaxe"), 0, 1),
        original_description = S("Dalekanium Pickaxe"),
        after_use = toolranks.new_afteruse
    })
    minetest.override_item("drwho_tardis:axe_dalek", {
        description = toolranks.create_description(S("Dalekanium Axe"), 0, 1),
        original_description = S("Dalekanium Axe"),
        after_use = toolranks.new_afteruse
    })
    minetest.override_item("drwho_tardis:shovel_dalek", {
        description = toolranks.create_description(S("Dalekanium Shovel"), 0, 1),
        original_description = S("Dalekanium Shovel"),
        after_use = toolranks.new_afteruse
    })
end


-- Pickaxe-Tweaks support
if minetest.get_modpath("pick_axe_tweaks") then
	pick_axe_tweaks.register_pick_axes({"drwho_tardis:pick_dalek"})
end

-- Subtitles for sound effects
if minetest.get_modpath("subtitles") then
	subtitles.register_description('Dalek_Voice', S('"You will obey the Daleks!"')) -- Too long to fit the screen
	subtitles.register_description('Shortened_Dalek_Voice', S('"You will be exterminated!"'))
	subtitles.register_description('Laser', S('Laser blast'))
	subtitles.register_description('sonic_sound', S('Sonic Screwdriver buzzing'))
	subtitles.register_description('tardis_sound', S('Tardis travelling sound'))
end

--Data (11) : in_pos, out_pos, y_dest, x_dest, z_dest, factor, look, r_pos, waypoint1, waypoint2, waypoint3, biome_pos
data = minetest.get_mod_storage()



-- SPECIAL ITEM REGISTRATION AND LOGIC


-- gauntlet of rassilon
minetest.register_tool("drwho_tardis:rassilon_gauntlet", {
	description = S("Gaunlet of Rassilon"),
	inventory_image = "gauntlet_rassilon.png",
	stack_max=1,
	on_use = function(itemstack, player, pointed_thing)
		if pointed_thing.type == "object" then
			local obj = pointed_thing.ref
			obj:punch(player, nil, {full_punch_interval = 0.1, damage_groups = {fleshy=500}}, nil)
			itemstack:set_wear(itemstack:get_wear() + 4500) return itemstack
		end
	end
})


-- vortex manipulator
local function get_formspec_vortex()
    return "size[10,10]"..
		"field[1,1;8,1;teleport_x;X-Cord;0]"..
		"field[1,3;8,1;teleport_y;Y-Cord;0]"..
		"field[1,5;8,1;teleport_z;Z-Cord;0]"..
		"image_button_exit[1,6.5;3,3;dial_1.png;teleport; ;false;false;dial_2.png]"
end
minetest.register_tool("drwho_tardis:vortex_manipulator", {
	description = S("Vortex Manipulator"),
	inventory_image = "vortex_manipulator.png",
	stack_max=1,
	on_use = function(itemstack, player, pointed_thing)
		minetest.show_formspec(player:get_player_name(), "drwho_tardis:vortex_formspec", get_formspec_vortex() )
		itemstack:set_wear(itemstack:get_wear() + 3000) return itemstack
	end
})


-- TARDIS Monitor Screen
local function get_formspec_screen(power, posx, posy, posz, desx, desy, desz, block, id)
	local power = S("Tardis Energy Banks: @1", power) -- Tardis Energy Banks: 8
	local cur = S("Current Position: @1, @2, @3", posx, posy, posz)
	local dest = S("Destination: @1, @2, @3", desx, desy, desz)
	local block = block
	local id = S("Tardis Owner: @1", id) -- Tardis Owner: <name>
    return "size[10,10]"..
		"label[1,1;"..minetest.formspec_escape(power).."]"..
		"label[1,2.5;"..minetest.formspec_escape(cur).."]"..
		"label[1,4;"..minetest.formspec_escape(dest).."]"..
		"label[1,5.5;"..minetest.formspec_escape(S("Block Tardis Is On: ")).."]"..
		"item_image[3,5;2,2;"..minetest.formspec_escape(block).."]"..
		"label[1,7;"..minetest.formspec_escape(id).."]"
end
minetest.register_node("drwho_tardis:monitor", {
		description = S("Tardis Monitor"),
		tiles = {"tardis_side_1.png", "tardis_side_1.png", "tardis_side_1.png", "tardis_side_1.png", "tardis_monitor_screen.png", "tardis_side_1.png"},
		drawtype = "nodebox",
		node_box = {
			type = "fixed",
			fixed = {
				{ -0.5, -0.4, 0.1, 0.5,  0.4, 0 },
				{ 0.1, 0.1, 0, -0.1, -0.1, -0.5},
			},
		},
		groups = {cracky = 3},
		after_place_node = function(pos, placer, itemstack, pointed_thing)
			local pmeta = placer:get_meta()
			local id = pmeta:get_string("id")
			local r_pos = minetest.deserialize(data:get_string(id.."r_pos"))
			if not r_pos then r_pos = placer:get_pos() end
			if r_pos.x+50 > pos.x and r_pos.x-50 < pos.x and r_pos.z+50 > pos.z and r_pos.z-50 < pos.z and r_pos.y+50 > pos.y and r_pos.y-50 < pos.y then
				local meta = minetest.get_meta(pos)
				local out_pos = minetest.deserialize(data:get_string(id.."out_pos"))
				meta:set_string("id", id)
		
				out_pos.y = out_pos.y-1
				local node = minetest.get_node(out_pos)
				if node.name == "ignore" then
					minetest.get_voxel_manip():read_from_map(out_pos, out_pos)
					local node = minetest.get_node(out_pos)
				end
				out_pos.y = out_pos.y+1
		
				meta:set_string("formspec", get_formspec_screen(data:get_int(id.."power"), out_pos.x, out_pos.y, out_pos.z, data:get_int(id.."x_dest"), data:get_int(id.."y_dest"), data:get_int(id.."z_dest"), node.name, id ))
			else minetest.dig_node(pos) end
		end,
		on_rightclick = function(pos)
			local meta = minetest.get_meta(pos)
			local id = meta:get_string("id")
			local out_pos = minetest.deserialize(data:get_string(id.."out_pos"))
		
			out_pos.y = out_pos.y-1
			local node = minetest.get_node(out_pos)
			if node.name == "ignore" then
				minetest.get_voxel_manip():read_from_map(out_pos, out_pos)
				local node = minetest.get_node(out_pos)
			end
			out_pos.y = out_pos.y+1
		
			meta:set_string("formspec", get_formspec_screen(data:get_int(id.."power"), out_pos.x, out_pos.y, out_pos.z, data:get_int(id.."x_dest"), data:get_int(id.."y_dest"), data:get_int(id.."z_dest"), node.name, id ))
		end -- end TARDIS Monitor
})


-- gallifreyan lab
local function get_formspec_lab()
	if minetest.get_modpath("mcl_core") then
		return "size[10,10]"..
		"image[4.5,2;1,1;arrow_icon.png]"..
		"list[current_name;fuel;2,2;1,1;1]"..
		"list[current_name;dest;7,2;1,1;1]"..
		"list[current_player;main;1,5;8,4;]"
    else 
		return "size[10,10]"..
		"image[4.5,2;1,1;arrow_icon.png]"..
		"list[context;fuel;2,2;1,1;1]"..
		"list[context;dest;7,2;1,1;1]"..
		"list[current_player;main;1,5;8,4;]"
	end
end
local function lab_recipe(item,result,pos, player)
	local meta = minetest.get_meta(pos)
	local inv = meta:get_inventory()
	if inv:contains_item("fuel", item) == true and inv:is_empty("dest") then
		inv:remove_item("fuel",item)
		local fuel_s = inv:get_stack("fuel", 2)
		inv:set_stack("fuel", 2, fuel_s)
		inv:set_stack("dest", 2, result)
		player:set_hp(player:get_hp()-4)
	end
end
local function lab_crafting(pos, player)
	lab_recipe("default:diamondblock","drwho_tardis:spacetime",pos, player)
	lab_recipe("default:mese_crystal","drwho_tardis:arton_crystal",pos, player)
	lab_recipe("default:diamond","drwho_tardis:azbantium_shard",pos, player)
	lab_recipe("default:mese","default:diamond",pos, player)
	lab_recipe("default:copper_ingot","default:steel_ingot",pos, player)
	lab_recipe("default:coal_lump","default:tin_lump 2",pos, player)
	lab_recipe("default:steelblock","default:mese_crystal 3",pos, player)
	lab_recipe("default:dirt","default:coal_lump",pos, player)
end
minetest.register_node("drwho_tardis:lab", {
		description = S("Gallifreyan Lab"),
		tiles = {"tardis_lab.png"},
		groups = {cracky = 3},
		on_construct = function(pos, node)
			local meta = minetest.get_meta(pos)
			local inv = meta:get_inventory()
			inv:set_size("fuel", 2*1)
			inv:set_size("dest", 2*1)
			formspec = get_formspec_lab()
			meta:set_string("formspec", formspec)
		end,
		on_metadata_inventory_put = function(pos, listname, index, stack, player)
			lab_crafting(pos, player)
		end,
		on_metadata_inventory_take = function(pos, listname, index, stack, player)
			lab_crafting(pos, player)
		end -- Gallifreyan Lab
})


-- gallifreyan chest
local function get_formspec_chest()
    return "size[24,15]"..
		"list[context;main;0,0.5;24,10;]"..
		"list[current_player;main;8,10.5;8,4;]"
end
minetest.register_node("drwho_tardis:chest", {
		description = S("Gallifreyan Chest"),
		tiles = {"tardis_chest_top.png", "tardis_chest_top.png", "tardis_chest_side.png", "tardis_chest_side.png", "tardis_chest_side.png", "tardis_chest_side.png"},
		groups = {cracky = 3},
		after_place_node = function(pos, placer, itemstack, pointed_thing)
			local meta = minetest.get_meta(pos)
			local inv = meta:get_inventory()
			meta:set_string("owner", placer:get_player_name())
			meta:set_string("infotext", "Chest owned by " .. placer:get_player_name())
			meta:set_string("formspec", get_formspec_chest())
			inv:set_size("main", 24*10) -- VERY large
		end,
		on_rightclick = function(pos, node, clicker, itemstack) 
			local meta = minetest.get_meta(pos)
			if clicker:get_player_name() == meta:get_string("owner") then meta:set_string("formspec", get_formspec_chest(pos)) else meta:set_string("formspec", "") end
		end -- gallifreyan chest
})

-- Summon TARDIS command
minetest.register_chatcommand("summon_tardis", {
	params = "",
	description = S("Summons your Tardis to your location"),
	privs = {bring = true},
	func = function(name)
    if data:get_string(name.."in_pos") == "" then return false, S("tardis not found") else
		local player = minetest.get_player_by_name(name)
		local select_pos = player:get_pos()
		local out_pos = minetest.deserialize(data:get_string(name.."out_pos"))
		local look = data:get_string(name.."look")
		minetest.set_node(out_pos, {name = "air"})
		out_pos.x = math.ceil(select_pos.x)
		out_pos.y = math.ceil(select_pos.y)
		out_pos.z = math.ceil(select_pos.z)	
		minetest.set_node(out_pos, {name=look})
		local ometa = minetest.get_meta(out_pos)
		ometa:set_string("id", name)
		data:set_string(name.."out_pos", minetest.serialize(out_pos))
		local timer = minetest.get_node_timer(out_pos)
		timer:start(0.5)
		--Unlock award:
		if minetest.get_modpath("awards") then
			awards.unlock(name, "drwho_tardis:command_summon_tardis")
		end
		minetest.chat_send_player(name, S("Tardis Summoned"))
		
	end
	end
})
minetest.register_on_player_receive_fields(function(player, formname, fields)
	if fields.teleport then
		local pos = minetest.string_to_pos(fields.teleport_x..","..fields.teleport_y..","..fields.teleport_z)
		player:set_pos(pos)
		player:set_hp(2)
	end
	if fields.sonic_send then
		local meta = player:get_meta()
		local pos = minetest.deserialize(meta:get_string("sonic_digiline"))
		digilines.receptor_send(pos, digilines.rules.default, fields.sonic_channel, fields.sonic_message)
	end
end)

--fix death stuff
minetest.register_on_dieplayer(function(player)
	local pmeta = player:get_meta()
	local id = pmeta:get_string("id")
	local r_pos = minetest.deserialize(data:get_string(id.."r_pos"))
	pmeta:set_string("vortex", "no")
	if r_pos then 
		local rmeta = minetest.get_meta(r_pos) 
		local style = rmeta:get_string("style") 
		minetest.swap_node(r_pos, {name = "drwho_tardis:rotor"..style }) 
	end
end)

--fix timers
minetest.register_lbm({
	name = "drwho_tardis:fix_timers",
	nodenames = {"drwho_tardis:in_door"},
	action = function(pos, node)
		local timer = minetest.get_node_timer(pos)
		timer:start(0.2)
	end
})

--aliases
minetest.register_alias("drwho_tardis:dalek_ingot", "drwho_tardis:dalekanium_ingot")
minetest.register_alias("drwho_tardis:tardis_blue", "drwho_tardis:tardis")

-- aliases for mineclone_core
if minetest.get_modpath("mcl_core") then
	minetest.register_alias("default:steel_ingot", "mcl_core:iron_ingot")
	minetest.register_alias("default:copper_ingot", "mcl_nether:quartz")
	minetest.register_alias("default:tin_ingot", "mcl_core:iron_ingot")
	minetest.register_alias("default:steelblock", "mcl_core:ironblock")
	minetest.register_alias("default:tinblock", "mcl_core:ironblock")
	minetest.register_alias("default:gold_ingot", "mcl_core:gold_ingot")
	minetest.register_alias("default:goldblock", "mcl_core:goldblock")
	minetest.register_alias("default:obsidian", "mcl_core:obsidian")
	minetest.register_alias("default:glass", "mcl_core:glass")
	minetest.register_alias("default:mese_crystal", "mesecons:wire_00000000_off")
	minetest.register_alias("default:mese", "mesecons_torch:redstoneblock")
	minetest.register_alias("default:diamond", "mcl_core:diamond")
	minetest.register_alias("default:diamondblock", "mcl_core:diamondblock")
	minetest.register_alias("default:stick", "mcl_core:stick")
	minetest.register_alias("default:cactus", "mcl_flowers:tulip_orange")
	minetest.register_alias("default:dry_grass_1", "mcl_flowers:tulip_white")
	minetest.register_alias("default:junglegrass", "mcl_flowers:allium")
	minetest.register_alias("default:obsidian_block", "mcl_flowers:peony")
	minetest.register_alias("default:grass_1", "mcl_flowers:poppy")
	minetest.register_alias("default:bronzeblock", "mcl_flowers:sunflower")
	minetest.register_alias("default:permafrost", "mcl_flowers:dandelion")
	minetest.register_alias("default:silver_sandstone_block", "mcl_flowers:azure_bluet")
end