-- CONTENTS
-- Formspecs and functions for the consoles
-- Node Definitions (line ~470)
-- Go to recipes.lua for crafting these

local S = minetest.get_translator("drwho_tardis")

--formspecs


-- Travel Factor, X, Y, Z
local function get_formspec_fxyz(set) 
	local id = set.id -- TARDIS ID Code, passed to formspec every time
	local out_pos = minetest.deserialize(data:get_string(id.."out_pos"))-- Get current tardis position
	local factor = data:get_int(id.."factor") -- Get current Travel Factor Value
	
	-- local var = <changed_value> or <current_value>
	-- <changed_value> is given to the formspec when buttons are pressed, reloading it with new value
	local fac  = set.fac or factor
	local addx = set.addx or data:get_int(id.."x_dest")
	local addy = set.addy or data:get_int(id.."y_dest")
	local addz = set.addz or data:get_int(id.."z_dest")
	local outx = set.outx or out_pos.x 
	local outy = set.outy or out_pos.y
	local outz = set.outz or out_pos.z

	local tfactor = S("Travel Factor: @1", fac) -- Travel Factor: 6
	local dest = S("Destination:         @1,    @2,    @3", addx, addy, addz)
	local cur =  S("Current Position:         @1,    @2,    @3", outx, outy, outz)
    return "size[10,10]"..
		"label[1,1.25;"..minetest.formspec_escape(tfactor).."]".. -- Travel Factor:
		"image_button[4,1;1,1;switch_1.png;one; ;false;false;switch_2.png]"..
		"image_button[5.2,1;1,1;switch_1.png;ten; ;false;false;switch_2.png]"..
		"image_button[6.4,1;1,1;switch_1.png;hundred; ;false;false;switch_2.png]"..
		"image_button[7.6,1;1,1;switch_1.png;thousand; ;false;false;switch_2.png]"..
		"tooltip[one;1]"..
		"tooltip[ten;10]".. -- Travel Factor tooltips
		"tooltip[hundred;100]"..
		"tooltip[thousand;1000]"..

		"label[1,3;"..minetest.formspec_escape(cur).."]"..  -- Current Position:  X,   Y,   Z
		"label[1,5;"..minetest.formspec_escape(dest).."]".. -- Destination:   X,   Y,   Z
		
		"image_button[0.5,7;2,2;handle_1.png;xposup; ;false;false;handle_2.png]".. -- Change X POS
		"image_button[1.5,7;2,2;handle_1.png;xposdown; ;false;false;handle_2.png]"..

		"image_button[3.5,7;2,2;handle_1.png;yposup; ;false;false;handle_2.png]"..  -- Change Y POS
		"image_button[4.5,7;2,2;handle_1.png;yposdown; ;false;false;handle_2.png]"..

		"image_button[6.5,7;2,2;handle_1.png;zposup; ;false;false;handle_2.png]".. -- Change Z POS
		"image_button[7.5,7;2,2;handle_1.png;zposdown; ;false;false;handle_2.png]".. 

		"tooltip[xposup;Increase X Pos]"..
		"tooltip[xposdown;Decrease X Pos]"..
		"tooltip[yposup;Increase Y Pos]"..
		"tooltip[yposdown;Decrease Y Pos]"..
		"tooltip[zposup;Increase Z Pos]"..
		"tooltip[zposdown;Decrease Z Pos]"
end
local function get_formspec_w() -- GO Lever
    return "size[10,10]"..
		--"button[1,3;5,1;go;Go]"
		"image_button_exit[3,3;4,4;lever_1.png;go; ;false;false;lever_2.png]"
end
local function get_formspec_r(set) -- Power Left (Time Rotor)
	local power = S("Power Left: @1 out of 10", set)
	local info = S("1 power is generated every 15 seconds.")
    return "size[10,10]"..
		"label[1,1;"..minetest.formspec_escape(power).."]"..
		"label[1,2;"..minetest.formspec_escape(info).."]"
end
local function get_formspec_fb(set) 
	local id = set.id -- TARDIS ID Code, passed to formspec every time
	local out_pos = minetest.deserialize(data:get_string(id.."out_pos"))-- Get current tardis position
	local success, biomes = findbiome.list_biomes()
	local sid = biomes[sid] and sid or 1

	-- local var = <changed_value> or <current_value>
	-- <changed_value> is given to the formspec when buttons are pressed, reloading it with new value
	local addx = set.addx or data:get_int(id.."x_dest")
	local addy = set.addy or data:get_int(id.."y_dest")
	local addz = set.addz or data:get_int(id.."z_dest")
	local outx = out_pos.x 
	local outy = out_pos.y
	local outz = out_pos.z
	local biome_pos = set.biome_pos or {x=0,y=0,z=0}
	local biomex = set.biomex or biome_pos.x or 0
	local biomey = set.biomey or biome_pos.y or 0
	local biomez = set.biomez or biome_pos.z or 0

	local dest = S("Destination:     @1,  @2,  @3", addx, addy, addz)
	local cur =  S("Current Position:  @1,  @2,  @3", outx, outy, outz)
	local loc = S("Find a biome")
	local list = S("List of all biomes:")
	local textf = S("Type the biome name here:")
	local bpos = S("Biome Position:  @1, @2, @3", biomex, biomey, biomez) or ""
	local note = set.note or ""
	local fbiome_tt = S("Find Biome (press this first, after entering biome name)")
	local set_tt = S("Set Found Biome Position as Destination")

	-- Create sidebar with buttons part
	local biome = biomes[sid]
	local sidebuttons = "label[0,0;"..minetest.formspec_escape(loc).."]".. 
						"label[0,1;"..minetest.formspec_escape(cur).."]"..  
						"label[0,1.5;"..minetest.formspec_escape(dest).."]"..
						"label[0,2;"..minetest.formspec_escape(bpos).."]"..
						"label[0.5,2.75;"..minetest.formspec_escape(note).."]"
	
	-- Write in the biome name field
	sidebuttons = sidebuttons.."field[0.25,4.5;4,1;setbiome;"..textf..";biome]"
	-- Find biome button
	sidebuttons = sidebuttons.."image_button[0.5,6;2,2;handle_1.png;fbiome; ;false;false;handle_2.png]"..
								"tooltip[fbiome;"..minetest.formspec_escape(fbiome_tt).."]"
	-- Set biome as destination button
	sidebuttons = sidebuttons.."image_button[2,6;2,2;handle_1.png;set; ;false;false;handle_2.png]"..
								"tooltip[set;"..minetest.formspec_escape(set_tt).."]"
    -- Create biome list formspec part
	local biomeslistformspec = "label[6,0.5;"..minetest.formspec_escape(list).."]"..
								"textlist[5,1;5,9;consolefindbiome;"

	local first = true
	for b=1, #biomes do
		if not first then
			biomeslistformspec = biomeslistformspec .. ","
		end
		first = false
		biomeslistformspec = biomeslistformspec .. minetest.formspec_escape(biomes[b])
	end
	biomeslistformspec = biomeslistformspec .. ";]"

    return "size[10,10]"..

		sidebuttons..
		biomeslistformspec

end
local function get_formspec_s() -- Extra Functions
	local sonic_tt = S("Create Sonic Screwdriver")
	local heal_tt = S("Heal Me")
	local axe_tt = S("Create an Axe")
	local scan_tt = S("Scan Named Player")
	local submit_tt = S("Locate Named Player")
	local food_tt = S("Create a Biscuit")
	local antigrav_tt = S("Toggle Antigrav")
	local attack_tt = S("Activate Weapons")
	local pick_tt = S("Create a Pickaxe")
	local locate_fieldtext = S("type name here... ")
    return "size[10,10]"..
		"field[1,9;8,1;locate;;"..minetest.formspec_escape(locate_fieldtext).."]"..
		"image_button[1,1;2,2;switch_1.png;pick; ;false;false;switch_2.png]"..
		"image_button[2.5,1;2,2;switch_1.png;heal; ;false;false;switch_2.png]"..
		"image_button[4,1;2,2;switch_1.png;axe; ;false;false;switch_2.png]"..
		"image_button[1,3;2,2;switch_1.png;antigrav; ;false;false;switch_2.png]"..
		"image_button[2.5,3;2,2;switch_1.png;food; ;false;false;switch_2.png]"..
		"image_button[4,3;2,2;switch_1.png;attack; ;false;false;switch_2.png]"..
		"image_button[6,1;4,4;handle_1.png;sonic; ;false;false;handle_2.png]"..
		"image_button_exit[0.5,5.5;3,3;dial_1.png;submit; ;false;false;dial_2.png]"..
		"image_button[3.5,5.5;3,3;dial_1.png;scan; ;false;false;dial_2.png]"..
		"tooltip[sonic;"..minetest.formspec_escape(sonic_tt).."]"..
		"tooltip[heal;"..minetest.formspec_escape(heal_tt).."]"..
		"tooltip[axe;"..minetest.formspec_escape(axe_tt).."]"..
		"tooltip[scan;"..minetest.formspec_escape(scan_tt).."]"..
		"tooltip[submit;"..minetest.formspec_escape(submit_tt).."]"..
		"tooltip[food;"..minetest.formspec_escape(food_tt).."]"..
		"tooltip[antigrav;"..minetest.formspec_escape(antigrav_tt).."]"..
		"tooltip[attack;"..minetest.formspec_escape(attack_tt).."]"..
		"tooltip[pick;"..minetest.formspec_escape(pick_tt).."]"
end
local function get_formspec_c(set) -- Change Exterior 
	local cur = set
	local ext_text = S("Change Exterior Shell")
    return "size[10,10]"..
		-- TODO: Make this a scrollable list, and every exterior added with the API is listed there
		"label[1,1;"..minetest.formspec_escape(ext_text).."]"..
		"item_image[6,0.5;3,3;"..minetest.formspec_escape(cur).."]"..
		"button[1,3;3,3;old;Default]"..
		"button[1,4;3,3;pink;Pink]"..
		"button[1,5;3,3;blue;Blue]"..
		"button[1,6;3,3;yellow;Yellow]"..
		"button[1,7;3,3;green;Green]"..
		"button[5,3;3,3;empty;Invisible]"..
		"button[5,4;3,3;cool;Classic]"..
		"button[5,5;3,3;leave;Leaves]"..
		"button[5,6;3,3;stone;Stone]"..
		"button[5,7;3,3;funky;Funky]"	
end

local function get_formspec_o(set) -- Waypoints
	local id = set.id -- TARDIS ID number is given to formspec function
	local out_pos = minetest.deserialize(data:get_string(id.."out_pos"))-- Get current tardis position
	local way1 = set.way1 or minetest.deserialize(data:get_string(id.."way1"))
	local way2 = set.way2 or minetest.deserialize(data:get_string(id.."way2"))
	local way3 = set.way3 or minetest.deserialize(data:get_string(id.."way3"))
	local x_dest = set.x_dest or data:get_int(id.."x_dest")
	local y_dest = set.y_dest or data:get_int(id.."y_dest")
	local z_dest = set.z_dest or data:get_int(id.."z_dest")

	local cur = S("Current Position:         @1,    @2,    @3", out_pos.x, out_pos.y, out_pos.z)
	local dest = S("Destination:         @1,    @2,    @3", x_dest, y_dest, z_dest)
	local way_one = S("Waypoint One:         @1,     @2,      @3", way1.x, way1.y, way1.z)
	local way_two = S("Waypoint Two:         @1,     @2,      @3", way2.x, way2.y, way2.z)
	local way_three = S("Waypoint Three:         @1,     @2,      @3", way3.x, way3.y, way3.z)
	local set_way = S("Use Waypoint as Destination?")

	local set_one_tt = S("Set Waypoint 1 to Current Position")
	local set_two_tt = S("Set Waypoint 1 to Current Position")
	local set_three_tt = S("Set Waypoint 1 to Current Position")
	local use_one_tt = S("Set Waypoint 1 to Current Position")
	local use_two_tt = S("Set Waypoint 1 to Current Position")
	local use_three_tt = S("Set Waypoint 1 to Current Position")

    return "size[10,10]"..
		"label[4,1;"..minetest.formspec_escape(cur).."]"..  -- Current Position:  X,   Y,   Z
		"label[4,1.5;"..minetest.formspec_escape(dest).."]"..  -- Destination:  X,   Y,   Z
		"label[4,3.5;"..minetest.formspec_escape(way_one).."]"..  -- Waypoint One:     X,   Y,   Z
		"label[4,4;"..minetest.formspec_escape(way_two).."]"..    -- Waypoint Two:     X,   Y,   Z
		"label[4,4.5;"..minetest.formspec_escape(way_three).."]"..-- Waypoint Three:   X,   Y,   Z

		"image_button[1,1;2,2;dial_1.png;set_one; ;false;false;dial_2.png]"..
		"image_button[1,4;2,2;dial_1.png;set_two; ;false;false;dial_2.png]"..
		"image_button[1,7;2,2;dial_1.png;set_three; ;false;false;dial_2.png]"..

		"label[5,6.5;"..minetest.formspec_escape(set_way).."]".. -- Use Waypoint as Destination?
		"image_button[4.5,7;2,2;switch_1.png;use_one; ;false;false;switch_2.png]"..
		"image_button[6,7;2,2;switch_1.png;use_two; ;false;false;switch_2.png]"..
		"image_button[7.5,7;2,2;switch_1.png;use_three; ;false;false;switch_2.png]"..

		"tooltip[set_one;"..minetest.formspec_escape(set_one_tt).."]"..
		"tooltip[set_two;"..minetest.formspec_escape(set_two_tt).."]"..
		"tooltip[set_three;"..minetest.formspec_escape(set_three_tt).."]"..
		"tooltip[use_one;"..minetest.formspec_escape(use_one_tt).."]"..
		"tooltip[use_two;"..minetest.formspec_escape(use_two_tt).."]"..
		"tooltip[use_three;"..minetest.formspec_escape(use_three_tt).."]"
end
local general_functions = function(pos, formname, fields, sender)
	local meta = minetest.get_meta(pos)
	local id = meta:get_string("id")
	local name = sender:get_player_name()
	local out_pos = minetest.deserialize(data:get_string(id.."out_pos"))
	local factor = data:get_int(id.."factor")
	local inv = sender:get_inventory()
	if fields.xposup then -- Increase X Position
		meta:set_string("formspec", get_formspec_fxyz({
			addx = data:get_int(id.."x_dest")+factor, 
			outx = out_pos.x, 
			id = id
		}))
		data:set_int(id.."x_dest", data:get_int(id.."x_dest")+factor)
	end
	if fields.xposdown then -- Decrease X Position
		meta:set_string("formspec", get_formspec_fxyz({
			addx = data:get_int(id.."x_dest")-factor, 
			outx = out_pos.x, 
			id = id
		}))
		data:set_int(id.."x_dest", data:get_int(id.."x_dest")-factor)
	end
	if fields.yposup then-- Increase Y Position
		meta:set_string("formspec", get_formspec_fxyz({
			addy = data:get_int(id.."y_dest")+factor, 
			outy = out_pos.y, 
			id = id
		}))
		data:set_int(id.."y_dest", data:get_int(id.."y_dest")+factor)
	end
	if fields.yposdown then -- Decrease Y Position
		meta:set_string("formspec", get_formspec_fxyz({
			addy = data:get_int(id.."y_dest")-factor, 
			outy = out_pos.y, 
			id = id
		}))
		data:set_int(id.."y_dest", data:get_int(id.."y_dest")-factor)
	end
	if fields.zposup then -- Increase Z Position
		meta:set_string("formspec", get_formspec_fxyz({
			addz = data:get_int(id.."z_dest")+factor, 
			outz = out_pos.z, 
			id = id
		}))
		data:set_int(id.."z_dest", data:get_int(id.."z_dest")+factor)
	end
	if fields.zposdown then -- Decrease Z Position
		meta:set_string("formspec", get_formspec_fxyz({
			addz = data:get_int(id.."z_dest")-factor, 
			outz = out_pos.z, 
			id = id
		}))
		data:set_int(id.."z_dest", data:get_int(id.."z_dest")-factor)
	end
	if fields.one then -- set Travel Factor to 1
		meta:set_string("formspec", get_formspec_fxyz({fac = 1, id = id}))
		data:set_int(id.."factor", 1)
	end
	if fields.ten then -- set Travel Factor to 10
		meta:set_string("formspec", get_formspec_fxyz({fac = 10, id = id}))
		data:set_int(id.."factor", 10)
	end
	if fields.hundred then -- set Travel Factor to 100
		meta:set_string("formspec", get_formspec_fxyz({fac = 100, id = id}))
		data:set_int(id.."factor", 100)
	end 
	if fields.thousand then -- set Travel Factor to 1000
		meta:set_string("formspec", get_formspec_fxyz({fac = 1000, id = id}))
		data:set_int(id.."factor", 1000)
	end 
	--extra functions
	if fields.submit then -- Locate a player
		if data:get_int(id.."power") < 2 then minetest.chat_send_player(name, S("You Need 2 Power")) else
			local victim = minetest.get_player_by_name(fields.locate)
			if not victim then minetest.chat_send_player(name, fields.locate .. S(" not found")) else 
				local vpos = victim:get_pos()
				data:set_int(id.."x_dest", vpos.x) 
				data:set_int(id.."y_dest", vpos.y+1)
				data:set_int(id.."z_dest", vpos.z)
				minetest.chat_send_player(name, S("Player Located"))
				data:set_int(id.."power", data:get_string(id.."power")-2)
			end
		end
	end 
	if fields.sonic then -- Create a sonic screwdriver
		if data:get_int(id.."power") < 5 then minetest.chat_send_player(name, S("You Need 5 Power")) else
			pos.y = pos.y+1
			local sonictypes = 4 --number of variants for end, middle, and top
			local top = math.random(1,sonictypes)
			local mid = math.random(1,sonictypes)
			local bottom = math.random(1,sonictypes)
			sonicname = "drwho_tardis:sonic_screwdriver_"..top.."_"..mid.."_"..bottom
			--[[ -- Full function that is not needed here anymore
			drwho_tardis:register_sonic_device({ -- Creates and registers the new sonic, then returns the itemname to be given to add_item()
				gentype = "choose", 
				sonictype = "screwdriver", -- Specify it is a screwdriver
				customname = sonicname, -- Generated above
				no_creative = false, -- Appear in creative inventory
				top = top,
				mid = mid,
				bottom = bottom,
			})
			--]]
			minetest.add_item(pos, sonicname)
			data:set_int(id.."power", data:get_string(id.."power")-5)
			if minetest.get_modpath("awards") then 
				awards.unlock(name, "drwho_tardis:get_sonic_screwdriver") -- Unlock award if awards are enabled
			end
		end
	end 
	if fields.heal then -- Heal the pilot
		if data:get_int(id.."power") < 3 then minetest.chat_send_player(name, S("You Need 3 Power")) else
			sender:set_hp(40)
			data:set_int(id.."power", data:get_string(id.."power")-3)
		end
	end 
	if fields.scan then -- Scan a player by name
		if data:get_int(id.."power") < 1 then minetest.chat_send_player(name, S("You Need 1 Power")) else
			local victim = minetest.get_player_by_name(fields.locate)
			if not victim then minetest.chat_send_player(name, fields.locate .. S(" not found")) else 
				local item = victim:get_wielded_item()
				local item_name = item:get_name()
				if item:get_name() == "" then item_name = "nothing" end
				minetest.chat_send_player(name, S("@1 is holding @2 and has @3 hearts", fields.locate, item_name, victim:get_hp()/2))
				data:set_int(id.."power", data:get_string(id.."power")-1)
			end
		end
	end 
	if fields.pick then -- Create a diamond pickaxe
		if data:get_int(id.."power") < 5 then minetest.chat_send_player(name, S("You Need 5 Power")) else
			pos.y = pos.y+1
			minetest.add_item(pos, "default:pick_diamond")
			data:set_int(id.."power", data:get_string(id.."power")-5)
		end
	end 
	if fields.axe then -- Create a diamond axe
		if data:get_int(id.."power") < 5 then minetest.chat_send_player(name, S("You Need 5 Power")) else
			pos.y = pos.y+1
			minetest.add_item(pos, "default:axe_diamond")
			data:set_int(id.."power", data:get_string(id.."power")-5)
		end
	end 
	if fields.antigrav then -- Toggle antigrav (what does this actually do?)
		if data:get_string(id.."grav") == "yes" then
			data:set_string(id.."grav", "no")
			minetest.chat_send_player(name, S("Antigravs Disabled"))
		else
			data:set_string(id.."grav", "yes")
			minetest.chat_send_player(name, S("Antigravs Enabled"))
		end
	end 
	if fields.food then -- Create a tardis biscuit
		if data:get_int(id.."power") < 1 then minetest.chat_send_player(name, S("You Need 1 Power")) else
			pos.y = pos.y+1
			minetest.add_item(pos, "drwho_tardis:biscuit")
			data:set_int(id.."power", data:get_string(id.."power")-1)
		end
	end 
	if fields.attack then -- Attack a nearby player down to 1 hp
		if data:get_int(id.."power") < 1 then minetest.chat_send_player(name, S("You Need 1 Power")) else
			local objs = minetest.get_objects_inside_radius(out_pos, 20)
			if objs[1] == nil then minetest.chat_send_player(name, S("No players in range of Tardis")) else
				if objs[1]:get_player_name() ~= "" then
					objs[1]:set_hp(1) --Set their HP to 1
					minetest.chat_send_player(name, objs[1]:get_player_name().." was attacked" )
					if minetest.get_modpath("awards") then --check if awards are enabled
						awards.unlock(name, "drwho_tardis:tardis_attack") --unlock 'Threat Nullified' award
					end
					data:set_int(id.."power", data:get_string(id.."power")-1) --reduce power by 1
				end			
			end
		end
	end
end

local travel_to_location = function(pos, formname, fields, sender)
	local meta = minetest.get_meta(pos)
	local id = meta:get_string("id")
	local out_pos = minetest.deserialize(data:get_string(id.."out_pos"))
	local look = data:get_string(id.."look")
	local r_pos = minetest.deserialize(data:get_string(id.."r_pos"))
	local rmeta = minetest.get_meta(r_pos)
	local style = rmeta:get_string("style")
	local go_pos = { x = data:get_int(id.."x_dest"), y = data:get_int(id.."y_dest"), z = data:get_int(id.."z_dest") }
	local pmeta = sender:get_meta()
	local name = sender:get_player_name()
	if fields.go then
		if data:get_int(id.."power") == 0 then minetest.chat_send_player(name, S("No Power Left!")) else --power?
			if minetest.get_node(go_pos).name == "air" then
				if data:get_string(id.."grav") == "no" then
					local vpos = go_pos
					vpos.y = vpos.y-1
					while minetest.get_node(vpos).name == "air" and  minetest.get_node(go_pos).name ~= "ignore" do
						vpos.y = vpos.y-1
					end
					go_pos.y = vpos.y+1
				end
			else 
				while minetest.get_node(go_pos).name ~= "air" and minetest.get_node(go_pos).name ~= "ignore" do
					go_pos.y = go_pos.y+1
				end
			end
			if minetest.is_protected(go_pos, name) then minetest.chat_send_player(name, S("You don't have access to this area!")) else --protected?
				if r_pos.x+100 > go_pos.x and r_pos.x-100 < go_pos.x and r_pos.z+100 > go_pos.z and r_pos.z-100 < go_pos.z and r_pos.y+100 > go_pos.y and r_pos.y-100 < go_pos.y then minetest.chat_send_player(name, "Your Tardis does not want to land at this location") else --stay away from console room!
					if 30900 > go_pos.x and -30900 < go_pos.x and 30900 > go_pos.z and -30900 < go_pos.z and 30900 > go_pos.z and -30900 < go_pos.z then --world limits
						minetest.swap_node(r_pos, {name = "drwho_tardis:rotor_active"..style })
						pmeta:set_string("vortex", "yes")
						local effect = minetest.sound_play("tardis_sound", {pos = pos, max_hear_distance = 10})
						
						minetest.after(8, function(effect)
							minetest.sound_stop(effect)
							minetest.swap_node(r_pos, {name = "drwho_tardis:rotor"..style })
							if minetest.get_modpath("awards") then
								times_travelled_in_tardis = times_travelled_in_tardis + 1
								minetest.chat_send_player(name, S("Times travelled in TARDIS: @1", times_travelled_in_tardis))
								check_drwho_awards(name) -- Will give times_travelled awards if nessasary
							end
							--local ometa = minetest.get_meta(r_pos)
							--ometa:set_string("id", id)
							--ometa:set_string("formspec", get_formspec_r(data:get_int(id.."power")))
							local otimer = minetest.get_node_timer(r_pos)
							otimer:start(15)
							pmeta:set_string("vortex", "no")
						end, effect)
				
						minetest.set_node(out_pos, {name = "air"})
						out_pos = go_pos
						minetest.set_node(out_pos, {name=look})
						
						out_pos.y = out_pos.y+1
						minetest.set_node(out_pos, {name = "air"})
						out_pos.y = out_pos.y-1
						
						local ometa = minetest.get_meta(out_pos)
						ometa:set_string("id", id)
						data:set_string(id.."out_pos", minetest.serialize(out_pos))
						data:set_int(id.."power", data:get_string(id.."power")-1)
						local timer = minetest.get_node_timer(out_pos)
						timer:start(0.2)
						
					else minetest.chat_send_player(name, S("Your Tardis can not travel outside the world!")) end
				end
			end
		end
	end
end
local change_look = function(pos, formname, fields, sender)
	local meta = minetest.get_meta(pos)
	local id = meta:get_string("id")
	local out_pos = minetest.deserialize(data:get_string(id.."out_pos"))
	local name = sender:get_player_name() -- just for award
	if fields.blue then
		meta:set_string("formspec", get_formspec_c("drwho_tardis:tardis"))
		data:set_string(id.."look", "drwho_tardis:tardis")
	end
	if fields.yellow then
		meta:set_string("formspec", get_formspec_c("drwho_tardis:tardis_yellow"))
		data:set_string(id.."look", "drwho_tardis:tardis_yellow")
	end
	if fields.pink then
		meta:set_string("formspec", get_formspec_c("drwho_tardis:tardis_pink"))
		data:set_string(id.."look", "drwho_tardis:tardis_pink")
	end
	if fields.green then
		meta:set_string("formspec", get_formspec_c("drwho_tardis:tardis_green"))
		data:set_string(id.."look", "drwho_tardis:tardis_green")
	end
	if fields.old then
		meta:set_string("formspec", get_formspec_c("drwho_tardis:tardis_old"))
		data:set_string(id.."look", "drwho_tardis:tardis_old")
	end
	if fields.stone then
		meta:set_string("formspec", get_formspec_c("drwho_tardis:tardis_stone"))
		data:set_string(id.."look", "drwho_tardis:tardis_stone")
	end
	if fields.empty then --invisible
		meta:set_string("formspec", get_formspec_c("drwho_tardis:tardis_empty"))
		data:set_string(id.."look", "drwho_tardis:tardis_empty")
	if minetest.get_modpath("awards") then
			awards.unlock(name, "drwho_tardis:tardis_invisible_award") -- unlock award
		end
	end
	if fields.cool then
		meta:set_string("formspec", get_formspec_c("drwho_tardis:tardis_cool"))
		data:set_string(id.."look", "drwho_tardis:tardis_cool")
	end
	if fields.leave then
		meta:set_string("formspec", get_formspec_c("drwho_tardis:tardis_leave"))
		data:set_string(id.."look", "drwho_tardis:tardis_leave")
	end
	if fields.funky then
		meta:set_string("formspec", get_formspec_c("drwho_tardis:tardis_funky"))
		data:set_string(id.."look", "drwho_tardis:tardis_funky")
	end
end 

local find_biome_functions = function(pos, formname, fields, sender)
	local meta = minetest.get_meta(pos)
	local id = meta:get_string("id")
	local out_pos = minetest.deserialize(data:get_string(id.."out_pos"))
	local biome_pos = minetest.deserialize(data:get_string(id.."biome_pos"))

	if fields.set then -- set as destination
		meta:set_string("formspec", get_formspec_fb({
			addx = biome_pos.x, -- Refresh formspec
			addy = biome_pos.y,
			addz = biome_pos.z,
			note = S("Biome position set\nas destination."), -- Note shown on formspec
			id = id}))
		data:set_int(id.."x_dest", biome_pos.x)
		data:set_int(id.."y_dest", biome_pos.y)
		data:set_int(id.."z_dest", biome_pos.z)

	elseif fields.fbiome then
		local out_pos = minetest.deserialize(data:get_string(id.."out_pos"))
		local setbiome = fields.setbiome
		minetest.chat_send_all(S("Tardis finding biome: @1", setbiome))
		---[[
		local biome_pos = findbiome.find_biome(out_pos, {setbiome})
		local note = S("Biome found")
		if biome_pos == nil or biome_pos == {x=0,y=0,z=0} then 
			note = S("Something went wrong,\ncheck biome spelling?") -- Note shown on formspec 
		else
			note = S("Biome found!") 
			biome_pos.y = biome_pos.y - 1 --Make the Tardis land on the ground instead of 1 node in the air
		end
		data:set_string(id.."biome_pos", minetest.serialize(biome_pos))
		meta:set_string("formspec", get_formspec_fb({
			biome_pos = biome_pos, -- Refresh formspec
			note = note,
			id = id}))
	end
end
local waypoint = function(pos, formname, fields, sender)
	local meta = minetest.get_meta(pos)
	local id = meta:get_string("id")
	local out_pos = minetest.deserialize(data:get_string(id.."out_pos"))
	local way1 = minetest.deserialize(data:get_string(id.."way1"))
	local way2 = minetest.deserialize(data:get_string(id.."way2"))
	local way3 = minetest.deserialize(data:get_string(id.."way3"))
	if fields.set_one then
		data:set_string(id.."way1", minetest.serialize(out_pos))
		local way1 = minetest.deserialize(data:get_string(id.."way1"))
		meta:set_string("formspec", get_formspec_o({
			way1 = minetest.deserialize(data:get_string(id.."way1")), -- Refresh formspec
			id = id}))
	end
	if fields.use_one  then
		meta:set_string("formspec", get_formspec_o({
			x_dest = way1.x, -- Refresh formspec
			y_dest = way1.y,
			z_dest = way1.z,
			id = id}))
		data:set_int(id.."x_dest", way1.x)
		data:set_int(id.."y_dest", way1.y)
		data:set_int(id.."z_dest", way1.z)
	end
	if fields.set_two then
		data:set_string(id.."way2", minetest.serialize(out_pos))
		local way2 = minetest.deserialize(data:get_string(id.."way2"))
		meta:set_string("formspec", get_formspec_o({
			way2 = minetest.deserialize(data:get_string(id.."way2")), -- Refresh formspec
			id = id}))
	end
	if fields.use_two then
		meta:set_string("formspec", get_formspec_o({
			x_dest = way2.x, -- Refresh formspec
			y_dest = way2.y,
			z_dest = way2.z,
			id = id}))
		data:set_int(id.."x_dest", way2.x)
		data:set_int(id.."y_dest", way2.y)
		data:set_int(id.."z_dest", way2.z)
	end
	if fields.set_three then
		data:set_string(id.."way3", minetest.serialize(out_pos))
		local way3 = minetest.deserialize(data:get_string(id.."way3"))
		meta:set_string("formspec", get_formspec_o({
			way3 = minetest.deserialize(data:get_string(id.."way3")), -- Refresh formspec
			id = id}))
	end
	if fields.use_three then
		meta:set_string("formspec", get_formspec_o({
			x_dest = way3.x, -- Refresh formspec
			y_dest = way3.y,
			z_dest = way3.z,
			id = id}))
		data:set_int(id.."x_dest", way3.x)
		data:set_int(id.."y_dest", way3.y)
		data:set_int(id.."z_dest", way3.z)
	end
end


--------------------
--NODE DEFINITIONS--
--------------------
local function register_console_set(set, craftitem, side, ytexture, xtexture, ztexture, ftexture, stexture, wtexture, ctexture, otexture, rotortexture, altrotortexture, ltexture)
minetest.register_node("drwho_tardis:console_y"..set, {
		description = S("Axis Console Unit A"),
		tiles = {ytexture, ytexture, side, side, side, side},
		groups = {cracky = 3},
		after_place_node = function(pos, placer, itemstack, pointed_thing)
			local pmeta = placer:get_meta()
			local id = pmeta:get_string("id")
			local r_pos = minetest.deserialize(data:get_string(id.."r_pos"))
			if not r_pos then r_pos = placer:get_pos() end
			if r_pos.x+50 > pos.x and r_pos.x-50 < pos.x and r_pos.z+50 > pos.z and r_pos.z-50 < pos.z and r_pos.y+50 > pos.y and r_pos.y-50 < pos.y then
				local meta = minetest.get_meta(pos) 
				local out_pos = minetest.deserialize(data:get_string(id.."out_pos")) 
				meta:set_string("id", id) 
				meta:set_string("formspec", get_formspec_fxyz({addy = 0, outy = out_pos.y, id = id})) 
			else minetest.dig_node(pos) end
		end,
		on_rightclick = function(pos, node, clicker, itemstack) 
			local meta = minetest.get_meta(pos)
			local id = meta:get_string("id")
			local out_pos = minetest.deserialize(data:get_string(id.."out_pos"))
			meta:set_string("id", id)
			meta:set_string("formspec", get_formspec_fxyz({
				addy = data:get_int(id.."y_dest"), 
				outy = out_pos.y,
				id = id
			}))
		end,
		on_receive_fields = general_functions
})
minetest.register_node("drwho_tardis:console_x"..set, {
		description = S("Axis Console Unit B"),
		tiles = {xtexture, xtexture, side, side, side, side},
		groups = {cracky = 3},
		after_place_node = function(pos, placer, itemstack, pointed_thing)
			local pmeta = placer:get_meta()
			local id = pmeta:get_string("id")
			local r_pos = minetest.deserialize(data:get_string(id.."r_pos"))
			if not r_pos then r_pos = placer:get_pos() end
			if r_pos.x+50 > pos.x and r_pos.x-50 < pos.x and r_pos.z+50 > pos.z and r_pos.z-50 < pos.z and r_pos.y+50 > pos.y and r_pos.y-50 < pos.y then 
				local meta = minetest.get_meta(pos)
				local out_pos = minetest.deserialize(data:get_string(id.."out_pos"))
				meta:set_string("id", id)
				meta:set_string("formspec", get_formspec_fxyz({addx = 0, outx = out_pos.x, id = id}))
			else minetest.dig_node(pos) end
		end,
		on_rightclick = function(pos, node, clicker, itemstack)
			local meta = minetest.get_meta(pos)
			local id = meta:get_string("id")
			local out_pos = minetest.deserialize(data:get_string(id.."out_pos"))
			meta:set_string("id", id)
			meta:set_string("formspec", get_formspec_fxyz({
				addx = data:get_int(id.."x_dest"), 
				outx = out_pos.x,
				id = id
			}))
		end,
		on_receive_fields = general_functions
})
minetest.register_node("drwho_tardis:console_z"..set, {
		description = S("Axis Console Unit C"),
		tiles = {ztexture, ztexture, side, side, side, side},
		groups = {cracky = 3},
		after_place_node = function(pos, placer, itemstack, pointed_thing)
			local pmeta = placer:get_meta()
			local id = pmeta:get_string("id")
			local r_pos = minetest.deserialize(data:get_string(id.."r_pos"))
			if not r_pos then r_pos = placer:get_pos() end
			if r_pos.x+50 > pos.x and r_pos.x-50 < pos.x and r_pos.z+50 > pos.z and r_pos.z-50 < pos.z and r_pos.y+50 > pos.y and r_pos.y-50 < pos.y then
				local meta = minetest.get_meta(pos)
				local out_pos = minetest.deserialize(data:get_string(id.."out_pos"))
				meta:set_string("id", id)
				meta:set_string("formspec", get_formspec_fxyz({addz = 0, outz = out_pos.z, id = id}))
			else minetest.dig_node(pos) end
		end,
		on_rightclick = function(pos, node, clicker, itemstack)
			local meta = minetest.get_meta(pos)
			local id = meta:get_string("id")
			local out_pos = minetest.deserialize(data:get_string(id.."out_pos"))
			meta:set_string("id", id)
			meta:set_string("formspec", get_formspec_fxyz({
				addz = data:get_int(id.."z_dest"), 
				outz = out_pos.z,
				id = id
			}))
		end,
		on_receive_fields = general_functions
})
minetest.register_node("drwho_tardis:console_f"..set, {
		description = S("Find Biome Console Unit"),
		tiles = {ftexture, ftexture, side, side, side, side},
		groups = {cracky = 3},
		after_place_node = function(pos, placer, itemstack, pointed_thing)
			local pmeta = placer:get_meta()
			local id = pmeta:get_string("id")
			local r_pos = minetest.deserialize(data:get_string(id.."r_pos"))
			if not r_pos then r_pos = placer:get_pos() end
			if r_pos.x+50 > pos.x and r_pos.x-50 < pos.x and r_pos.z+50 > pos.z and r_pos.z-50 < pos.z and r_pos.y+50 > pos.y and r_pos.y-50 < pos.y then
				local meta = minetest.get_meta(pos)
				meta:set_string("id", id)
				meta:set_string("formspec", get_formspec_fb({id = id}))
			else minetest.dig_node(pos) end
		end,
		on_rightclick = function(pos, node, clicker, itemstack)
			local meta = minetest.get_meta(pos)
			local id = meta:get_string("id")
			meta:set_string("id", id)
			meta:set_string("formspec", get_formspec_fb({
				id = id, 
				pos = minetest.deserialize(data:get_string(id.."out_pos"))
			}))
		end,
		on_receive_fields = find_biome_functions
})
minetest.register_node("drwho_tardis:console_s"..set, {
		description = S("Functions Console Unit"),
		tiles = {stexture, stexture, side, side, side, side},
		groups = {cracky = 3},
		after_place_node = function(pos, placer, itemstack, pointed_thing)
			local pmeta = placer:get_meta()
			local id = pmeta:get_string("id")
			local r_pos = minetest.deserialize(data:get_string(id.."r_pos"))
			if not r_pos then r_pos = placer:get_pos() end
			if r_pos.x+50 > pos.x and r_pos.x-50 < pos.x and r_pos.z+50 > pos.z and r_pos.z-50 < pos.z and r_pos.y+50 > pos.y and r_pos.y-50 < pos.y then
				local meta = minetest.get_meta(pos)
				local id = pmeta:get_string("id")
				meta:set_string("id", id)
				meta:set_string("formspec", get_formspec_s())
			else minetest.dig_node(pos) end
		end,
		on_receive_fields = general_functions
})
minetest.register_node("drwho_tardis:console_go"..set, {
		description = S("Warp Lever Console Unit"),
		tiles = {wtexture, wtexture, side, side, side, side},
		groups = {cracky = 3},
		after_place_node = function(pos, placer, itemstack, pointed_thing)
			local pmeta = placer:get_meta()
			local id = pmeta:get_string("id")
			local r_pos = minetest.deserialize(data:get_string(id.."r_pos"))
			if not r_pos then r_pos = placer:get_pos() end
			if r_pos.x+50 > pos.x and r_pos.x-50 < pos.x and r_pos.z+50 > pos.z and r_pos.z-50 < pos.z and r_pos.y+50 > pos.y and r_pos.y-50 < pos.y then
				local meta = minetest.get_meta(pos)
				meta:set_string("id", id)
				meta:set_string("formspec", get_formspec_w())
			else minetest.dig_node(pos) end
		end,
		on_receive_fields = travel_to_location
})
minetest.register_node("drwho_tardis:console_c"..set, {
		description = S("Exterior Console Unit"),
		tiles = {ctexture, ctexture, side, side, side, side},
		groups = {cracky = 3},
		after_place_node = function(pos, placer, itemstack, pointed_thing)
			local pmeta = placer:get_meta()
			local id = pmeta:get_string("id")
			local r_pos = minetest.deserialize(data:get_string(id.."r_pos"))
			if not r_pos then r_pos = placer:get_pos() end
			if r_pos.x+50 > pos.x and r_pos.x-50 < pos.x and r_pos.z+50 > pos.z and r_pos.z-50 < pos.z and r_pos.y+50 > pos.y and r_pos.y-50 < pos.y then
				local meta = minetest.get_meta(pos)
				meta:set_string("id", id)
				meta:set_string("formspec", get_formspec_c("drwho_tardis:tardis_old"))
			else minetest.dig_node(pos) end
		end,
		on_receive_fields = change_look
})
minetest.register_node("drwho_tardis:console_o"..set, {
		description = S("Waypoint Console Unit"),
		tiles = {otexture, otexture, side, side, side, side},
		groups = {cracky = 3},
		after_place_node = function(pos, placer, itemstack, pointed_thing)
			local pmeta = placer:get_meta()
			local id = pmeta:get_string("id")
			local r_pos = minetest.deserialize(data:get_string(id.."r_pos"))
			if not r_pos then r_pos = placer:get_pos() end
			if r_pos.x+50 > pos.x and r_pos.x-50 < pos.x and r_pos.z+50 > pos.z and r_pos.z-50 < pos.z and r_pos.y+50 > pos.y and r_pos.y-50 < pos.y then
				local meta = minetest.get_meta(pos)
				meta:set_string("id", id)
				meta:set_string("formspec", get_formspec_o({id=id}))
			else minetest.dig_node(pos) end
		end,
		on_rightclick = function(pos, node, clicker, itemstack)
			local meta = minetest.get_meta(pos)
			local id = meta:get_string("id")
			local out_pos = minetest.deserialize(data:get_string(id.."out_pos"))
			meta:set_string("id", id)
			meta:set_string("formspec", get_formspec_o({
				x_dest = data:get_int(id.."x_dest"), 
				y_dest = data:get_int(id.."y_dest"), 
				z_dest = data:get_int(id.."z_dest"), 
				out_pos = out_pos, -- Current position
				id = id
			}))
		end,
		on_receive_fields = waypoint
})
minetest.register_node("drwho_tardis:rotor"..set, {
		description = S("Time Rotor"),
		tiles = {rotortexture},
		drawtype = "mesh",
		mesh = "tardis_2.obj",
		selection_box = {type = "fixed", fixed = { { -0.5, -0.5, -0.5, 0.5, 1.5, 0.5 } }},
		collision_box = {type = "fixed", fixed = { { -0.5, -0.5, -0.5, 0.5, 1.5, 0.5 } }},
		light_source = 10,
		groups = {cracky = 1},
		after_place_node = function(pos, placer, itemstack, pointed_thing)
			local pmeta = placer:get_meta()
			local id = pmeta:get_string("id")
			local r_pos = minetest.deserialize(data:get_string(id.."r_pos"))
			if not r_pos then r_pos = placer:get_pos() end
			if r_pos.x+50 > pos.x and r_pos.x-50 < pos.x and r_pos.z+50 > pos.z and r_pos.z-50 < pos.z and r_pos.y+50 > pos.y and r_pos.y-50 < pos.y then
				local meta = minetest.get_meta(pos)
				meta:set_string("id", id)
				meta:set_string("formspec", get_formspec_r(data:get_int(id.."power")))
				meta:set_string("style", set)
				data:set_string(id.."r_pos", minetest.serialize(pos))
				local timer = minetest.get_node_timer(pos)
				timer:start(15)
			else minetest.dig_node(pos) end
		end,
		on_rightclick = function(pos, node, clicker, itemstack)
			local meta = minetest.get_meta(pos)
			local id = meta:get_string("id")
			meta:set_string("formspec", get_formspec_r(data:get_int(id.."power")))
		end,
		on_timer = function(pos)
			local meta = minetest.get_meta(pos)
			local id = meta:get_string("id")
			if  data:get_int(id.."power") < 10 then data:set_int(id.."power", data:get_int(id.."power")+1) end
			meta:set_string("formspec", get_formspec_r(data:get_int(id.."power")))
			if data:get_string(id.."r_pos") == minetest.serialize(pos) then return true else return false end
		end
})
minetest.register_node("drwho_tardis:rotor_active"..set, {
		description = S("Time Rotor (active)"),
		tiles = { {name = altrotortexture, animation = {type = "vertical_frames", aspect_w = 64, aspect_h = 64, length = 1.5}} },
		drawtype = "mesh",
		mesh = "tardis_2.obj",
		selection_box = {type = "fixed", fixed = { { -0.5, -0.5, -0.5, 0.5, 1.5, 0.5 } }},
		collision_box = {type = "fixed", fixed = { { -0.5, -0.5, -0.5, 0.5, 1.5, 0.5 } }},
		light_source = 12,
		groups = {not_in_creative_inventory = 1},
})
minetest.register_node("drwho_tardis:light"..set, {
		description = S("Tardis Light"),
		inventory_image = ltexture,
		drawtype = "signlike",
		paramtype = "light",
		sunlight_propagates = true,
		walkable = false, -- Allow players to walk thru them (rather than blocking their movement)
		light_source = minetest.LIGHT_MAX, -- VERY bright
		paramtype2 = "wallmounted",
		selection_box = { type = "wallmounted" },
		tiles = {ltexture},
		groups = {oddly_breakable_by_hand = 1}
})
if craftitem == "" then return else
minetest.register_craft({
		output = "drwho_tardis:console_y"..set,
		recipe = {
			{craftitem},
			{"drwho_tardis:console_y"}
		}
})
minetest.register_craft({
		output = "drwho_tardis:console_x"..set,
		recipe = {
			{craftitem},
			{"drwho_tardis:console_x"}
		}
})
minetest.register_craft({
		output = "drwho_tardis:console_z"..set,
		recipe = {
			{craftitem},
			{"drwho_tardis:console_z"}
		}
})
minetest.register_craft({
		output = "drwho_tardis:console_c"..set,
		recipe = {
			{craftitem},
			{"drwho_tardis:console_c"}
		}
})
minetest.register_craft({
		output = "drwho_tardis:console_go"..set,
		recipe = {
			{craftitem},
			{"drwho_tardis:console_go"}
		}
})
minetest.register_craft({
		output = "drwho_tardis:console_f"..set,
		recipe = {
			{craftitem},
			{"drwho_tardis:console_f"}
		}
})
minetest.register_craft({
		output = "drwho_tardis:console_o"..set,
		recipe = {
			{craftitem},
			{"drwho_tardis:console_o"}
		}
})
minetest.register_craft({
		output = "drwho_tardis:console_s"..set,
		recipe = {
			{craftitem},
			{"drwho_tardis:console_s"}
		}
})
minetest.register_craft({
		output = "drwho_tardis:light"..set,
		recipe = {
			{craftitem},
			{"drwho_tardis:light"}
		}
})
minetest.register_craft({
		output = "drwho_tardis:rotor"..set,
		recipe = {
			{craftitem},
			{"drwho_tardis:rotor"}
		}
})
end
end

register_console_set("", "", "tardis_side_1.png", "y_console_1.png", "x_console_1.png", "z_console_1.png", "f_console_1.png", "s_console_1.png", "w_console_1.png", "c_console_1.png", "o_console_1.png", "rotor_1.png", "alt_rotor_1.png", "tardis_light_1.png")
register_console_set("_2", "group:wood", "tardis_side_2.png", "y_console_2.png", "x_console_2.png", "z_console_2.png", "f_console_2.png", "s_console_2.png", "w_console_2.png", "c_console_2.png", "o_console_2.png", "rotor_2.png", "alt_rotor_2.png", "tardis_light_2.png")
register_console_set("_3", "default:silver_sand", "tardis_side_3.png", "y_console_3.png", "x_console_3.png", "z_console_3.png", "f_console_3.png", "s_console_3.png", "w_console_3.png", "c_console_3.png", "o_console_3.png", "rotor_3.png", "alt_rotor_3.png", "tardis_light_3.png")