# Changelog

All notable changes to this project will be documented in this file.

This project was forked from [`tardis_new`](https://github.com/PiDemon/Taridis_New) and all of that projects' release notes to this changelog as well, down at the bottom.

The format is based on [Keep a Changelog](http://keepachangelog.com/en/1.0.0/) and this project adheres to [Semantic Versioning](http://semver.org/spec/v2.0.0.html). 

This changelog should display who changed it and link to issues / pull requests if nessesary.

## [1.2.0] - 2024-07-06

### Added

- Support for VoxeLibre (MineClone) and RePixture (project [#8662](https://codeberg.org/Skivling/DrWho_Tardis/projects/8662))
  
  - We detect the `GAMETYPE` and store in a variable, allowing easy checking.
  
  - All items used in crafting recipes are read from a table (`_drwho_tardis.items`) to allow us to change them depending on the game
  
  - The depth at which the Tardis is placed varies depending on the game. MTG & RP are at -10000, MCL is at -50, just above bedrock layer.
  
  - Anything that currently only supports MTG has been wrapped in a check to ensure that the right game is running and errors won't occur. Support for those things (mobs, awards, armor) in other games is planned but not high priority.

- `api.lua` for all API functions that aren't sonic or exterior related

- `/locate_tardis` chat command and related API function (#14)

- `/rebuild_tardis` chat command and related API function

- Several colour variants for the Tardis exterior. (@ApolloX939 in #30)

- A couple new nodes for Tardis interiors - variants of white circles, and a blank white/grey node.

- A new interior door style. Doors can also now be crafted.

- Different Tardis interiors and an API & system to manage them.

- Two new settings options: default Tardis interior and maximum Tardis power 

- Working Tardis gravity system - it will either go directly to the pos, land on top of a node below the pos, or the second and also sink in water. Change the setting by clicking the button on the console, or use `/tardis_mavity`. 

### Changed

- Tardis interiors are now placed with an API function, and supports different interior styles.

- Code structure (/mobs folder, /tardis folder) in order to reduce the amount of files in the root directory.

- Updated how we handle `toolranks` and `pick_axe_tweaks` as we were using older, deprecated api functions.

- Made all console nodes and Tardis monitor `4dir` rotational. This means they are facing the direction they are placed in instead of always the same direction.

- Sonic code is cleaned up, minor issues fixed and more customization for API users (@TPH in #29)

- The exterior select screen has been revamped to be able to select any exterior skin added via API. (#31)

- The Tardis sound and time rotor animation now start just after the lever is pulled and will only stop after the Tardis has actually landed.

### Fixed

- Fixed bug in Find Biome where the game would crash if the position was entered before a biome was found (#43)

- Check if the Time Rotor exists before travelling, fixing a crash if it's not there.

## [1.1.0] - 2024-03-28

### Added

- **Cybermen**
  
  - Uses textures and models from Scifi Mobs
  
  - Thanks to @ShadowOfHassen, there is also a melee version that has a slightly lighter colour texture.
  
  - The normal one shoots once every 3 seconds, dealing 5 damage. They drop steel ingots.

- @ShadowOfHassen contributed to Mobs Redo API, making a proper "alliance" to stop mobs from attacking each other. This means different variants of Daleks/Cybermen won't attack each other, using `attack_ignore`.

- Find Biome console unit - Replacing the Travel Factor unit (see under Changed for details), this utilises the API `findbiome`, allowing a Tardis's pilot to pick and go to a specific biome they would like to travel to.

- Weeping Angels (PLANNED) - The code and model for weeping angels have been added in a separate folder for now, forked from the old [`weeping`](https://forum.minetest.net/viewtopic.php?t=10766) mod. This will be adapted to work properly and probably released next version.

- Sonic device registration API - `drwho_tardis:register_sonic_device()`
  
  - This allows the creation of sonic devices, not necessarily just screwdrivers. You can also use specific parts of the screwdriver textures, e.g. choose 1,4,3. See API.md for more details.
  
  - The 'create sonic' on the functions console unit uses this API to create them now.

- Tardis exterior registration API - `drwho_tardis:register_tardis_exterior()`
  
  - NOTE: New exteriors are *not* shown on the exterior selector yet! Only the default ones!
  
  - See API.md for more details.

- Two more awards - Defeat a Dalek, and defeat a Cyberman.  

- [`subtitles`](https://content.minetest.net/packages/SilverSandstone/subtitles/) support for all sound effects and Dalek voicelines.

- Settings to turn on/off monsters, and to change spawn rates.

- Minetest translator support so in the future people will be able to translate it. There are currently 143 strings.

### Changed

- Merged several formspecs into one to make piloting a Tardis much easier
  
  - The X, Y, Z co-ords and Travel Factor are all in one formspec screen now. That screen is currently accessable via the 3 X, Y, and Z console units. In the future other functions will replace those extra units. 
  
  - The travel factor console unit is now the Find Biome one, see above.

- Daleks
  
  - Now use the `mobs:boom()` function instead of the deprecated `mobs:explosion()`
  
  - The Classic Dalek's namestring is now `drwho_tardis:dalek_classic` so that both variants' spawn eggs appear next to each other in the creative inventory.

## [1.0.0] - 2024-02-17

Thanks to @ShadowOfHassen for playtesting, running through ideas, and adding Scifi_Mobs textures. Thanks to @Irevol for the first two again, making the Sonic texture randomiser and helping to add migration support.

### Added

- A full Dalekanium armor set based on `3d_armor`, including a shield. Textures are CC-BY-SA 4.0. (@Skivling)

- `pick_axe_tweaks` support for the Dalekanium Pickaxe

- `toolranks` support for all four tools

- Daleks, forked from Scifi Mobs' Daleks using their models and textures. There are two variants - a Brown one (can fly) and a Gray one (can't fly, slightly weaker). (@Skivling)
  
  - Cybermen textures have also been added (@ShadowOfHassen, #2 ) but are not in the mod yet. Probably next version if the models and animations work.

- A texture randomiser for the Sonic Screwdriver. Currently there are 4 textures for each third of the screwdriver, and they are all randomised together to create the possibility for 64 (4^3) unique combinations. (@Irevol, #5 )

- Several achievements using the [`awards`](https://content.minetest.net/packages/rubenwardy/awards/) API. (@Skivling)

- Aliases to help people convert items & nodes in their world from `tardis_new` to `drwho_tardis`. (@Skivling & @Irevol)
  
  - @Skivling made a step-by-step migration guide on the wiki [here](https://drwhomod.miraheze.org/wiki/migration).

### Changed

- A lot of asset names. See [asset-info.md](https://codeberg.org/Skivling/DrWho_Tardis/src/branch/main/asset-info.md) for more information. 

- A lot of item + node names. See [item-info.md]([DrWho_Tardis/asset-info.md at main - Skivling/DrWho_Tardis - Codeberg.org](https://codeberg.org/Skivling/DrWho_Tardis/src/branch/main/item-info.md)) for more information. 

- The whole structure of the code. It is now separated into several files and most files have a CONTENTS part up the top explaining what is in it. (@Skivling)

- The Gallifreyan Lab crafting recipe. it is now easier to make because two of the Mese Crystals have been replaced with Bronze and Gold blocks.

### Removed

- The Vending Machine texture for the TARDIS, because it is a non-free asset that wasn't marked with a CC license, only "credit". 

---

##### `drwho_tardis` was forked from `tardis_new`, so below is a basic changelog for `tardis_new`, based on it's Github release notes.

---

## [Tardis_new [1.3.0](https://github.com/PiDemon/Taridis_New/releases/tag/1.3)] - 2021-05-01

### Added

- Gravity, but only in loaded areas.

### Fixed

- Bug fixes with placing TARDIS parts

## [Tardis_new [1.2.1](https://github.com/PiDemon/Taridis_New/releases/tag/1.2.1)] - 2021-03-27

### Fixed

- Fixed major bug that caused crashing when you die without placing a time rotor.

## [Tardis_new [1.2.0](https://github.com/PiDemon/Taridis_New/releases/tag/1.2.0)] - 2021-03-15

### Fixed

- Various bug fixes.

## [Tardis_new [1.1.0](https://github.com/PiDemon/Taridis_New/releases/tag/1.1.0)] - 2021-03-09

### Added

- Support for digilines

- Entities other than players can enter TARDISes.

### Changed

- "changes vortex manipulator"

### Fixed

- Minor bug fixes

## [Tardis_new [1.0.0](https://github.com/PiDemon/Taridis_New/releases/tag/1.0.0)] - 2021-03-09

### Includes:

- Three console sets for 8 types of console blocks

- Azbantium

- Dalekanium, and Dalekanium tools (sword, pickaxe, axe, shovel)

- Rassilon's Gauntlet

- Vortex Manipulator (time travel device)

- Extended Sonic Screwdriver functions
  
  - Support for Mesecons

## [Tardis_new Alpha ([0.1.0](https://github.com/PiDemon/Taridis_New/releases/tag/0.1.0))] - 2021-03-03

- First Release
