times_travelled_in_tardis = 0 --defined in console.lua --increased by 1 every time you travel in YOUR Tardis

local S = minetest.get_translator("drwho_tardis")

-- Use rubenwardy's awards mod in MTG
if _drwho_tardis.GAMETYPE == "mtg" then
if minetest.get_modpath("awards") then

check_drwho_awards = function(name)
    if times_travelled_in_tardis >= 1 then
        awards.unlock(name, "drwho_tardis:travel_in_tardis") -- unlock award (travel 1)
    end
    if times_travelled_in_tardis >= 10 then
        awards.unlock(name, "drwho_tardis:travel_in_tardis_10") -- unlock award (travel 10)
    end
    if times_travelled_in_tardis >= 50 then
        awards.unlock(name, "drwho_tardis:travel_in_tardis_50") -- unlock award (travel 50)
    end
    if times_travelled_in_tardis >= 500 then
        awards.unlock(name, "drwho_tardis:travel_in_tardis_500") -- unlock award (travel 500)
    end
end

awards.register_award("drwho_tardis:get_sonic_screwdriver", {
    title = S("Have you never seen a Sonic Screwdriver before?"),
    description = S("Obtain a Sonic Screwdriver"),
    -- trigger is in the Functions Console Unit line ~185
})

awards.register_award("drwho_tardis:craft_tardis", {
    title = S("Craft a TARDIS"),
    description = S("Craft a TARDIS"),
    trigger = {
        type = "craft",
        item = "drwho_tardis:tardis_old", -- item, alias, or group
        target = 1,
    }
})

awards.register_award("drwho_tardis:place_tardis", {
	title = S("Place a TARDIS"),
	description = S("Place down a TARDIS"),
    trigger = {
        type = "place",
        node = "drwho_tardis:tardis_old", -- item, alias, or group
        target = 1,
    }
})

awards.register_award("drwho_tardis:command_summon_tardis", {
    title = S("Come here!"),
    description = S("Summon your TARDIS using the chat command"),
    -- trigger = -- Awarded in the code for the command, in init.lua around line 410.
})

awards.register_award("drwho_tardis:go_inside_tardis", {
    title = S("It's bigger on the inside!"),
    description = S("Walk inside a TARDIS"),
    --trigger is in exterior.lua in function tardis_timer around line 55
})

awards.register_award("drwho_tardis:tardis_attack", {
    title = S("Threat nullified."),
    description = S("Attack a nearby player using the TARDIS defense system."),
    --trigger is in console.lua in function fields.attack around line 240
})

-- Travel in your TARDIS (1, 10, 50, 500)
awards.register_award("drwho_tardis:travel_in_tardis", {
    title = S("Allons-y!"),
    description = S("Travel using your TARDIS"),
    --if times_travelled_in_tardis >= 1 then unlock award
})

awards.register_award("drwho_tardis:travel_in_tardis_10", {
    title = S("Geronimo!"),
    description = S("Travel inside your TARDIS 10 times"),
    requires = {"drwho_tardis:travel_in_tardis",},
    --if times_travelled_in_tardis >= 10 then unlock award
})

awards.register_award("drwho_tardis:travel_in_tardis_50", {
    title = S("Just passing by"),
    description = S("Travel inside your TARDIS 50 times"),
    requires = {"drwho_tardis:travel_in_tardis_10",},
    --if times_travelled_in_tardis >= 50 then unlock award
})

awards.register_award("drwho_tardis:travel_in_tardis_500", {
    title = S("My way to travel"),
    description = S("Travel inside your TARDIS 500 times"),
    requires = {"drwho_tardis:travel_in_tardis_50",},
    --if times_travelled_in_tardis >= 500 then unlock award
})

-- Defeat Drwho mobs awards
awards.register_award("drwho_tardis:defeat_dalek", {
    title = S("No, I will NOT be exterminated!"),
    description = S("Defeat a Dalek!"),
    -- Triggered in on_die
})
awards.register_award("drwho_tardis:defeat_cyberman", {
    title = S("Cyberman - Defeated."),
    description = S("Defeat a Cyberman!"),
    -- Triggered in on_die
})

-- Biscuit awards (1, 50, 100, 1000)
awards.register_award("drwho_tardis:eat_biscuit_1", {
    title = S("It's just a normal biscuit, right?"),
    description = S("Eat one TARDIS Biscuit. Hint: Look at the Functions Console Unit"),
    icon = "tardis_biscuit.png",
    trigger = {
        type   = "eat",
        item   = "drwho_tardis:biscuit", -- item, alias, or group
        target = 1,
    },
})

awards.register_award("drwho_tardis:eat_biscuit_50", {
    title = S("They taste really good!"),
    description = S("Eat fifty TARDIS Biscuits in total."),
    requires = {"drwho_tardis:eat_biscuit_1",},
    icon = "tardis_biscuit.png",
    trigger = {
        type   = "eat",
        item   = "drwho_tardis:biscuit", -- item, alias, or group
        target = 50,
    },
})

awards.register_award("drwho_tardis:eat_biscuit_100", {
    title = S("My favourite snack"),
    description = S("Eat one hundred TARDIS Biscuits in total."),
    requires = {"drwho_tardis:eat_biscuit_50",},
    icon = "tardis_biscuit.png",
    trigger = {
        type   = "eat",
        item   = "drwho_tardis:biscuit", -- item, alias, or group
        target = 100,
    },
})

awards.register_award("drwho_tardis:eat_biscuit_1000", {
    title = S("Is this even healthy?"),
    description = S("Eat one thousand TARDIS Biscuits in total."),
    requires = {"drwho_tardis:eat_biscuit_100",},
    icon = "tardis_biscuit.png",
    trigger = {
        type   = "eat",
        item   = "drwho_tardis:biscuit", -- item, alias, or group
        target = 1000,
    },
})
end -- if 'awards' is found
end -- MTG awards


if _drwho_tardis.GAMETYPE == "mcl" then
    minetest.chat_send_all("Awards for MineClone do not exist yet!")
    -- I believe their system is different, also it game me error
end

if _drwho_tardis.GAMETYPE == "rp" then
    minetest.chat_send_all("Awards for Repixture do not exist yet!")
    -- Use rp_achievements
end