-- CONTENTS
--    Detect GAMETYPE
--    Interior rooms def 
--    Crafting aliases for different games 
--    Store itemstrings of our items
-- ** In the future, function to initiate userdata

local data = minetest.get_mod_storage()

-- DETECT GAME TYPE (MTG, MCL, RP)
_drwho_tardis.GAMETYPE = "???"
if minetest.get_modpath("default") then 
	_drwho_tardis.GAMETYPE = "mtg"
elseif minetest.get_modpath("mcl_core") then 
	_drwho_tardis.GAMETYPE = "mcl"
elseif minetest.get_modpath("rp_default") then 
	_drwho_tardis.GAMETYPE = "rp"
else 
	_drwho_tardis.GAMETYPE = "other"
end

-- Reset exterior list 
-- if this is not done, every time the server is restarted it will add them again
-- eventually overcrowding the list and looking bad
data:set_string("ext_list", minetest.serialize({}))

-- Interior depth
_drwho_tardis.interiorDepth = -300 -- default value
if _drwho_tardis.GAMETYPE == "mtg" then 
	_drwho_tardis.interiorDepth = -10000
elseif _drwho_tardis.GAMETYPE == "mcl" then
	_drwho_tardis.interiorDepth = -50 -- just above bedrock if placed at sea level
elseif _drwho_tardis.GAMETYPE == "rp" then
	_drwho_tardis.interiorDepth = -10000
end

-- Interior rooms, console or otherwise
-- door_0_offset is from where the schem is placed to where the exit door is
-- requires is a list of mods whose nodes are used in the interior, and may be used to ensure there are no unknown nodes. Although default interiors should strive to only use nodes from this mod.
-- door_<1 or 2>_offset is defined if that room has other Tardis doors which can lead somewhere else.
_drwho_tardis.rooms = {
	old = {
		type = "old",
		room_type = "console",
		path = minetest.get_modpath("drwho_tardis").."/schems/tardis_console_room_old.mts",
		door_0_offset = {x=7,y=2,z=16},
		door_1_offset = nil,
		door_2_offset = nil,
		requires = {"drwho_tardis"},
	},
	default = {
		type = "default",
		room_type = "console",
		path = minetest.get_modpath("drwho_tardis").."/schems/tardis_console_room_default.mts",
		door_0_offset = {x=11,y=5,z=19}, -- exit door
		door_1_offset = {x=19,y=6,z=11}, -- door on the left
		door_2_offset = {x=3,y=6,z=11},  -- door on the right
		requires = {"drwho_tardis"},
	},
	--[[green = {
		type = "green",
		room_type = "console",
		path = minetest.get_modpath("drwho_tardis").."/schems/tardis_console_room_green.mts",
		door_0_offset = {x=6,y=2,z=11},
		door_1_offset = nil,
		door_2_offset = nil,
		requires = {"drwho_tardis", "scifi_nodes"},
	},--]]
}

-- CRAFTING ALIASES
-- note that all crafting is going to be rethought and reworked at some point
-- but for now the equivelant items and nodes in different games are saved
-- in MCL, all console nodes use flowers as the special item

_drwho_tardis.items = {}
local i = _drwho_tardis.items -- make it easier to write and read

if _drwho_tardis.GAMETYPE == "mcl" then -- MINECLONE ITEMS
	i.ingot_steel 		= "mcl_core:iron_ingot"
	i.ingot_copper 		= "mcl_copper:copper_ingot"
	i.ingot_tin 		= "mcl_core:iron_ingot" -- They don't have tin, use iron instead
	i.lump_tin			= "mcl_core:iron_nugget"
	i.ingot_gold 		= "mcl_core:gold_ingot"
	i.diamond 			= "mcl_core:diamond"
	i.crystal 			= "mesecons:wire_00000000_off" -- Redstone, but has a weird itemstring
	i.coal				= "mcl_core:coal_lump"
	i.dirt				= "mcl_core:dirt"
	i.stone				= "mcl_core:stone"

	i.block_steel 		= "mcl_core:ironblock" -- steel is iron
	i.block_copper 		= "mcl_copper:block"
	i.block_tin 		= "mcl_core:ironblock" -- tin becomes iron
	i.block_bronze		= "mcl_copper:block" -- bronze becomes copper -- also O item
	i.block_gold 		= "mcl_core:goldblock"
	i.block_diamond 	= "mcl_core:diamondblock"
	i.block_crystal 	= "mesecons_torch:redstoneblock"

	i.stick 			= "mcl_core:stick"
	i.silver_sand 		= "mcl_core:sand"
	i.cactus 			= "mcl_flowers:tulip_orange" -- C item
	i.grass_dry 		= "mcl_flowers:tulip_white" -- X item
	i.grass_jungle 		= "mcl_flowers:allium" -- Z item
	i.grass 			= "mcl_flowers:poppy" -- Y item
	i.silver_sandstone 	= "mcl_flowers:azure_bluet" -- GO item
	i.glass 			= "mcl_core:glass"
	i.obsidian 			= "mcl_core:obsidian" -- F item
	i.flower			= "mcl_flower:dandelion" -- S item


elseif _drwho_tardis.GAMETYPE == "rp" then -- REPIXTURE ITEMS
	i.ingot_steel 		= "rp_default:ingot_steel"
	i.ingot_copper 		= "rp_default:ingot_copper"
	i.ingot_tin 		= "rp_default:ingot_tin"
	i.lump_tin			= "rp_default:tin_lump"
	i.ingot_gold 		= "rp_gold:ingot_gold"
	i.diamond 			= "rp_jewels:jewel"
	i.crystal 			= "rp_lumien:crystal_off"
	i.coal				= "rp_default:lump_coal"
	i.dirt				= "rp_default:dirt"
	i.stone				= "rp_default:stone"

	i.block_steel 		= "rp_default:block_steel"
	i.block_copper 		= "rp_default:block_copper"
	i.block_tin 		= "rp_default:block_tin"
	i.block_bronze		= "rp_default:block_bronze"  -- O item
	i.block_gold 		= "rp_gold:block_gold"
	i.block_diamond 	= "rp_jewels:jewel"
	i.block_crystal 	= "rp_lumien:block"

	i.stick 			= "rp_default:stick"
	i.cactus 			= "rp_default:cactus" -- C item
	i.grass_dry 		= "rp_default:dry_grass" -- X item
	i.grass_jungle 		= "rp_default:fern" -- Z item
	i.grass 			= "rp_default:grass" -- Y item
	i.silver_sand 		= "rp_default:sand" 
	i.silver_sandstone 	= "rp_default:sandstone" -- GO item
	i.glass 			= "rp_default:glass"
	i.obsidian 			= "rp_default:ingot_bronze" -- F item
	i.flower			= "rp_default:flower" -- S item

else -- MINETEST GAME ITEMS, and default to MTG to avoid stupid bugs relating to them being undefined

	i.ingot_steel 		= "default:steel_ingot"
	i.ingot_copper 		= "default:copper_ingot"
	i.ingot_tin 		= "default:tin_ingot"
	i.lump_tin			= "default:tin_lump"
	i.ingot_gold 		= "default:gold_ingot"
	i.diamond 			= "default:diamond"
	i.crystal 			= "default:mese_crystal"
	i.coal				= "default:coal_lump"
	i.dirt				= "default:dirt"
	i.stone				= "default:stone"

	i.block_steel 		= "default:steelblock"
	i.block_copper 		= "default:copperblock"
	i.block_tin 		= "default:tinblock"
	i.block_bronze		= "default:bronzeblock" -- C item
	i.block_gold 		= "default:goldblock"
	i.block_diamond 	= "default:diamondblock"
	i.block_crystal 	= "default:mese"

	i.stick 			= "default:stick"
	i.cactus 			= "default:cactus" -- C item
	i.grass_dry 		= "default:dry_grass_1" -- X item 
	i.grass_jungle 		= "default:junglegrass" -- Z item
	i.grass 			= "default:grass_1" -- Y item
	i.silver_sand 		= "default:silver_sand"
	i.silver_sandstone 	= "default:silver_sandstone_block" -- GO item
	i.glass 			= "default:glass"
	i.obsidian 			= "default:obsidian" -- F item
	i.flower			= "flowers:dandelion_white" -- S item
end


--
-- DrWho Items table
--

-- Access the full itemstrings of our items easier
_drwho_tardis.drwho_items = { 
    -- Our craftitems:
    arton_crystal = "drwho_tardis:arton_crystal",
    spacetime = "drwho_tardis:spacetime",
    circuitry_board = "drwho_tardis:circuitry_board",
    azbantium_shard = "drwho_tardis:azbantium_shard",
    dalekanium_ingot = "drwho_tardis:dalekanium_ingot",
    -- Nodes crafted:
    tardis = "drwho_tardis:tardis_old",
    lab = "drwho_tardis:lab",
    vortex_manipulator = "drwho_tardis:vortex_manipulator",
    rassilon_gauntlet = "drwho_tardis:rassilon_gauntlet",
    chest = "drwho_tardis:chest", -- Gallifreyan Chest
    rotor = "drwho_tardis:rotor",
    console_x = "drwho_tardis:console_x",
    console_y = "drwho_tardis:console_y",
    console_z = "drwho_tardis:console_z",
    console_go = "drwho_tardis:console_go",
    console_c = "drwho_tardis:console_c",
    console_f = "drwho_tardis:console_f",
    console_o = "drwho_tardis:console_o",
    console_s = "drwho_tardis:console_s",
    monitor = "drwho_tardis:monitor",
    light = "drwho_tardis:light",
    azbantium = "drwho_tardis:azbantium",
    azbantium_shard = "drwho_tardis:azbantium_shard",
    grey_block = "drwho_tardis:grey_block",
    grey_block_slab = "drwho_tardis:grey_block_slab",
    walls = {
        one_circle = "drwho_tardis:wall_one_circle",
        one_circle_halfs = "drwho_tardis:wall_one_circle_halfs",
        wall = "drwho_tardis:wall_craftable",
        circles_16 = "drwho_tardis:wall_circles_16x16",
        circles_32 = "drwho_tardis:wall_circles_32x32",
    },
}