-- CONTENTS
-- Node registrations for:
-- TARDIS in_door
-- locked in_door
--		  several wall nodes
--        special stone
--		  Gallifreyan Chest

local S = minetest.get_translator("drwho_tardis")
local data = minetest.get_mod_storage()

--data = minetest.get_mod_storage()


-- 	def needs:
-- 		itemstring
-- 		texture
--		description
-- everything else is not configurable.
-- * know that if you intend to have the itemstring part of your mod,
-- * you need to pass it with a leading colon (:), for example:
-- 		:extra_drwho:glass_in_door
function drwho_tardis:register_in_door_style(def)

	-- In the node metadata, there is the value 'type'. 'exit' if it is the door to leave the Tardis, 
	-- and there are two other possbible doors with values 'door_1' and 'door_2'. These will be able to go to
	-- other rooms in future updates.
	minetest.register_node(def.itemstring, {
		description = S(def.description),
		tiles = {def.texture},
		drawtype = "mesh",
		use_texture_alpha = "clip",
		mesh = "tardis.obj",
		paramtype2 = "4dir",
		selection_box = {
			type = "fixed",
			fixed = {
				{ -0.5, -0.5, -0.5, 0.5, 1.5, 0.5 },
			},
		},
		collision_box = {
		type = "fixed",
		fixed = {
			{ 0.48, -0.5,-0.5,  0.5,  1.5, 0.5},
			{-0.5 , -0.5, 0.48, 0.48, 1.5, 0.5},
			{-0.5,  -0.5,-0.5 ,-0.48, 1.5, 0.5},
			{-0.7,  -0.6,-0.7,  0.7, -0.48,0.7},
		}
		},
		sunlight_propagates = true,
		groups = {cracky=2, tardis_in_door=1},
		diggable = true,
		on_timer = function(pos)
		local meta = minetest.get_meta(pos)
		local type = meta:get_string("type") or "exit"
		local objs = minetest.get_objects_inside_radius(pos, 0.9)
		if type == "exit" or type == nil or type == "" then
			if type == nil then meta:set_string("type", "exit") end -- Backwards compatability
			if objs[1] == nil then return true else
				if objs[1]:is_player() then
				
					local pmeta = objs[1]:get_meta()
					local meta = minetest.get_meta(pos)
					local id = meta:get_string("id")
					local go_pos = minetest.deserialize(data:get_string(id.."out_pos"))
					
					go_pos.z = go_pos.z-2
					objs[1]:set_pos(go_pos)
					objs[1]:set_look_horizontal( math.rad( 180 ))
					objs[1]:set_look_vertical( math.rad( 0 ))
					
					if pmeta:get_string("vortex") == "yes" then 
						go_pos.z = go_pos.z-2
						objs[1]:set_pos(go_pos)
						objs[1]:set_hp(0) 
					end
		
					minetest.after(1, function()
						local meta = minetest.get_meta(pos)
						local id = meta:get_string("id")
						local go_pos = minetest.deserialize(data:get_string(id.."out_pos"))
						local look = data:get_string(id.."look")
						minetest.set_node(go_pos, {name=look})
						local ometa = minetest.get_meta(go_pos)
						ometa:set_string("id", id)
						local timer = minetest.get_node_timer(go_pos)
						timer:start(0.2)
					end)
				else
					local meta = minetest.get_meta(pos)
					local id = meta:get_string("id")
					local go_pos = minetest.deserialize(data:get_string(id.."out_pos"))
					go_pos.z = go_pos.z-2
					objs[1]:set_pos(go_pos)
				end
			end
			return true
		else -- it is door_1 or door_2
			
			if objs[1] == nil then return true else
				if objs[1]:is_player() then
				
					local pmeta = objs[1]:get_meta()
					local meta = minetest.get_meta(pos)
					local id = meta:get_string("id")
					local name = objs[1]:get_player_name()

					minetest.after(1, function()
						--[[
						local meta = minetest.get_meta(pos)
						local id = meta:get_string("id")
						local go_pos = minetest.deserialize(data:get_string(id.."out_pos"))
						local look = data:get_string(id.."look")
						minetest.set_node(go_pos, {name=look})
						local ometa = minetest.get_meta(go_pos)
						ometa:set_string("id", id)
						local timer = minetest.get_node_timer(go_pos)
						timer:start(0.2)--]]
						minetest.chat_send_player(name, S("This door ("..type.."), does not go anywhere yet. Next update it will be able to go to extra rooms and/or corridors."))
					end)
				else
					
				end
			end
			return true

		end
		end
	})

	minetest.register_node(def.itemstring.."_locked", {
		description = S("Locked @1", def.description),
		tiles = {def.texture},
		drawtype = "mesh",
		use_texture_alpha = "clip",
		mesh = "tardis.obj",
		selection_box = {
			type = "fixed",
			fixed = {
				{ -0.5, -0.5, -0.5, 0.5, 1.5, 0.5 },
			},
		},
		collision_box = {
		type = "fixed",
		fixed = {
			{ -0.5, -0.5, -0.5, 0.5, 1.5, 0.5 },
		},
		},
		sunlight_propagates = true,
		groups = {not_in_creative_inventory = 1, tardis_in_door_locked = 1},
		diggable = false,
	})
end


drwho_tardis:register_in_door_style({
	texture = "inside_door.png",
	description = "Tardis Interior Door (style A)",
	itemstring = "drwho_tardis:in_door"
})
drwho_tardis:register_in_door_style({
	texture = "drwho_tardis_inside_door_b.png",
	description = "Tardis Interior Door (style B)",
	itemstring = "drwho_tardis:in_door_b"
})
-- Recipes for these are in recipes.lua

-- False trigger translation
local qwerty = S("Tardis Interior Door (style A)")

minetest.register_node("drwho_tardis:wall", {
	description = S("Tardis Wall (non-craftable)"),
	tiles = {"tardis_wall.png"},
	diggable = false,
	groups = { not_in_creative_inventory = 1},
	light_source = 2,
})
minetest.register_node("drwho_tardis:wall_craftable", {
	description = S("Tardis Wall"),
	tiles = {"tardis_wall.png"},
	groups = {cracky = 1},
	light_source = 2,
})
minetest.register_node("drwho_tardis:wall_circles_16x16", { -- with 8x8 circles in 45* rotated square formation
	description = S("Tardis Wall - Circles (16x16)"),
	tiles = {"drwho_tardis_wall_circles_16x16.png"},
	groups = {cracky = 1},
	light_source = 8,
})
minetest.register_node("drwho_tardis:wall_one_circle", {
	description = S("Tardis Wall - Large Circle"),
	tiles = {"drwho_tardis_wall_one_circle.png"},
	groups = {cracky = 1},
	light_source = 8,
})
minetest.register_node("drwho_tardis:wall_one_circle_halfs", {
	description = S("Tardis Wall - Large Circle Halfs"),
	tiles = {"drwho_tardis_wall_one_circle_halfs.png"},
	groups = {cracky = 1},
	light_source = 8,
})
local front = "drwho_tardis_wall_circles_32x32.png"
local top = "drwho_tardis_wall_circles_32x32_top.png"
minetest.register_node("drwho_tardis:wall_circles_32x32", { -- with 12x12 circles in hexagonal formation
	description = S("Tardis Wall - Circles (32x32)"),
	tiles = {top, top, front, front, front, front},
	groups = {cracky = 1},
	light_source = 8,
})

minetest.register_node("drwho_tardis:grey_block", {
	description = S("Light Grey Block"),
	tiles = {"drwho_tardis_grey_block.png"},
	groups = {cracky = 1},
})
minetest.register_node("drwho_tardis:grey_block_slab", {
	description = S("Light Grey Block Slab"),
	tiles = {"drwho_tardis_grey_block.png"},
	groups = {cracky = 1},
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = {-0.5, -0.5, -0.5, 0.5, 0, 0.5},
	},
})
minetest.register_node("drwho_tardis:stone", {
		description = S("Stone"),
		tiles = {"default_stone.png"},
		diggable = false,
		groups = { not_in_creative_inventory = 1},
})

-- gallifreyan chest
local function get_formspec_chest()
    return "size[24,15]"..
		"list[context;main;0,0.5;24,10;]"..
		"list[current_player;main;8,10.5;8,4;]"
end
minetest.register_node("drwho_tardis:chest", {
		description = S("Gallifreyan Chest"),
		tiles = {"tardis_chest_top.png", "tardis_chest_top.png", "tardis_chest_side.png", "tardis_chest_side.png", "tardis_chest_side.png", "tardis_chest_side.png"},
		groups = {cracky = 3},
		after_place_node = function(pos, placer, itemstack, pointed_thing)
			local meta = minetest.get_meta(pos)
			local inv = meta:get_inventory()
			meta:set_string("owner", placer:get_player_name())
			meta:set_string("infotext", S("Chest owned by @1", placer:get_player_name()))
			meta:set_string("formspec", get_formspec_chest())
			inv:set_size("main", 24*10) -- VERY large
		end,
		on_rightclick = function(pos, node, clicker, itemstack) 
			local meta = minetest.get_meta(pos)
			if clicker:get_player_name() == meta:get_string("owner") then meta:set_string("formspec", get_formspec_chest(pos)) else meta:set_string("formspec", "") end
		end -- gallifreyan chest
})