-- CONTENTS
-- Cyberman
-- Melee Cyberman

local S = minetest.get_translator("drwho_tardis")

if _drwho_tardis.GAMETYPE == "mtg" then
if minetest.get_modpath("mobs") then

mobs:register_mob("drwho_tardis:cyberman", {
	type = "monster",
	passive = false,
    armor = 70, -- Takes 70% of damage usually dealt
    hp_min = 55,
	hp_max = 55, -- Spawns with 55 hp

    --attack
    attack_type = "dogshoot",
    damage = 6,
    reach = 2,
    group_helper = "drwho_tardis:cyberman_melee",
    attack_monsters = true,
    attack_animals = true,
    attack_npcs = true,
    attack_players = true,
    attack_ignore = {"drwho_tardis:cyberman_melee"},
    arrow = "drwho_tardis:blaser", --Arrow object it attacks with (laser)
    shoot_interval = 3, -- Shoots once every 3 seconds
    shoot_offset = 1, -- y pos of where the laser comes from
 
    group_attack = true, -- Attacks in groups
    immune_to = { -- Immune to wood tools
        {"default:pick_wood", 0},
        {"default:shovel_wood", 0},
        {"default:axe_wood", 0},
        {"default:sword_wood", 0}
    },

    drops = {
        {
        name = "default:steel_ingot",
        chance = 1, -- Always drops
        min = 5,
        max = 7, -- Drop between 5 and 6 Steel Ingots
        },
    },

    -- Mechanics
    pathfinding = 1, -- Chase player
    view_range = 28, -- Can see target within 14 nodes
    pushable = true, -- Can be pushed when attacked
    floats = 0, -- Sinks in water
    fly = false, -- Can't fly
    makes_footstep_sound = true,
    walk_velocity = 1,
	run_velocity = 2,
    jump = true,
    jump_height = 1,
    water_damage = 2, -- Slowly dies from drowning (2 hp / second)
	lava_damage = 2,
	light_damage = 0,
	collisionbox = {-0.4, -1, -0.4, 0.4, 1.5, 0.4},
    selectionbox = {-0.4, -1, -0.4, 0.4, 1.5, 0.4},

    -- Visual
    blood_amount = 0, -- Does not spurt blood
    visual = "mesh",
	mesh = "cyberman.b3d",
	textures = { {"scifi_cyberman2.png"}, },
	visual_size = {x=1.5, y=1.5},
    randomly_turn = true, -- Turn to look at player, and turn randomly otherwise
	animation = { -- All from Scifi_mobs code
		speed_normal = 10,
		speed_run = 10,
		walk_start = 30,
		walk_end = 50,
		stand_start = 1,
		stand_end = 1,
		run_start = 30,
		run_end = 50,
		punch_start = 1,
		punch_end = 20,
		shoot_start = 1,
		shoot_end = 20,
	},

    sounds = {
        shoot_attack = "Laser", -- Laser sound
      },

    on_die = function(self)
        if self.cause_of_death.puncher ~= nil then 
            name = self.cause_of_death.puncher:get_player_name()
            if minetest.get_modpath("awards") and name ~= nil then
                awards.unlock(name, "drwho_tardis:defeat_cyberman")
            end
        end
    end
})


mobs:register_mob("drwho_tardis:cyberman_melee", {
	type = "monster",
	passive = false,
    armor = 70, -- Takes 70% of damage usually dealt
    hp_min = 55,
	hp_max = 55, -- Spawns with 55 hp
    --attack
    group_helper = "drwho_tardis:cyberman",
    attack_type = "dogfight",
    damage = 6,
    reach = 2,
    attack_monsters = true,
    attack_animals = true,
    attack_npcs = true,
    attack_players = true,
    attack_ignore = {"drwho_tardis:cyberman"},
 
    group_attack = true, -- Attacks in groups
    immune_to = { -- Immune to wood tools
        {"default:pick_wood", 0},
        {"default:shovel_wood", 0},
        {"default:axe_wood", 0},
        {"default:sword_wood", 0}
    },

    drops = {
        {
        name = "default:steel_ingot",
        chance = 1, -- Always drops
        min = 5,
        max = 7, -- Drop between 5 and 7 Steel Ingots
        },
    },

    -- Mechanics
    pathfinding = 1, -- Chase player
    view_range = 28, -- Can see target within 14 nodes
    pushable = true, -- Can be pushed when attacked
    floats = 0, -- Sinks in water
    fly = false, -- Can't fly
    makes_footstep_sound = true,
    walk_velocity = 1,
	run_velocity = 2,
    jump = true,
    jump_height = 1,
    water_damage = 2, -- Slowly dies from drowning (2 hp / second)
	lava_damage = 2,
	light_damage = 0,
	collisionbox = {-0.4, -1, -0.4, 0.4, 1.5, 0.4},
    selectionbox = {-0.4, -1, -0.4, 0.4, 1.5, 0.4},

    -- Visual
    blood_amount = 0, -- Does not spurt blood
    visual = "mesh",
	mesh = "cyberman.b3d",
	textures = { {"scifi_cyberman2.png"}, },
	visual_size = {x=1.5, y=1.5},
    randomly_turn = true, -- Turn to look at player, and turn randomly otherwise
	animation = { -- All from Scifi_mobs code
		speed_normal = 10,
		speed_run = 10,
		walk_start = 30,
		walk_end = 50,
		stand_start = 1,
		stand_end = 1,
		run_start = 30,
		run_end = 50,
		punch_start = 1,
		punch_end = 20,
		shoot_start = 1,
		shoot_end = 20,
	},

    sounds = {
        shoot_attack = "Laser", -- Laser sound
      },

    on_die = function(self)
        if self.cause_of_death.puncher ~= nil then 
            name = self.cause_of_death.puncher:get_player_name()
            if minetest.get_modpath("awards") and name ~= nil then
                awards.unlock(name, "drwho_tardis:defeat_cyberman")
            end
        end
    end
})

-- Spawn egg
mobs:register_egg("drwho_tardis:cyberman", S("Cyberman"), "scifi_cyberman_inv.png", 1)

-- Natural Spawning
mobs:spawn({
    name = "drwho_tardis:cyberman",
    nodes = { -- The nodes it can spawn on
        "group:dirt", 
        "group:stone", 
        "group:sand", 
        "default:mossycobble", -- In dungeons 
        "default:cobble"
    }, 
    active_object_count = 4, -- Can spawn up to 4 Cybermen at a time
    interval = 60, -- checks to spawn once a minute
    chance = tonumber(minetest.settings:get("drwho_tardis.cybermen_spawn_rate") or 60000), -- Should be at or above 60000, except when testing.
    -- Everything else is handled by the default values
})

mobs:register_egg("drwho_tardis:cyberman_melee", S("Cyberman Melee"), "scifi_cyberman_inv.png", 1)

-- Natural Spawning
mobs:spawn({
    name = "drwho_tardis:cyberman_melee",
    nodes = { -- The nodes it can spawn on
        "group:dirt", 
        "group:stone", 
        "group:sand", 
        "default:mossycobble", -- In dungeons 
        "default:cobble"
    }, 
    active_object_count = 4, -- Can spawn up to 4 Cybermen at a time
    interval = 60, -- checks to spawn once a minute
    chance = tonumber(minetest.settings:get("drwho_tardis.cybermen_spawn_rate") or 60000), -- Should be at or above 60000, except when testing.
    -- Everything else is handled by the default values
})

-- Cyberman laser (arrow)
-- Adapted from the Blaser arrow from Scifi Mobs, under LGPL
mobs:register_arrow("drwho_tardis:blaser", {
    visual = "sprite",
    visual_size = {x = 0.5, y = 0.5},
    textures = {"scifi_mobs_laser.png"},
    velocity = 30, -- used to be 18
    tail = 1, -- enable tail
    tail_texture = "scifi_mobs_laser.png",
 
    hit_player = function(self, player)
       player:punch(self.object, 1.0, {
          full_punch_interval = 1.0,
          damage_groups = {fleshy = 5},
       }, nil)
    end,
    
    hit_mob = function(self, player)
       player:punch(self.object, 1.0, {
          full_punch_interval = 1.0,
          damage_groups = {fleshy = 6},
       }, nil)
    end,
 
    hit_node = function(self, pos, node)
       mobs:boom(self, pos, 1, 2) -- 1 radius & 2 damage_radius
    end,
 })
 
end -- If 'mobs' wrapper
end -- MTG check