-- CONTENTS
-- Drwho items def for easier access
-- Gallifreyan Lab
-- All recipes that are not CRAFTITEMS or ARMOR

-- Not used in this file.
local S = minetest.get_translator("drwho_tardis")

local i = _drwho_tardis.items
-- i.block_steel returns the steel block depending on what gametype it is
-- e.g. default:steelblock , rp_default:block_steel , mcl_core:ironblock
-- this makes it easier to have cross-game crafting recipes

-- ensure that crafting recipes have similar progression requirements across games
-- MTG recipes should be easier to make than they currently are as well
-- ~~use `rp_crafting_compat` to make RePixture crafting easier~~ NO
-- For rp, all crafts must use 4 or less different items

local d =  _drwho_tardis.drwho_items -- Shorthand for easy writing/reading

-- GALLIFREYAN LAB

local function get_formspec_lab()
	if _drwho_tardis.GAMETYPE == "mcl" then
		return "size[10,10]"..
		"image[4.5,2;1,1;arrow_icon.png]"..
		"list[current_name;fuel;2,2;1,1;1]"..
		"list[current_name;dest;7,2;1,1;1]"..
		"list[current_player;main;1,5;8,4;]"
    else 
		return "size[10,10]"..
		"image[4.5,2;1,1;arrow_icon.png]"..
		"list[context;fuel;2,2;1,1;1]"..
		"list[context;dest;7,2;1,1;1]"..
		"list[current_player;main;1,5;8,4;]"
	end
end
local function lab_recipe(item,result,pos, player)
	local meta = minetest.get_meta(pos)
	local inv = meta:get_inventory()
	if inv:contains_item("fuel", item) == true and inv:is_empty("dest") then
		inv:remove_item("fuel",item)
		local fuel_s = inv:get_stack("fuel", 2)
		inv:set_stack("fuel", 2, fuel_s)
		inv:set_stack("dest", 2, result)
		player:set_hp(player:get_hp()-4)
	end
end
local function lab_crafting(pos, player)
	lab_recipe(i.block_diamond,	d.spacetime, pos, player)
	lab_recipe(i.crystal,		d.arton_crystal, pos, player)
	lab_recipe(i.diamond,		d.azbantium_shard, pos, player)
	lab_recipe(i.block_crystal,	i.diamond, pos, player)
	lab_recipe(i.ingot_copper,	i.ingot_steel, pos, player)
	lab_recipe(i.coal,			i.lump_tin, pos, player)
	lab_recipe(i.block_steel,	i.crystal, pos, player)
	lab_recipe(i.dirt,			i.coal, pos, player)
    lab_recipe(i.stone,			d.grey_block, pos, player)
end
minetest.register_node("drwho_tardis:lab", {
		description = S("Gallifreyan Lab"),
		tiles = {"tardis_lab.png"},
		groups = {cracky = 3},
		on_construct = function(pos, node)
			local meta = minetest.get_meta(pos)
			local inv = meta:get_inventory()
			inv:set_size("fuel", 2*1)
			inv:set_size("dest", 2*1)
			formspec = get_formspec_lab()
			meta:set_string("formspec", formspec)
		end,
		on_metadata_inventory_put = function(pos, listname, index, stack, player)
			lab_crafting(pos, player)
		end,
		on_metadata_inventory_take = function(pos, listname, index, stack, player)
			lab_crafting(pos, player)
		end -- Gallifreyan Lab
})

---------------------
--RePixture Recipes--
---------------------

if _drwho_tardis.GAMETYPE == "rp" then

    crafting.register_craft({
        output = d.tardis,
        items = {
            i.block_steel.." 6",
            d.arton_crystal,
            d.spacetime,
            d.circuitry_board.." 1"
        }
    })
    crafting.register_craft({
        output = d.lab,
        items = {
            i.block_bronze.." 2",
            i.block_steel.." 2",
            i.crystal.." 2",
            d.circuitry_board,
        }
    })
    crafting.register_craft({
        output = d.vortex_manipulator,
        items = { -- less the azbantium shards
            d.arton_crystal,
            i.crystal.." 2",
            i.block_tin,
            d.circuitry_board
        }
    })
    crafting.register_craft({
        output = d.rassilon_gauntlet,
        items = {
            d.dalekanium_ingot.." 5",
            i.block_diamond,
            d.arton_crystal.." 2",
        }
    })
    crafting.register_craft({
        output = d.chest,
        items = {
            i.ingot_steel.." 8",
            d.spacetime
        }
    })
    crafting.register_craft({
        output = d.circuitry_board.." 2",
        items = {
            i.block_gold,
            i.ingot_copper.." 3",
            "group:wood 3",
            i.crystal
        }
    })
    crafting.register_craft({
        output = d.rotor,
        items = {
            i.glass.." 2",
            d.circuitry_board,
            d.arton_crystal,
            i.block_steel.." 2"
        }
    })
    crafting.register_craft({
        output = d.console_y,
        items = {
            i.ingot_steel.." 7",
            d.circuitry_board,
            i.grass
        }
    })
    crafting.register_craft({
        output = d.console_x,
        items = {
            i.ingot_steel.." 7",
            d.circuitry_board,
            i.grass_dry
        }
    })
    crafting.register_craft({
        output = d.console_z,
        items = {
            i.ingot_steel.." 7",
            d.circuitry_board,
            i.grass_jungle
        }
    })
    crafting.register_craft({
        output = d.console_go,
        items = {
            i.ingot_steel.." 7",
            d.circuitry_board,
            i.silver_sandstone -- default sandstone
        }
    })
    crafting.register_craft({
        output = d.console_c,
        items = {
            i.ingot_steel.." 7",
            d.circuitry_board,
            i.cactus
        }
    })
    crafting.register_craft({
        output = d.console_f,
        items = {
            i.ingot_steel.." 7",
            d.circuitry_board,
            i.obsidian
        }
    })
    crafting.register_craft({
        output = d.console_o,
        items = {
            i.ingot_steel.." 7",
            d.circuitry_board,
            i.block_bronze
        }
    })
    crafting.register_craft({
        output = d.console_s,
        items = {
            i.ingot_steel.." 7",
            d.circuitry_board,
            i.flower
        }
    })
    crafting.register_craft({
        output = d.monitor,
        items = {
            i.ingot_steel.." 8",
            d.circuitry_board,
            i.glass
        }
    })
    crafting.register_craft({
        output = d.light.." 4",
        items = {
            i.ingot_steel.." 4",
            d.arton_crystal,
            i.crystal -- Lumien crystal
        }
    })
    crafting.register_craft({
        output = d.azbantium,
        items = {
            d.azbantium_shard.." 4"
        }
    })
    crafting.register_craft({
        output = d.azbantium_shard.." 4",
        items = {
            d.azbantium
        }
    })
    crafting.register_craft({
        output = d.dalekanium_ingot,
        items = {
            i.ingot_gold,
            d.azbantium_shard.." 2",
            "rp_default:ingot_carbon_steel 2", 
            i.obsidian.." 2" -- Bronze Ingot
        }
    })
    crafting.register_craft({
        output = d.grey_block,
        items = {
            d.grey_block_slab.." 2"
        }
    })
    crafting.register_craft({
        output = d.grey_block_slab.." 2",
        items = {
            d.grey_block
        }
    })
    crafting.register_craft({
        output = "drwho_tardis:in_door",
        items = {
            i.ingot_steel.." 6", 
            d.azbantium_shard.." 2", 
            d.circuitry_board,
        }
    })
    crafting.register_craft({
        output = "drwho_tardis:in_door_b",
        items = {"drwho_tardis:in_door"}
    })
    crafting.register_craft({
        output = "drwho_tardis:in_door",
        items = {"drwho_tardis:in_door_b"}
    })
    -- loops through all wall nodes and adds recipes
    for _, wall in pairs(d.walls) do
        crafting.register_craft({
            output = wall.." 9",
            items = {
                i.ingot_steel.." 4",
                d.arton_crystal,
            },
        })
    end
    crafting.register_craft({
        output = d.walls.one_circle_halfs,
        items = {d.walls.one_circle}
    })
    crafting.register_craft({
        output = d.walls.one_circle,
        items = {d.walls.one_circle_halfs}
    })

else -- It's not Repixture, do normal crafting

-----------
--Recipes--
-----------

    minetest.register_craft({
        output = d.tardis,
        recipe = {
            {i.block_steel, d.arton_crystal, i.block_steel},
            {i.block_steel, d.spacetime, i.block_steel},
            {i.block_steel, d.circuitry_board, i.block_steel}
        }
    })
    minetest.register_craft({
        output = d.lab,
        recipe = {
            {i.block_tin, i.block_bronze, i.block_steel},
            {i.crystal, d.circuitry_board, i.crystal},
            {i.block_steel, i.block_gold, i.block_tin}
        }
    })
    minetest.register_craft({
        output = d.vortex_manipulator,
        recipe = {
            {i.stick, d.circuitry_board, i.stick},
            {i.crystal, d.arton_crystal, i.crystal},
            {d.azbantium_shard, i.block_tin, d.azbantium_shard}
        }
    })
    minetest.register_craft({
        output = d.rassilon_gauntlet,
        recipe = {
            {d.arton_crystal, d.dalekanium_ingot, d.arton_crystal},
            {d.dalekanium_ingot, i.block_diamond, d.dalekanium_ingot},
            {d.dalekanium_ingot, "", d.dalekanium_ingot}
        }
    })
    minetest.register_craft({
        output = d.chest,
        recipe = {
            {i.ingot_steel, i.ingot_steel, i.ingot_steel},
            {i.ingot_steel, d.spacetime, i.ingot_steel},
            {i.ingot_steel, i.ingot_steel, i.ingot_steel}
        }
    })
    minetest.register_craft({
        output = d.circuitry_board.." 2",
        recipe = {
            {i.ingot_copper, i.diamond, i.ingot_tin},
            {i.crystal, i.block_gold, i.ingot_steel},
            {"group:wood", "group:wood", "group:wood"}
        }
    })
    minetest.register_craft({
        output = d.rotor,
        recipe = {
            {i.block_steel, i.diamond, i.block_steel},
            {i.glass, d.arton_crystal, i.glass},
            {i.block_steel, d.circuitry_board, i.block_steel}
        }
    })
    minetest.register_craft({
        output = d.console_y,
        recipe = {
            {i.ingot_steel, i.ingot_steel, i.ingot_steel},
            {i.ingot_steel, i.grass, i.ingot_steel},
            {i.ingot_steel, d.circuitry_board, i.ingot_steel}
        }
    })
    minetest.register_craft({
        output = d.console_x,
        recipe = {
            {i.ingot_steel, i.ingot_steel, i.ingot_steel},
            {i.ingot_steel, i.grass_dry, i.ingot_steel},
            {i.ingot_steel, d.circuitry_board, i.ingot_steel}
        }
    })
    minetest.register_craft({
        output = d.console_z,
        recipe = {
            {i.ingot_steel, i.ingot_steel, i.ingot_steel},
            {i.ingot_steel, i.grass_jungle, i.ingot_steel},
            {i.ingot_steel, d.circuitry_board, i.ingot_steel}
        }
    })
    minetest.register_craft({
        output = d.console_go,
        recipe = {
            {i.ingot_steel, i.ingot_steel, i.ingot_steel},
            {i.ingot_steel, i.silver_sandstone, i.ingot_steel},
            {i.ingot_steel, d.circuitry_board, i.ingot_steel}
        }
    })
    minetest.register_craft({
        output = d.console_c,
        recipe = {
            {i.ingot_steel, i.ingot_steel, i.ingot_steel},
            {i.ingot_steel, i.cactus, i.ingot_steel},
            {i.ingot_steel, d.circuitry_board, i.ingot_steel}
        }
    })
    minetest.register_craft({
        output = d.console_f,
        recipe = {
            {i.ingot_steel, i.ingot_steel, i.ingot_steel},
            {i.ingot_steel, i.obsidian, i.ingot_steel},
            {i.ingot_steel, d.circuitry_board, i.ingot_steel}
        }
    })
    minetest.register_craft({
        output = d.console_o,
        recipe = {
            {i.ingot_steel, i.ingot_steel, i.ingot_steel},
            {i.ingot_steel, i.block_bronze, i.ingot_steel},
            {i.ingot_steel, d.circuitry_board, i.ingot_steel}
        }
    })
    minetest.register_craft({
        output = d.console_s,
        recipe = {
            {i.ingot_steel, i.ingot_steel,      i.ingot_steel},
            {i.ingot_steel, i.flower,           i.ingot_steel},
            {i.ingot_steel, d.circuitry_board, i.ingot_steel}
        }
    })
    minetest.register_craft({
        output = d.monitor,
        recipe = {
            {i.ingot_steel, i.ingot_steel, i.ingot_steel},
            {i.ingot_steel, d.circuitry_board, i.ingot_steel},
            {i.ingot_steel, i.ingot_steel, i.ingot_steel}
        }
    })
    minetest.register_craft({
        output = d.light.." 4",
        recipe = {
            {"", i.ingot_steel, ""},
            {i.ingot_steel, d.arton_crystal, i.ingot_steel},
            {"", i.ingot_steel, ""}
        }
    })
    minetest.register_craft({
        output = d.azbantium,
        recipe = {
            {d.azbantium_shard, d.azbantium_shard},
            {d.azbantium_shard, d.azbantium_shard}
        }
    })
    minetest.register_craft({
        type = "shapeless",
        output = d.azbantium_shard.." 4",
        recipe = {d.azbantium}
    })

    minetest.register_craft({
        output = d.dalekanium_ingot,
        recipe = {
            {i.obsidian, i.ingot_steel, i.obsidian},
            {d.azbantium_shard, i.ingot_gold, d.azbantium_shard},
            {i.obsidian, i.ingot_steel, i.obsidian}
        }
    })
    minetest.register_craft({
        output = "drwho_tardis:in_door",
        recipe = {
            {i.ingot_steel, d.azbantium_shard, i.ingot_steel},
            {i.ingot_steel, d.circuitry_board, i.ingot_steel},
            {i.ingot_steel, d.azbantium_shard, i.ingot_steel}
        }
    })
    minetest.register_craft({
        type = "shapeless",
        output = "drwho_tardis:in_door_b",
        recipe = {"drwho_tardis:in_door"}
    })
    minetest.register_craft({
        type = "shapeless",
        output = "drwho_tardis:in_door",
        recipe = {"drwho_tardis:in_door_b"}
    })
    minetest.register_craft({
        output = d.walls.wall.." 9",
        recipe = {
            {i.ingot_steel},
            {d.arton_crystal},
            {i.ingot_steel}
        }
    })
    minetest.register_craft({
        output = d.walls.circles_16.." 9",
        recipe = {
            {"","",i.ingot_steel},
            {"",d.arton_crystal,""},
            {i.ingot_steel,"",""},
        }
    })
    minetest.register_craft({
        output = d.walls.circles_32.." 9",
        recipe = {
            {i.ingot_steel,"",""},
            {"",d.arton_crystal,""},
            {"","",i.ingot_steel},
        }
    })
    minetest.register_craft({
        output = d.walls.one_circle.." 9",
        recipe = {
            {i.ingot_steel,"",""},
            {"",d.arton_crystal,""},
            {i.ingot_steel,"",""},
        }
    })
    minetest.register_craft({
        type = "shapeless",
        output = d.walls.one_circle_halfs,
        recipe = {d.walls.one_circle}
    })
    minetest.register_craft({
        type = "shapeless",
        output = d.walls.one_circle,
        recipe = {d.walls.one_circle_halfs}
    })

end -- Gametype check