-- CONTENTS
-- Init for dependencies and lua files
-- Chat Commands
-- minor bug fix functions

local S, NS = core.get_translator("drwho_tardis")


drwho_tardis = { -- Global definition for the API functions and metadata
	VERSION = "1.3.0"
}
_drwho_tardis = { -- Private API + storage
	data = core.get_mod_storage(),
}

--
-- INIT FOR DEPENDENCIES AND LUA FILES
--

local MP = core.get_modpath("drwho_tardis")

dofile(MP .. "/init_data.lua") -- Initiate data such as interior rooms and crafting aliases
dofile(MP .. "/api.lua") -- The majority of API functions
dofile(MP .. "/tardis/console.lua") -- Formspecs + crafting. forms use local funtions so all in one file.
dofile(MP .. "/tardis/exterior_api.lua") -- Exterior api for registering exteriors 
dofile(MP .. "/tardis/default_exteriors.lua") -- All the exteriors that come with this mod
dofile(MP .. "/tardis/interior.lua") -- TARDIS Interior logic and node definitions

dofile(MP .. "/tools.lua") -- Dalekanium Tools 
dofile(MP .. "/craftitems.lua") -- All Craftitems
dofile(MP .. "/recipes.lua") -- Most Recipes
dofile(MP .. "/sonic.lua") -- Sonic Registration API and default sonic devices
dofile(MP .. "/armor.lua") -- Dalekanium Armor (if 3d_armor is enabled)
dofile(MP .. "/awards.lua") -- Various achievements (if awards is enabled)

-- Doctor Who Monsters (can be disabled in settings)
if core.settings:get_bool("drwho_tardis.enable_daleks") == false then
	return
else 
	dofile(MP .. "/mobs/dalek.lua") -- Daleks
	dofile(MP .. "/armgun.lua") -- Dalek Arm (uses dalek projectile, so daleks must be enabled)
end 

if core.settings:get_bool("drwho_tardis.enable_cybermen") == false then
	return
else dofile(MP .. "/mobs/cybermen.lua") end -- Cybermen

-- Migration logic (tardis_new to drwho_tardis), 
-- aliases for items and nodes, modstorage is not migrated
dofile(MP .. "/migration.lua")


-- Subtitles for sound effects
if core.get_modpath("subtitles") then
	subtitles.register_description('Dalek_Voice', S('"You will obey the Daleks!"')) -- Too long to fit the screen
	subtitles.register_description('Shortened_Dalek_Voice', S('"You will be exterminated!"'))
	subtitles.register_description('Laser', S('Laser blast'))
	subtitles.register_description('sonic_sound', S('Sonic Screwdriver buzzing'))
	subtitles.register_description('tardis_sound', S('Tardis travelling sound'))
end

--Data (11) : in_pos, out_pos, y_dest, x_dest, z_dest, factor, look, r_pos, waypoint1, waypoint2, waypoint3, biome_pos, type, door_0_offset
-- This is going to be reworked in v1.3.0
local data = core.get_mod_storage()

--
-- CHAT COMMANDS
--

-- Print the detected gametype, for devs
core.register_chatcommand("tardis_gametype", {
	params = "",
	description = S("Prints the type of game (mtg, mcl, rp)"),
	privs = {debug = true},
	func = function(name)
		core.chat_send_player(name, "Game type is: ".._drwho_tardis.GAMETYPE)
	end
})

-- TEMPORARY - for devs
core.register_chatcommand("ext_list", {
	params = "",
	description = S("DEV COMMAND: temporary"),
	privs = {debug = true},
	func = function(name)
		local ext_list = drwho_tardis.get:exterior_list()
		for i, ext in ipairs(ext_list) do
			core.chat_send_player(name, core.serialize(ext))
			core.chat_send_player(name, core.serialize(ext.itemstring))
			if i >= 20 then
				break
			end
		end
	end
})

-- Fix interior doors
core.register_chatcommand("reset_door", {
	params = "",
	description = S("Resets your Tardis interior console door and fixes it's timer"),
	privs = {},
	func = function(name)
		local user = _drwho_tardis.get_user(name)
		local exit_door_pos = user.console_room.exit_door_pos
		if not exit_door_pos or exit_door_pos == "" or exit_door_pos == {} then 
			exit_door_pos = user.in_pos
			user.console_room.exit_door_pos = exit_door_pos
		end
		_drwho_tardis.save_user(name, user) -- save user data
		_drwho_tardis:init_interior_door(name, exit_door_pos)
		core.chat_send_player(name, S("Interior door is now reset"))
	end
})


core.register_chatcommand("tardis_int", {
	params = "<type>",
	description = S("Change your Tardis interior type. Afterwards, remove everything from your Tardis and run /rebuild_tardis."),
	privs = {},
	func = function(name, param)
		local Params = string.split(param, ' ')
		local user = _drwho_tardis.get_user(name)
		if Params[1] == nil or Params[1] == '' then
			core.chat_send_player(name, "You must input the interior type after the command!")
		else
			user.console_room.type = Params[1]
			_drwho_tardis.save_user(name, user) -- save user data
			core.chat_send_player(name, "Set interior type to "..Params[1])
			core.chat_send_player(name, "Now, remove everything from your Tardis and run /rebuild_tardis. Make sure to be outside it though!")
		end
	end
})

-- Toggle 'respect_mavity'
core.register_chatcommand("tardis_mavity", {
	params = "",
	description = S("Toggles your Tardis's system for landing on ground instead of in the air or underground"),
	privs = {},
	func = function(name)
		local success, status = _drwho_tardis.toggle_mavity(name)
		core.chat_send_player(name, S(status))
	end
})

-- Summon TARDIS command 
core.register_chatcommand("summon_tardis", {
	params = "",
	description = S("Summons your Tardis to your location"),
	privs = {bring = true},
	func = function(name)
	local user = _drwho_tardis.get_user(name)
	if user.has_a_tardis == false then return false, S("You don't have a Tardis") else
	if user.in_pos == "" then return false, S("Tardis not found") else
		local r_pos = user.r_pos
		local player = core.get_player_by_name(name)
		local select_pos = player:get_pos()
		if not r_pos then
			core.chat_send_player(name, S("You do not have a Tardis!")) 
		elseif r_pos == nil or r_pos == "" then
			core.chat_send_player(name, S("You need a Time Rotor inside your Tardis before summoning it!")) 
		elseif r_pos.x+50 > select_pos.x and r_pos.x-50 < select_pos.x and r_pos.z+50 > select_pos.z and r_pos.z-50 < select_pos.z and r_pos.y+50 > select_pos.y and r_pos.y-50 < select_pos.y then 
			core.chat_send_player(name, "Your Tardis can not be summoned here!") 
		else
			if user.power < 3 then core.chat_send_player(name, "Not Enough Power In Tardis!") else
				local out_pos = user.out_pos
				core.set_node(out_pos, {name = "air"})
				out_pos.x = math.ceil(select_pos.x)
				out_pos.y = math.ceil(select_pos.y)
				out_pos.z = math.ceil(select_pos.z)					
				core.set_node(out_pos, {name=user.exterior_skin})
				local ometa = core.get_meta(out_pos)
				ometa:set_string("id", name)
				user.out_pos = out_pos
				user.power = user.power - 3
				local timer = core.get_node_timer(out_pos)
				timer:start(0.5)
				core.chat_send_player(name, S("Tardis Summoned"))
			end
		end
		_drwho_tardis.save_user(name, user) -- save user data
		--Unlock award:
		if core.get_modpath("awards") and _drwho_tardis.GAMETYPE=="mtg" then
			awards.unlock(name, "drwho_tardis:command_summon_tardis")
		end		
	end
	end
	end
})

-- Rebuild TARDIS command
core.register_chatcommand("rebuild_tardis", {
	params = "",
	description = S("Rebuilds your Tardis interior. Do this when OUTSIDE of it. This will REMOVE anything else inside it!"),
	privs = {},
	func = function(name)
		-- This uses a private API function
		local success, errmsg, exit_door_pos = _drwho_tardis:rebuild_tardis_interior(name)
		local _, __, pos = drwho_tardis.get:tardis_ext_position(name) -- public function
		local user = _drwho_tardis.get_user(name) -- get user data
		local in_pos = table.copy(user.in_pos)
		user.console_room.exit_door_pos = exit_door_pos
		_drwho_tardis.save_user(name, user) -- save user data

		if success then 
			core.chat_send_player(name, S("Tardis interior rebuilt!"))
			core.chat_send_player(name, S("type: @1", user.console_room.type))
			core.chat_send_player(name, S("owner: @1", name))
			core.chat_send_player(name, S("exterior location: @1", drwho_tardis.serialize_pos(pos)))
			core.chat_send_player(name, S("interior exit door location: @1", drwho_tardis.serialize_pos(in_pos)))
		else core.chat_send_player(name, S("Error message: @1", errmsg)) end
	end
})

-- Locate tardis command
-- This uses the public API function
-- Need to add a message if a player doesn't exist
core.register_chatcommand("locate_tardis", {
	params = "[<name>]",
	description = S("Locate your Tardis's exterior. Admins (server priv) can locate other player's Tardises."),
	privs = {}, 
	func = function(name, param)
		local Params = string.split(param, ' ')
		if Params[1] == nil or Params[1] == '' then
			local success, _, pos = drwho_tardis.get:tardis_ext_position(name)
			if success then
				core.chat_send_player(name, S("Your Tardis is at: @1", drwho_tardis.serialize_pos(pos)))	
			else core.chat_send_player(name, S("You do not have a Tardis!")) end
		else -- Params[1] is another players name
			if core.check_player_privs(name, {server = true}) or core.check_player_privs(name, {debug = true}) then
				local success, _, pos = drwho_tardis.get:tardis_ext_position(Params[1])
				if success then
					core.chat_send_player(name, S("@1's Tardis is at: @2", drwho_tardis.serialize_pos(pos)))	
				else 
					core.chat_send_player(name, S("@1 does not have a Tardis!", Params[1])) 
				end
			else
				core.chat_send_player(name, S("You need admin privileges to locate other people's Tardises!"))
			end
		end
	end
})

core.register_on_player_receive_fields(function(player, formname, fields)
	if fields.teleport then
		local pos = core.string_to_pos(fields.teleport_x..","..fields.teleport_y..","..fields.teleport_z)
		player:set_pos(pos)
		player:set_hp(2)
	end
	if fields.sonic_send then
		local meta = player:get_meta()
		local pos = core.deserialize(meta:get_string("sonic_digiline"))
		digilines.receptor_send(pos, digilines.rules.default, fields.sonic_channel, fields.sonic_message)
	end
end)

--fix death stuff with vortex (removed, so probably doesn't matter anymore?)
core.register_on_dieplayer(function(player)
	local pmeta = player:get_meta()
	local id = pmeta:get_string("id")
	local user = _drwho_tardis.get_user(id) -- get user data
	pmeta:set_string("vortex", "no")
	_drwho_tardis.switch_time_rotor(id, "off", false)
end)

--fix timers
core.register_lbm({
	label = "Fix Tardis timers",
	name = "drwho_tardis:fix_timers",
	nodenames = {"group:tardis_in_door", "group:tardis_in_door_locked"},
	action = function(pos, node)
		local timer = core.get_node_timer(pos)
		timer:start(0.2)
	end
})
---[[
-- replace doors and place doors in recently placed schematics
core.register_lbm({
	label = "Replace old interior doors from drwho_tardis v1.2.0",
	name = "drwho_tardis:replace_old_doors",
	nodenames = {"drwho_tardis:in_door_b"},
	run_at_every_load = true,
	action = function(pos, node)
		if _drwho_tardis.GAMETYPE == "mtg" then
			core.swap_node(pos, {name='drwho_tardis:door_b_a', param1=15, param2=node.param2})

		elseif _drwho_tardis.GAMETYPE == "mcl" then
			core.swap_node(pos, {name='drwho_tardis:door_b_b_1', param1=11, param2=node.param2})
			local pos2 = vector.new(pos.x, pos.y+1, pos.z)
			core.set_node(pos2, {name='drwho_tardis:door_b_t_1', param1=11, param2=node.param2})

		elseif _drwho_tardis.GAMETYPE == "rp" then
			core.swap_node(pos, {name='drwho_tardis:door_b_b_1', param1=14, param2=node.param2})
			door.init_segment(pos, false)
			local pos2 = vector.new(pos.x, pos.y+1, pos.z)
			core.set_node(pos2, {name='drwho_tardis:door_b_t_1', param1=14, param2=node.param2})
			door.init_segment(pos2, false)
		end
	end
})
--]]
--aliases
core.register_alias("drwho_tardis:dalek_ingot", "drwho_tardis:dalekanium_ingot")
core.register_alias("drwho_tardis:tardis_blue", "drwho_tardis:tardis")
core.register_alias("drwho_tardis:tardis_blue_locked", "drwho_tardis:tardis_locked")
core.register_alias("drwho_tardis:tardis_empty", "drwho_tardis:tardis_invisible")
core.register_alias("drwho_tardis:tardis_leave", "drwho_tardis:tardis_leaves")
core.register_alias("drwho_tardis:tardis_cool", "drwho_tardis:tardis_classic")
core.register_alias("drwho_tardis:in_door_a", "drwho_tardis:in_door")