-- CONTENTS
-- Dalek Arm Gun weapon

if core.get_modpath("mobs") then

-- speed of bullets
ARMGUN_VELOCITY = 20
-- minimum time between firing gun
ARMGUN_INTERVAL = 2

core.register_tool("drwho_tardis:armgun",{
    description = "Dalek Arm",
    groups = {},
    inventory_image = "drwho_tardis_armgun.png",
    wield_image = "drwho_tardis_armgun.png^[transformR90",
    sound = {
        punch_use = "Laser",
        punch_use_air = "Laser",
    },
    on_use = function(itemstack, user, pointed_thing)
        local item_meta = itemstack:get_meta()

        if item_meta:get_int("min_fire_time") > os.clock() then
            return itemstack
        end

        local pos = user:get_pos()
        local dir = user:get_look_dir()
        local vel = vector.multiply(dir, ARMGUN_VELOCITY)

        pos.y = pos.y+1.5
        pos = vector.add(pos, dir)

        local projectile = minetest.add_entity(pos, "drwho_tardis:glaser")
        projectile:set_velocity(vel)

        itemstack:add_wear(250)
        item_meta:set_int("min_fire_time", os.clock()+ARMGUN_INTERVAL)
        return itemstack
    end,
})

-- reset min_fire_time when player joins
-- it appears this isn't necessary, but I'll keep it just in case bugs show up
--[[
core.register_on_joinplayer(function(player, last_login)
    for item in ipairs(player:get_inventory():get_list("main")) do
        if item == "drwho_tardis:armgun" then
            item:get_meta():set_int("min_fire_time", 0)
        end
    end
end)
]]--

end -- if `mobs` is enabled