# DrWho_Tardis API

This mod has a couple API functions to make life easier for developers of it, and also support other mods adding their own things to it.

Please note: 

- The functions use a colon `:`, not a dot `.` after `drwho_tardis`

- We will refer to the player piloting the TARDIS as the pilot. 

- These API may change in future updates, **especially v1.3.0**. After that update, most API should be stable.

## `drwho_tardis:register_tardis_exterior(def)`

Makes it very simple to add another TARDIS exterior, which is also added to the exterior console unit.

### Parameters

- `def`: A table with all possible parameters in it:
  
  **Required:**
  
  - `name`: The short name for the exterior. It will be inserted into the itemstring as so: `drwho_tardis:tardis_<name>` and `drwho_tardis:tardis_<name>_locked`.
  
  - `texture`: The texture used for the TARDIS. Defaults to using the "mesh" format, just use one of the existing textures as a base. If you want to use "nodebox" to draw a node's texture on it, set that in `drawtype`.
  
  **Optional:**
  
  - `light`: (default: 10): Allows you to make the exterior glow less, more, or not at  all (0). Make sure it is a value between 0 and 14.
  
  - `description`: (default: "Tardis"): The player-facing title of the actual item. Not recommended to be changed.
  
  - `title`: (default: `name`^): The title of the exterior when listed on the exterior console unit. Defaults to `name`, but that is usually all lowercase so it is a good idea to set this with a capitalised word.
  
  - `drawtype`: (default: "mesh"): As mentioned above, this allows the modder to set the drawtype to "nodebox". Then you can pass a single node texture to `texture` which will be put all over the TARDIS. This is used in the default Stone, Leaves and Invisible textures.
  
  - `groups`: must have `tardis = 1` and should also have `not_in_creative_inventory = 1` as well. The only Tardis that is in creative inventory is the default one.

### Additional notes

- Does not return anything. 
- Ensure that the `name` is unique, otherwise it will override the previous one with that name and break some things.

##### Example usage

```lua
-- Exterior with mesh texture
drwho_tardis:register_tardis_exterior({
	name = "green",
	texture = "tardis_green.png",
	title = "Green",
	author = "Skivling"
})

-- Exterior using existing textures (Nodebox drawtype)
drwho_tardis:register_tardis_exterior({
	name = "stone",
	texture = "default_stone.png",
	drawtype = "nodebox",
	light = 0,
	title = "Stone",
	author = "PiDemon"
})
```

##  `drwho_tardis:register_in_door_style(def)`

Allows you to create custom styles to be used as Tardis interior exit doors.

### Parameters

- `def` (table):
  - `texture`: The texture for the door.
  - `description`: The player-facing name
  - `itemstring`: The itemstring of the door

##### Example usage

```lua
drwho_tardis:register_in_door_style({
	texture = "drwho_tardis_inside_door_b.png",
	description = "Tardis Interior Exit Door (style B)",
	itemstring = "drwho_tardis:in_door_b"
})
```

## `drwho_tardis:register_sonic_device(def)`

Registers a sonic device, whether that be a screwdriver or lipstick (Sarah Jane's, planned). Any item that has the functionality of a sonic.

### Parameters

- `def` is a table with all the parameters in it:

**Required:**

- `gentype`: Tell the function if you are setting your own texture (`custom`), choosing from the 1/3 textures (`choose`), or making it random (`random`). 
  
  - If you do the arithmetic for randomising the numbers before giving the values to the function, set it to `choose`.

- `sonictype`: Either "screwdriver" or a custom one, such as "lipstick". It will default to "screwdriver" but should be specified.

- `no_creative`: If `true`, the new sonic device will *not* appear in the creative inventory. If `false`, it will appear in the creative inventory. 
  
  - This can be useful for player-only sonics, or if you are registering lots that don't need to flood the inventory.

**Optional:**

- `texture`: If the modder wants to use a custom texture that does not use the sonic screwdriver section textures. If so, a `customname` and `customdescription` must be given.

- `top`: The number for what texture to be used in the top third of a sonic, defaults to random.

- `mid`: The number for what texture to be used in the middle third of a sonic, defaults to random.

- `bottom`: The number for what texture to be used in the bottom third of a sonic, defaults to random.

- `customname`: This is the itemstring. It defaults to `"drwho_tardis:sonic_"..sonictype.."_"..top.."_"..mid.."_"..bottom`, so if you want it to be part of your mod's modname space, you must use this value, as well as appending the modname with `:` to tell the engine to not care that the modname isn't `drwho_tardis` even though it appears to be registered from that because of the function. 
  
  - For example, `:extra_sonics:sonic_playing_cards_3` if, for some reason you wanted a pack of cards to have sonic ability.  Actually, that doesn't sound like a bad idea...

- `tool_capabilities`: A table, allowing you to customize the capabilities of that particular sonic. `full_punch_interval`, `groupcaps.sonic` allows you to change the `uses` and `maxlevel` of it, the higher they are the more durability the sonic has.

- `sounds`: Must be a table where the value `sonic_use` is a custom sound file to play when the sonic is used, and includes the `max_hear_distance`.

##### Return value

Returns the full `item_name`.

- It may include the extra `:` if you put your own modname in the `customname`, if so you can remove it with `item_name = item_name:match"^.-:(.+)"`.

##### Additional notes

* A different API may be added in the future that allows custom sonic functions to be added as long as they don't break the default ones.

- The names of each variable in `def` will most likely change in version `1.3.0` when APIs are cleaned up. 
  
##### Example usage:

```lua
-- Register sonic playing cards as part of the mod 'extra_sonics'
drwho_tardis:register_sonic_device({
    gentype = "custom", -- We are specifying the texture
    texture = "extra_sonics_playing_cards.png",
    sonictype = "playing_cards",
    no_creative = false, -- We want it to appear in the creative inventory
    customname = ":extra_sonics:sonic_playing_cards", -- itemstring
    customdescription = "Sonic Playing Cards", -- player-facing name
})
```



## `drwho_tardis.get:tardis_ext_position(player)`

Returns the exterior position of a certain player's Tardis. 

### Return value

Returns `success`, `errmsg`, `pos`

- `success` is a boolean value if it worked or not

- `errmsg` is a string which has an error message if `success` is false.

- `pos` is the position of the Tardis.

## `drwho_tardis.get:interior_type(player)`

Returns the interior type of a player's Tardis, but returns `"old"` even if they don't have a Tardis.

### Return value

Returns `type`:

- `type` is a string which corresponds to the interior type they have. All Tardises made before v1.2.0 are of type `"old"`, the newer interiors have not been made yet but will have other type values.

## `drwho_tardis.get:interior_depth(player)`

Returns the default interior depth that is used in new Tardises. It is an integer, probably `-10000` or `-50` depending on the gametype.
