-- CONTENTS
-- Node registrations for:
-- TARDIS in_door
-- locked in_door
-- standard doors (using game APIs)
--		  several wall nodes
--		  turquiose node
--        special stone
--		  Gallifreyan Chest

local S, NS = core.get_translator("drwho_tardis")
local data = core.get_mod_storage()

--data = core.get_mod_storage()


-- 	def needs:
-- 		itemstring
-- 		texture
--		description
-- this function can be used if one wants to add an interior exit door with a different texture than the default.
function drwho_tardis:register_in_door_style(def)

	-- In the node metadata:
	-- 'type' = 'exit': to confirm it's a door for exiting a Tardis
	-- 'id': the username of the owner of that Tardis
	core.register_node(def.itemstring, {
		description = S(def.description),
		tiles = {def.texture},
		drawtype = "mesh",
		use_texture_alpha = "clip",
		mesh = "tardis.obj",
		paramtype2 = "4dir",
		selection_box = {
			type = "fixed",
			fixed = {
				{ -0.5, -0.5, -0.5, 0.5, 1.5, 0.5 },
			},
		},
		collision_box = {
		type = "fixed",
		fixed = {
			{ 0.48, -0.5,-0.5,  0.5,  1.5, 0.5},
			{-0.5 , -0.5, 0.48, 0.48, 1.5, 0.5},
			{-0.5,  -0.5,-0.5 ,-0.48, 1.5, 0.5},
			{-0.7,  -0.6,-0.7,  0.7, -0.48,0.7},
		}
		},
		sunlight_propagates = true,
		is_ground_content = false,
		groups = {cracky=2, tardis_in_door=1},
		diggable = true,
		on_timer = function(pos)
		local meta = core.get_meta(pos)
		local type = meta:get_string("type") or "exit"
		local objs = core.get_objects_inside_radius(pos, 0.9)
		if type == "exit" or type == nil or type == "" then
			if type == nil then meta:set_string("type", "exit") end -- Backwards compatability
			if objs[1] == nil then return true else
				if objs[1]:is_player() then

					local pmeta = objs[1]:get_meta()
					local meta = core.get_meta(pos)
					local id = meta:get_string("id")
					local user = _drwho_tardis.get_user(id)
					local go_pos = user.out_pos

					go_pos.z = go_pos.z-1
					objs[1]:set_pos(go_pos)
					objs[1]:set_look_horizontal( math.rad( 180 ))
					objs[1]:set_look_vertical( math.rad( 0 ))

					_drwho_tardis.log('player '..id..' exited a Tardis at '..drwho_tardis.serialize_pos(go_pos))
					
					if pmeta:get_string("vortex") == "yes" then 
						go_pos.z = go_pos.z-1
						objs[1]:set_pos(go_pos)
						objs[1]:set_hp(0) 
					end
		
					core.after(1, function()
						local meta = core.get_meta(pos)
						local id = meta:get_string("id")
						local user = _drwho_tardis.get_user(id)
						local go_pos = user.out_pos
						core.set_node(go_pos, {name=user.exterior_skin})
						local ometa = core.get_meta(go_pos)
						ometa:set_string("id", id)
						local timer = core.get_node_timer(go_pos)
						timer:start(0.2)
					end)
				else
					local meta = core.get_meta(pos)
					local id = meta:get_string("id")
					local user = _drwho_tardis.get_user(id)
					local go_pos = user.out_pos
					go_pos.z = go_pos.z-2
					objs[1]:set_pos(go_pos)
				end
			end
			return true
		else -- it is door_1 or door_2 from the previous update. Notify users about changes
			
			if objs[1] == nil then return true else
				if objs[1]:is_player() then
				
					local pmeta = objs[1]:get_meta()
					local meta = core.get_meta(pos)
					local id = meta:get_string("id")
					local name = objs[1]:get_player_name()

					core.after(1, function()
						core.chat_send_player(name, S("Sorry! The idea for multiple doors and rooms was scrapped in favour of a large interior area which is all one room and can have corridors and room built in it. Feel free to break these doors and build your own rooms behind where they were."))
					end)
				else
					
				end
			end
			return true

		end
		end
	})

	core.register_node(def.itemstring.."_locked", {
		description = S("Locked @1", def.description),
		tiles = {def.texture},
		drawtype = "mesh",
		use_texture_alpha = "clip",
		mesh = "tardis.obj",
		selection_box = {
			type = "fixed",
			fixed = {
				{ -0.5, -0.5, -0.5, 0.5, 1.5, 0.5 },
			},
		},
		collision_box = {
		type = "fixed",
		fixed = {
			{ -0.5, -0.5, -0.5, 0.5, 1.5, 0.5 },
		},
		},
		sunlight_propagates = true,
		groups = {not_in_creative_inventory = 1, tardis_in_door_locked = 1},
		diggable = false,
		on_blast = function() end,
	})
end


drwho_tardis:register_in_door_style({
	texture = "drwho_tardis_inside_door.png",
	description = "Tardis Interior Exit Door",
	itemstring = "drwho_tardis:in_door",
})
-- Recipes for this is in recipes.lua

-- Trigger translation for automated scripts
local qwerty = S("Tardis Interior Exit Door")

-- 'standard' doors (using game-specific APIs)
if _drwho_tardis.GAMETYPE == "mcl" then

mcl_doors:register_door("drwho_tardis:door_b", {
	description = S("Tardis Interior Door (style B)"),
	inventory_image = "drwho_tardis_door_8_item.png",
	groups = {pickaxey=1},
	_mcl_hardness = 5,
	_mcl_blast_resistance = 5,
	tiles_bottom = "drwho_tardis_door_8_lower.png",
	tiles_top = "drwho_tardis_door_8_upper.png",
	sounds = mcl_sounds.node_sound_metal_defaults(),
	sound_open = "doors_steel_door_open",
	sound_close = "doors_steel_door_close",
})

elseif _drwho_tardis.GAMETYPE == "mtg" then

doors.register("drwho_tardis:door_b", {
	tiles = {{name = "drwho_tardis_door_8_mtg.png", backface_culling = true}},
	description = S("Tardis Interior Door (style B)"),
	inventory_image = "drwho_tardis_door_8_item.png",
	groups = {node = 1, cracky = 1, level = 2},
	sounds = default.node_sound_metal_defaults(),
	sound_open = "doors_steel_door_open",
	sound_close = "doors_steel_door_close",
	gain_open = 0.2,
	gain_close = 0.2,
})

elseif _drwho_tardis.GAMETYPE == "rp" then

door.register_door("drwho_tardis:door_b", {
	description = S("Tardis Interior Door (style B)"),
	inventory_image = "drwho_tardis_door_8_item.png",
	groups = {cracky=3,oddly_breakable_by_hand=1,level=-2,door=1},
	tiles_bottom = {"drwho_tardis_door_8_lower_rp.png", "drwho_tardis_door_8_side_a_rp.png", "drwho_tardis_door_8_top_rp.png"},
	tiles_top = {"drwho_tardis_door_8_upper.png", "drwho_tardis_door_8_side_b_rp.png", "drwho_tardis_door_8_top_rp.png"},
	sounds = rp_sounds.node_sound_stone_defaults(),
	sound_open = "door_open_stone",
	sound_close = "door_close_stone",
	sunlight = false,
	can_paint = false,
})

end

core.register_node("drwho_tardis:wall", {
	description = S("Tardis Wall (non-craftable)"),
	tiles = {"tardis_wall.png"},
	diggable = false,
	groups = { not_in_creative_inventory = 1},
	light_source = 2,
	is_ground_content = false,
	on_blast = function() end,
})
core.register_node("drwho_tardis:wall_craftable", {
	description = S("Tardis Wall"),
	tiles = {"tardis_wall.png"},
	groups = {cracky = 1},
	light_source = 2,
	is_ground_content = false,
})
core.register_node("drwho_tardis:wall_circles_16x16", { -- with 8x8 circles in 45* rotated square formation
	description = S("Tardis Wall - Circles (16x16)"),
	tiles = {"drwho_tardis_wall_circles_16x16.png"},
	groups = {cracky = 1},
	light_source = 8,
	is_ground_content = false,
})
core.register_node("drwho_tardis:wall_one_circle", {
	description = S("Tardis Wall - Large Circle"),
	tiles = {"drwho_tardis_wall_one_circle.png"},
	groups = {cracky = 1},
	light_source = 8,
	is_ground_content = false,
})
core.register_node("drwho_tardis:wall_one_circle_halfs", {
	description = S("Tardis Wall - Large Circle Halfs"),
	tiles = {"drwho_tardis_wall_one_circle_halfs.png"},
	groups = {cracky = 1},
	light_source = 8,
	is_ground_content = false,
})
local front = "drwho_tardis_wall_circles_32x32.png"
local top = "drwho_tardis_wall_circles_32x32_top.png"
core.register_node("drwho_tardis:wall_circles_32x32", { -- with 12x12 circles in hexagonal formation
	description = S("Tardis Wall - Circles (32x32)"),
	tiles = {top, top, front, front, front, front},
	groups = {cracky = 1},
	light_source = 8,
	is_ground_content = false,
})

core.register_node("drwho_tardis:grey_block", {
	description = S("Light Grey Block"),
	tiles = {"drwho_tardis_grey_block.png"},
	groups = {cracky = 1},
	is_ground_content = false,
})
core.register_node("drwho_tardis:grey_block_slab", {
	description = S("Light Grey Block Slab"),
	tiles = {"drwho_tardis_grey_block.png"},
	groups = {cracky = 1},
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = {-0.5, -0.5, -0.5, 0.5, 0, 0.5},
	},
	is_ground_content = false,
})
core.register_node("drwho_tardis:grey_block_h", {
	description = S("Light Grey Block"),
	tiles = {"drwho_tardis_grey_block.png"},
	groups = {cracky = 1},
	drops = {"drwho_tardis:grey_block"},
	selection_box = {
		type = "fixed",
		fixed = {
			{ -0.5, -0.5, -0.5, 0.5, 0.5, 0.5 },
		},
	},
	collision_box = {
		type = "fixed",
		fixed = {
			{ 0, 0, 0, 0, 0, 0 },
		},
	},
	sunlight_propagates = false,
	is_ground_content = false,
})
---[[ -- used in schematics as a place-in for doors. Must be enabled for LBM to work.
core.register_node("drwho_tardis:in_door_b", {
	description = S("schem temporary door"),
	tiles = {"tardis_side_4.png"},
	groups = { cracky = 1, not_in_creative_inventory = 1 },
	paramtype2 = "4dir",
	selection_box = {
		type = "fixed",
		fixed = {
			{ -0.5, -0.5, -0.5, 0.5, 1.5, 0.5 },
		},
	},
	collision_box = {
		type = "fixed",
		fixed = {
			{ 0, 0, 0, 0, 0, 0 },
		},
	},
	sunlight_propagates = false,
	is_ground_content = false,
})
--]]
core.register_node("drwho_tardis:turquiose_block", {
	description = S("Turquiose Block"),
	tiles = {"tardis_side_4.png"},
	groups = {cracky = 1},
	is_ground_content = false,
})
core.register_node("drwho_tardis:turquiose_block_h", {
	description = S("Turquiose Block"),
	tiles = {"tardis_side_4.png"},
	groups = {cracky = 1},
	drops = {"drwho_tardis:turquiose_block"},
	selection_box = {
		type = "fixed",
		fixed = {
			{ -0.5, -0.5, -0.5, 0.5, 0.5, 0.5 },
		},
	},
	collision_box = {
		type = "fixed",
		fixed = {
			{ 0, 0, 0, 0, 0, 0 },
		},
	},
	sunlight_propagates = false,
	is_ground_content = false,
})

core.register_node("drwho_tardis:stone", {
	description = S("Stone"),
	tiles = {"default_stone.png"},
	diggable = false,
	groups = { not_in_creative_inventory = 1},
	is_ground_content = false,
	on_blast = function() end,
})

-- gallifreyan chest
local function get_formspec_chest()
	return "size[24,15]"..
		"list[context;main;0,0.5;24,10;]"..
		"list[current_player;main;8,10.5;8,4;]"
end
core.register_node("drwho_tardis:chest", {
		description = S("Gallifreyan Chest"),
		tiles = {"tardis_chest_top.png", "tardis_chest_top.png", "tardis_chest_side.png", "tardis_chest_side.png", "tardis_chest_side.png", "tardis_chest_side.png"},
		groups = {cracky = 3},
		after_place_node = function(pos, placer, itemstack, pointed_thing)
			local meta = core.get_meta(pos)
			local inv = meta:get_inventory()
			meta:set_string("owner", placer:get_player_name())
			meta:set_string("infotext", S("Chest owned by @1", placer:get_player_name()))
			meta:set_string("formspec", get_formspec_chest())
			inv:set_size("main", 24*10) -- VERY large
		end,
		on_rightclick = function(pos, node, clicker, itemstack) 
			local meta = core.get_meta(pos)
			if clicker:get_player_name() == meta:get_string("owner") then meta:set_string("formspec", get_formspec_chest(pos)) else meta:set_string("formspec", "") end
		end -- gallifreyan chest
})