-- CONTENTS
-- Digilines formspec
-- generate_sonic_screwdriver()
-- Generic Sonic Screwdriver

local S = core.get_translator("drwho_tardis")
local i = _drwho_tardis.items

-- minimum time (seconds) between using sonic
drwho_tardis.SONIC_INTERVAL = 2

local function get_formspec_digilines()
    return "size[10,10]"..
		"field[1,1;8,1;sonic_message;Message;]"..
		"field[1,3;8,1;sonic_channel;Channel;]"..
		"button_exit[1,6;3,3;sonic_send;Send]"
end

local sonictypes = 4 --number of variants for end, middle, and top
-- register_all_random_sonic_screwdrivers(sonictypes) is run after it is defined


local function add_sonictypes_texture(item, top, mid, bottom)
    local sonicstack = ItemStack(item)
    sonicstack:get_meta():set_string("inventory_image", "empty.png^sonic_top_"..top..".png^sonic_mid_"..mid..".png^sonic_end_"..bottom..".png")
end    



-- See API.md for more details
function drwho_tardis:register_sonic_device(def)
    --def = {gentype, texture, top, mid, bottom, sonictype, customname, customdescription, no_creative}
    

    -- create random values 
    -- If they are specified in def.top etc these values are overridden
    local top = def.top or math.random(1,sonictypes)
    local mid = def.mid or math.random(1,sonictypes)
    local bottom = def.bottom or math.random(1,sonictypes)

    -- Only run if given values are defined
    -- Makes sure that def.top is not above sonictypes as that would result in error
    if top > sonictypes then top = 1 end
    if mid > sonictypes then mid = 1 end
    if bottom > sonictypes then bottom = 1 end
    core.chat_send_all(sonictypes.." top: "..top.." mid: "..mid.." bottom: "..bottom)


    if def.sonictype == nil then def.sonictype = "screwdriver" end -- Default to "screwdriver"
    
    local item_name = ""
    if def.customname ~= nil then 
        item_name = def.customname
    else
        item_name = ":drwho_tardis:sonic_"..def.sonictype.."_"..top.."_"..mid.."_"..bottom
    end
    core.chat_send_all(".")
    -- if playername is not given, custom description must be given. 
    --local item_description = def.customdescription or def.playername.."\'s Sonic Screwdriver"
    local item_description = def.customdescription or S("Sonic Screwdriver (@1-@2-@3)", top, mid, bottom) -- (4-2-3)

    local inventoryimage = ""
    if def.gentype == "custom" then
        inventoryimage = def.texture
    else -- Stacked image using top, mid and bottom.
        inventoryimage = "empty.png^sonic_top_"..top..".png^sonic_mid_"..mid..".png^sonic_end_"..bottom..".png"
    end
    
    
    -- Add to appropriate item groups
    def.groups = def.groups or {}
    def.groups.sonic = 1
    def.groups.sonic_screwdriver = def.sonictype == "screwdriver" and 1 or nil -- is sonic a screwdriver? otherwise do not add
    def.groups.not_in_creative_inventory = def.no_creative == true and 1 or nil

    -- set up tool capabilities
    local toolcaps = def.tool_capabilities or {}
    toolcaps.full_punch_interval = toolcaps.full_punch_interval or 0.5
    toolcaps.groupcaps = toolcaps.groupcaps or {}
    toolcaps.groupcaps.sonic = toolcaps.groupcaps.sonic or {}
    local sonicgc = toolcaps.groupcaps.sonic
    sonicgc.uses = sonicgc.uses or 1000 -- the higher, more durability
    sonicgc.maxlevel = sonicgc.maxlevel or 1 -- the higher, more durability

    -- sounds
    def.sounds = def.sounds or {}
    def.sounds.sonic_use = def.sounds.sonic_use or {name="sonic_sound",max_hear_distance = 10}
    

    core.register_tool(item_name, {
        description = item_description,
        inventory_image = inventoryimage,
        stack_max=1,
        groups = def.groups,
        tool_capabilities = toolcaps,
        _tt_help = def._tt_help or nil,
        
        --------------------- ACTUAL SONIC CODE BELOW -----------------------

        on_use = function(itemstack, player, pointed_thing)
        local pmeta = player:get_meta() -- TODO: unused variable
        local id = player:get_player_name()
        local user = _drwho_tardis.get_user(id) -- get user data
        local imeta = itemstack:get_meta()
        imeta:set_string("interact", "no")
        local select_pos = player:get_pos()
        local sonic_add_wear = true

        -- sound debounce & cooldown
        if imeta:get_int("min_fire_time") >= os.clock() + drwho_tardis.SONIC_INTERVAL + 5 then
            -- os.clock() is seconds since server started, and only cleared now, not on server restart.
            -- this avoids a bug where the min_fire_time is very high and the sonic device cannot be used. 
            imeta:set_int("min_fire_time", 1)
            _drwho_tardis.log("sonic: reset min_fire_time")
        end
        if imeta:get_int("min_fire_time") > os.clock() then
            sonic_add_wear = false
            _drwho_tardis.log("sonic: has a cooldown, no action taken")
            return itemstack
        end

        if pointed_thing.type == "node" then
            local controls = player:get_player_control()
            local node = core.get_node(pointed_thing.under)
            local meta = core.get_meta(pointed_thing.under)
            select_pos = pointed_thing.under
            local drop = core.get_node_drops(node, nil)
            if controls.sneak then
              -- sneaking
                if core.get_item_group(node.name, "tardis_in_door") == 1 then
                    if user.has_a_tardis == false then
                        core.chat_send_player(id, S("You do not have a Tardis!"))
                    else
                        _drwho_tardis:place_tardis_interior(id, "custom", select_pos) -- links select_pos to their Tardis
                        user = _drwho_tardis.get_user(id) -- get updated user data (otherwise it'll override above changes)
                        core.chat_send_player(id, S("Linked your Tardis to this interior door."))
                    end
                else -- summon Tardis
                    local r_pos = user.r_pos
                    if user.has_a_tardis == false then
                        core.chat_send_player(id, S("You do not have a Tardis!")) 
                    elseif r_pos == nil or r_pos == "" then
                        core.chat_send_player(id, S("You need a Time Rotor inside your Tardis before summoning it!")) 
                    elseif r_pos.x+50 > select_pos.x and r_pos.x-50 < select_pos.x and r_pos.z+50 > select_pos.z and r_pos.z-50 < select_pos.z and r_pos.y+50 > select_pos.y and r_pos.y-50 < select_pos.y then 
                        core.chat_send_player(id, "Your Tardis can not be summoned here!") 
                    else
                        if user.power < 3 then core.chat_send_player(id, "Not Enough Power In Tardis!") else
                            select_pos = pointed_thing.above
                            local out_pos = user.out_pos
                            core.set_node(out_pos, {name = "air"})
                            out_pos.x = select_pos.x
                            out_pos.y = select_pos.y
                            out_pos.z = select_pos.z
                                
                            out_pos.y = out_pos.y+1
                            core.set_node(out_pos, {name = "air"})
                            out_pos.y = out_pos.y-1
                            
                            core.set_node(out_pos, {name=user.exterior_skin})
                            local ometa = core.get_meta(out_pos)
                            ometa:set_string("id", id)
                            user.out_pos = out_pos
                            user.power = user.power - 3
                            local timer = core.get_node_timer(out_pos)
                            timer:start(0.5)
                            core.chat_send_player(id, S("Tardis Summoned"))
                            _drwho_tardis.unlock_award(id, "drwho_tardis:command_summon_tardis")
                        end
                    end
                end
            else
              -- not sneaking
                if id == meta:get_string("id") then
                    if core.get_item_group(node.name, "tardis") == 1 then
                        core.set_node(select_pos, {name = user.exterior_skin.."_locked"})
                        local ometa = core.get_meta(select_pos)
                        ometa:set_string("id", id)
                        core.chat_send_player(id, S("Tardis Locked"))
                    end
                    if core.get_item_group(node.name, "tardis_locked") == 1 then
                        core.set_node(select_pos, {name = user.exterior_skin})
                        local timer = core.get_node_timer(select_pos)
                        timer:start(0.2)
                        local ometa = core.get_meta(select_pos)
                        ometa:set_string("id", id)
                        core.chat_send_player(id, S("Tardis Unlocked"))
                    end
                elseif string.match(node.name,"doors:door_steel") then
                    doors.door_toggle(select_pos, nil, nil)
                elseif string.match(node.name,"doors:trapdoor_steel") then
                    doors.trapdoor_toggle(select_pos, nil, nil)
                elseif node.name == "default:glass" then
                    core.set_node(select_pos, {name = "default:obsidian_glass"})
                elseif node.name == "default:dirt" then
                    core.set_node(select_pos, {name = "default:dirt_with_grass"})
                elseif node.name == "default:sand" then
                    core.set_node(select_pos, {name = "default:silver_sand"})
                elseif node.name == "default:obsidian" then
                    core.set_node(select_pos, {name = "default:lava_source"} )
                elseif core.get_item_group(node.name, "mesecon_conductor_craftable") == 1 then
                    if mesecon.is_conductor_on(node) then
                        mesecon.turnoff(select_pos, {0, 0, 0})
                    else
                        mesecon.turnon(select_pos, {0, 0, 0})
                    end
                elseif drop[1] == "digilines:wire_std_00000000" then
                    local meta = player:get_meta()
                    meta:set_string("sonic_digiline", core.serialize(select_pos))
                    core.show_formspec(player:get_player_name(), "drwho_tardis:digilines_formspec", get_formspec_digilines() )
                else
                    sonic_add_wear = false -- don't reduce durability
                    --_drwho_tardis.log("sonic: did nothing, not reducing durability")
                    return -- we can't do anything with this node
                end
            end
        elseif pointed_thing.type == "object" then
            local controls = player:get_player_control()
            local obj = pointed_thing.ref
            if controls.sneak then 
                local vpos = obj:get_pos()
                select_pos = vpos
                local pos = player:get_pos()
                if obj:is_player() then 
                    obj:add_player_velocity({ x = 5*(vpos.x - pos.x), y = 5*(vpos.y - pos.y), z = 5*(vpos.z - pos.z)})
                else
                    obj:add_velocity({ x = 5*(vpos.x - pos.x), y = 5*(vpos.y - pos.y), z = 5*(vpos.z - pos.z)})
                end
            else 
                core.chat_send_player(id, S("Scanned subject had @1 hearts", obj:get_hp()/2))
            end
        else
            sonic_add_wear = false -- don't reduce durability
            --core.chat_send_player(id, "not reducing durability")
            return -- not pointing to anything important, return
        end
        local sonic_sound = table.copy(def.sounds.sonic_use)
        sonic_sound.pos = select_pos
        core.sound_play(sonic_sound.name, sonic_sound)
        imeta:set_int("min_fire_time", os.clock() + drwho_tardis.SONIC_INTERVAL)
        if sonic_add_wear == true then
            itemstack:add_wear(65535 / (sonicgc.uses * (3^(sonicgc.maxlevel-1) ) - 1 ))
            --_drwho_tardis.log("sonic: durability added")
        end
        _drwho_tardis.save_user(id, user) -- save user data if anything was changed, e.g. if Tardis is summoned out_pos is changed
        return itemstack
    end -- End Sonic Device on_use
    })-- end Sonic Device tool registration

    ----------------------------- Post Registration Code ----------------------------------
---[[
    if not def.gentype == "custom" then -- if == "choose", == "random", or not specified
        add_sonictypes_texture(item_name, top, mid, bottom) -- Add correct textures using ItemStack
        --_drwho_tardis.log("Sonic Screwdriver registered with textures @1-@2-@3 and itemstring @4", top, mid, bottom, item_name)
    end
--]]
    --core.register_alias(item_name:match"^.-:(.+)", item_name) -- These are unnessasary and just
    --core.register_alias(item_name, item_name:match"^.-:(.+)") -- fill up debug.txt with warnings

return item_name
end



-- Loop through and register every random texture screwdriver, based on sonictypes value.
-- Should run each time game starts so if in a recent update new textures have been added
-- and sonictypes is increased, all the new ones will be registered automatically.
-- It also overwrites every other one, but that doesn't affect anything as it's still the same itemstring.
-- I made this before I realised that the actual error was because I was using hyphens.
local function register_all_random_sonic_screwdrivers()
    -- NAMING SCHEME
    -- drwho_tardis: sonic _screwdriver _ top _ mid _ end
    -- e.g. "drwho_tardis:sonic_screwdriver_1_4_3"
    -- IMPORTANT: It cannot have any hyphens (-) in the itemstring^^! So I use underscores
    -- Sonic Screwdriver (top - mid - end)
    -- e.g. "Sonic Screwdriver (1-4-3)"

    -- We don't want (sonictypes)^3 diffferent Sonic Screwdrivers flooding the inventory!
    -- So these all have no_creative = true

    -- Each loop of topCount does every sonic with 1-n-n, then 2-n-n, until sonictypes is reached.
    -- There are 3 loops, and they each do it (sonictypes) times, therefore (sonictypes)^3 which is exactly how many we have
    for topCount = 1, sonictypes do
        for midCount = 1, sonictypes do
            for endCount = 1, sonictypes do
                drwho_tardis:register_sonic_device({
                    gentype = "choose", -- Choose the combination of parts
                    sonictype = "screwdriver", -- Specify it is a screwdriver
                    top = topCount, -- Choose top texture 
                    mid = midCount, -- Choose middle texture 
                    bottom = endCount, -- Choose bottom texture 
                    no_creative = true, -- DON'T show up in the creative inventory - see above comment
                })
            end
        end
    end 


end

register_all_random_sonic_screwdrivers()

-- Generic Sonic Screwdriver
drwho_tardis:register_sonic_device({
    gentype = "choose", -- Choose the combination of parts
    sonictype = "screwdriver", -- Specify it is a screwdriver
    top = 1, -- Choose top texture 
    mid = 1, -- Choose middle texture 
    bottom = 1, -- Choose bottom texture 
    customname = "drwho_tardis:sonic_screwdriver", -- Custom name
    customdescription = S("Sonic Screwdriver"), -- Custom player-facing item name 
    no_creative = false, -- The only screwdriver to show up in the creative inventory
})
drwho_tardis:register_sonic_device({
    gentype = "custom",
    texture = "sonic_lipstick.png",
    sonictype = "lipstick", -- Specify it is lipstick
    customname = "drwho_tardis:sonic_lipstick", -- Custom name
    customdescription = S("Sarah Jane's Sonic Lipstick"), -- Custom player-facing item name 
    _tt_help = S("A highly versatile piece of technology disguised as lipstick"),
    no_creative = false, 
})
if _drwho_tardis.GAMETYPE == "rp" then
    crafting.register_craft({
        output = "drwho_tardis:sonic_lipstick",
        items = {
            i.red,
            i.ingot_tin,
            i.ingot_gold.." 4",
            "group:sonic",
        }
    })
else
    core.register_craft({
        output = "drwho_tardis:sonic_lipstick",
        recipe = {
            {"", i.red, ""},
            {i.ingot_gold, i.ingot_tin, i.ingot_gold},
            {i.ingot_gold, "group:sonic", i.ingot_gold}
        }
    })
end