-- CONTENTS
-- Dalekanium Tools - definitions and crafting
-- Toolranks support
-- pick_axe_tweaks support
-- Gauntlet of Rassilon
-- Vortex Manipulator

local S = core.get_translator("drwho_tardis")
local i = _drwho_tardis.items

-- DALEKANIUM (dalek) TOOLS

-- Pickaxe
core.register_tool("drwho_tardis:pick_dalek", {
	description = S("Dalekanium Pickaxe"),
	inventory_image = "dalek_pick.png",
	tool_capabilities = {
		full_punch_interval = 0.5,
		max_drop_level=3,
		groupcaps={
			cracky = {times={[1]=1.0, [2]=0.5, [3]=0.25}, uses=60, maxlevel=3},
			azbantium = {times={[1]=25}, uses=30, maxlevel=3},
		},
		damage_groups = {fleshy=5},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = { pickaxe = 1, dalekanium = 1 }
})
if _drwho_tardis.GAMETYPE == "rp" then
	crafting.register_craft({
		output = "drwho_tardis:pick_dalek",
		items = {
			"drwho_tardis:dalekanium_ingot 3",
			"rp_default:fiber 4",
			i.stick.." 3",
		}
	})
else
core.register_craft({
    output = "drwho_tardis:pick_dalek",
    recipe = {
        {"drwho_tardis:dalekanium_ingot", "drwho_tardis:dalekanium_ingot", "drwho_tardis:dalekanium_ingot"},
        {"", i.stick, ""},
        {"", i.stick, ""}
    }
})
end

-- Shovel
core.register_tool("drwho_tardis:shovel_dalek", {
	description = S("Dalekanium Shovel"),
	inventory_image = "dalek_shovel.png",
	tool_capabilities = {
		full_punch_interval = 0.5,
		max_drop_level=1,
		groupcaps={
			crumbly = {times={[1]=0.9, [2]=0.25, [3]=0.15}, uses=60, maxlevel=3},
		},
		damage_groups = {fleshy=4},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = { shovel = 1, dalekanium = 1 }
})
if _drwho_tardis.GAMETYPE == "rp" then
	crafting.register_craft({
		output = "drwho_tardis:shovel_dalek",
		items = {
			"drwho_tardis:dalekanium_ingot 3",
			"rp_default:fiber 4",
			i.stick.." 3",
		}
	})
else
core.register_craft({
    output = "drwho_tardis:shovel_dalek",
    recipe = {
        {"drwho_tardis:dalekanium_ingot"},
        {i.stick},
        {i.stick}
    }
})
end

-- Axe
core.register_tool("drwho_tardis:axe_dalek", {
	description = S("Dalekanium Axe"),
	inventory_image = "dalek_axe.png",
	tool_capabilities = {
		full_punch_interval = 0.45,
		max_drop_level=1,
		groupcaps={
			choppy={times={[1]=2.10, [2]=0.90, [3]=0.50}, uses=30, maxlevel=3},
		},
		damage_groups = {fleshy=7},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = { axe = 1, dalekanium = 1 }
})
if _drwho_tardis.GAMETYPE == "rp" then
	crafting.register_craft({
		output = "drwho_tardis:axe_dalek",
		items = {
			"drwho_tardis:dalekanium_ingot 3",
			"rp_default:fiber 4",
			i.stick.." 3",
		}
	})
else
core.register_craft({
    output = "drwho_tardis:axe_dalek",
    recipe = {
        {"drwho_tardis:dalekanium_ingot", "drwho_tardis:dalekanium_ingot", ""},
        {"drwho_tardis:dalekanium_ingot", i.stick, ""},
        {"", i.stick, ""}
    }
})
end

-- Sword
core.register_tool("drwho_tardis:sword_dalek", {
	description = S("Dalekanium Sword"),
	inventory_image = "dalek_sword.png",
	tool_capabilities = {
		full_punch_interval = 0.5,
		max_drop_level=1,
		groupcaps={
			snappy={times={[1]=1, [2]=0.90, [3]=0.30}, uses=65, maxlevel=3},
		},
		damage_groups = {fleshy=10},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = { sword = 1, dalekanium = 1 }
})
if _drwho_tardis.GAMETYPE == "rp" then
	crafting.register_craft({
		output = "drwho_tardis:sword_dalek",
		items = {
			"drwho_tardis:dalekanium_ingot 3",
			"rp_default:fiber 4",
			i.stick.." 3",
		}
	})
else
core.register_craft({
    output = "drwho_tardis:sword_dalek",
    recipe = {
        {"drwho_tardis:dalekanium_ingot"},
        {"drwho_tardis:dalekanium_ingot"},
        {i.stick}
    }
})
end

-- Toolranks support
if core.get_modpath("toolranks") then
	toolranks.add_tool("drwho_tardis:sword_dalek")
	toolranks.add_tool("drwho_tardis:pick_dalek")
	toolranks.add_tool("drwho_tardis:axe_dalek")
	toolranks.add_tool("drwho_tardis:shovel_dalek")
end

-- Pickaxe Tweaks support
-- Automatically registers all tools with the group `pickaxe`
-- so we don't have to do anything extra

-- gauntlet of rassilon
core.register_tool("drwho_tardis:rassilon_gauntlet", {
	description = S("Gaunlet of Rassilon"),
	inventory_image = "gauntlet_rassilon.png",
	stack_max=1,
	_tt_help = S("Removes objects and individuals from history"),
	on_use = function(itemstack, player, pointed_thing)
		if pointed_thing.type == "object" then
			local obj = pointed_thing.ref
			obj:punch(player, nil, {full_punch_interval = 0.1, damage_groups = {fleshy=500}}, nil)
			itemstack:set_wear(itemstack:get_wear() + 4500) return itemstack
		end
	end
})


-- vortex manipulator
local function get_formspec_vortex()
    return "size[10,10]"..
		"field[1,1;8,1;teleport_x;X-Cord;0]"..
		"field[1,3;8,1;teleport_y;Y-Cord;0]"..
		"field[1,5;8,1;teleport_z;Z-Cord;0]"..
		"image_button_exit[1,6.5;3,3;dial_1.png;teleport; ;false;false;dial_2.png]"
end
core.register_tool("drwho_tardis:vortex_manipulator", {
	description = S("Vortex Manipulator"),
	inventory_image = "vortex_manipulator.png",
	stack_max=1,
	_tt_help = S("'Cheap and nasty time travel, very bad for you.'"),
	on_use = function(itemstack, player, pointed_thing)
		core.show_formspec(player:get_player_name(), "drwho_tardis:vortex_formspec", get_formspec_vortex() )
		itemstack:set_wear(itemstack:get_wear() + 3000) return itemstack
	end
})