-- CONTENTS
-- tooltip snippet functions for all generic node types in drwho_tardis:
--      Tardises
--      Console Units
--      Tardis interior doors
--      Decorative nodes:
--          Lights
--          Wall / building nodes
--          Circles
--      Dalekanium tools, armor + bar
-- 		Sonic Screwdrivers
-- NOT IN THIS FILE: Specific descriptions for special items such as craftitems 

local S = core.get_translator("drwho_tardis")

if core.get_modpath("tt") then

-- Tardises
tt.register_snippet(function(itemstring)
	local str = nil
	if core.get_item_group(itemstring, "tardis") == 1 then
		str = S("Time And Relative Dimension In Space")
	end
	return str
end)

---- Console Units ----

-- console_y, console_x, console_z - Axis Console Unit A, B, C
tt.register_snippet(function(itemstring)
    local is_console_xyz = core.get_item_group(itemstring, "tardis_console_x") == 1 
    or core.get_item_group(itemstring, "tardis_console_y") == 1 
    or core.get_item_group(itemstring, "tardis_console_z") == 1
	local str = nil
	if is_console_xyz then
		str = S("Controls the X, Y and Z coordinates of the destination")
	end
	return str
end)

-- console_c - Exterior Console Unit
tt.register_snippet(function(itemstring)
	local str = nil
	if core.get_item_group(itemstring, "tardis_console_c") == 1 then
		str = S("Controls the chameleon curcuitry, allowing the exterior skin to be changed")
	end
	return str
end)

-- console_go - Warp Lever Console Unit
tt.register_snippet(function(itemstring)
	local str = nil
	if core.get_item_group(itemstring, "tardis_console_go") == 1 then
		str = S("Holds the Warp Lever which initiates travel in space (and time??)")
	end
	return str
end)

-- console_f - Find Biome Console Unit
tt.register_snippet(function(itemstring)
	local str = nil
	if core.get_item_group(itemstring, "tardis_console_f") == 1 then
		str = S("Controls the ability to travel to a specific biome")
	end
	return str
end)

-- console_o - Waypoint Console Unit
tt.register_snippet(function(itemstring)
	local str = nil
	if core.get_item_group(itemstring, "tardis_console_o") == 1 then
		str = S("Controls the Waypoint System to remember 3 favourite destinations")
	end
	return str
end)

-- console_s - Functions Console Unit
tt.register_snippet(function(itemstring)
	local str = nil
	if core.get_item_group(itemstring, "tardis_console_s") == 1 then
		str = S("Holds various useful functions for a Time Lord")
	end
	return str
end)

-- Time Rotors
tt.register_snippet(function(itemstring)
	local str = nil
	if core.get_item_group(itemstring, "tardis_time_rotor") == 1 then
		str = S("Produces the power for a Tardis. 1 power is regenerated every 15 seconds")
	end
	return str
end)

-- Tardis monitor screen
tt.register_snippet(function(itemstring)
	local str = nil
	if core.get_item_group(itemstring, "tardis_monitor_screen") == 1 then
		str = S("Provides status information about it's Tardis. Right-click to view")
	end
	return str
end)

-- Tardis interior doors
tt.register_snippet(function(itemstring)
	local str = nil
	if core.get_item_group(itemstring, "tardis_in_door") == 1 then
		str = S("A door for use in Tardis interiors")
	end
	return str
end)

---- Decorative Nodes ----

-- tardis_light - Lights
tt.register_snippet(function(itemstring)
	local str = nil
	if core.get_item_group(itemstring, "tardis_light") == 1 then
		str = S("Brings light into a Tardis and it's many rooms")
	end
	return str
end)

-- tardis_decor - Most decorative nodes
tt.register_snippet(function(itemstring)
	local light = core.get_item_group(itemstring, "tardis_decor") == 1
	local str = nil
	if light then
		str = S("Decorative block designed for a Tardis")
	end
	return str
end)

-- Dalekanium
tt.register_snippet(function(itemstring)
	local str = nil
	if core.get_item_group(itemstring, "dalekanium") == 1 then
		str = S("Forged from the metal of a Dalek")
	end
	return str
end)

-- Sonic Screwdrivers
tt.register_snippet(function(itemstring)
	local str = nil
	if core.get_item_group(itemstring, "sonic_screwdriver") == 1 then
		str = S("A highly versatile piece of technology with many functions")
	end
	return str
end)

end