-- CONTENTS
-- Dalekanium Armor + Shield - definitions + crafting
--       Order: helmet, chestplate, leggings, boots, shield

local S = core.get_translator("drwho_tardis")

if _drwho_tardis.GAMETYPE == "mtg" then -- Only run this section in MTG-based games
if core.get_modpath("3d_armor") then -- and if 3d_armor is available

--Dalekanium Armor (using 3d_armor) and Shield
-- Armor Values similar to nether armor

-- Helmet
armor:register_armor("drwho_tardis:helmet_dalek", {
	description = (S("Dalekanium Helmet")),
	inventory_image = "inv_helmet_dalek.png",
	groups = {armor_head=1, armor_heal=14, armor_use=100, armor_fire=1, dalekanium = 1},
	armor_groups = {fleshy=18},
	damage_groups = {cracky=3, snappy=2, level=3},
})
core.register_craft({
	output = "drwho_tardis:helmet_dalek",
	recipe = {
		{"drwho_tardis:dalekanium_ingot", "drwho_tardis:dalekanium_ingot", "drwho_tardis:dalekanium_ingot"},
		{"drwho_tardis:dalekanium_ingot", "", "drwho_tardis:dalekanium_ingot"},
		{"", "", ""}
	}
})


-- Chestplate
armor:register_armor("drwho_tardis:chestplate_dalek", {
	description = (S("Dalekanium Chestplate")),
	inventory_image = "inv_chest_dalek.png",
	groups = {armor_torso=1, armor_heal=14, armor_use=200, armor_fire=1, dalekanium = 1},
	armor_groups = {fleshy=25},
	damage_groups = {cracky=3, snappy=2, level=3},
})
core.register_craft({
	output = "drwho_tardis:chestplate_dalek",
	recipe = {
		{"drwho_tardis:dalekanium_ingot", "", "drwho_tardis:dalekanium_ingot"},
		{"drwho_tardis:dalekanium_ingot", "drwho_tardis:dalekanium_ingot", "drwho_tardis:dalekanium_ingot"},
		{"drwho_tardis:dalekanium_ingot", "drwho_tardis:dalekanium_ingot", "drwho_tardis:dalekanium_ingot"}
	}
})


-- Leggings
armor:register_armor("drwho_tardis:leggings_dalek", {
	description = (S("Dalekanium Leggings")),
	inventory_image = "inv_leggings_dalek.png",
	groups = {armor_legs=1, armor_heal=14, armor_use=200, armor_fire=1, dalekanium = 1},
	armor_groups = {fleshy=25},
	damage_groups = {cracky=3, snappy=2, level=3},
})
core.register_craft({
	output = "drwho_tardis:leggings_dalek",
	recipe = {
		{"drwho_tardis:dalekanium_ingot", "drwho_tardis:dalekanium_ingot", "drwho_tardis:dalekanium_ingot"},
		{"drwho_tardis:dalekanium_ingot", "", "drwho_tardis:dalekanium_ingot"},
		{"drwho_tardis:dalekanium_ingot", "", "drwho_tardis:dalekanium_ingot"}
	}
})


-- Boots
armor:register_armor("drwho_tardis:boots_dalek", {
	description = (S("Dalekanium Boots")),
	inventory_image = "inv_boots_dalek.png",
	groups = {armor_feet=1, armor_heal=14, armor_use=200, armor_fire=1, dalekanium = 1},
	armor_groups = {fleshy=18},
	damage_groups = {cracky=3, snappy=2, level=3},
})
core.register_craft({
	output = "drwho_tardis:boots_dalek",
	recipe = {
		{"drwho_tardis:dalekanium_ingot", "", "drwho_tardis:dalekanium_ingot"},
		{"drwho_tardis:dalekanium_ingot", "", "drwho_tardis:dalekanium_ingot"}
	}
})


-- Shield
-- values from Mithril

-- Only if shields are enabled in 3d_armor settings
if core.get_modpath("shields") then

	armor:register_armor("drwho_tardis:shield_dalek", {
		description = (S("Dalekanium Shield")),
		inventory_image = "inv_shield_dalek.png",
		groups = {armor_shield=1, armor_heal=13, armor_use=66, dalekanium = 1},
		armor_groups = {fleshy=20},
		damage_groups = {cracky=2, snappy=1, level=3},
		reciprocate_damage = true,
		--on_damage = function(player, index, stack)
			--play_sound_effect(player, "default_dig_metal")
		--end,
		--on_destroy = function(player, index, stack)
			--play_sound_effect(player, "default_dug_metal")
		--end,
	})

	core.register_craft({
		output = "drwho_tardis:shield_dalek",
		recipe = {
			{"drwho_tardis:dalekanium_ingot", "drwho_tardis:dalekanium_ingot", "drwho_tardis:dalekanium_ingot"},
			{"drwho_tardis:dalekanium_ingot", "drwho_tardis:dalekanium_ingot", "drwho_tardis:dalekanium_ingot"},
			{"", "drwho_tardis:dalekanium_ingot", ""}
		}
	})
end -- of Shields

end -- Of 3d_armor check
--elseif _drwho_tardis.GAMETYPE == "mcl" then
	-- MineClone armor has not been made yet.

--elseif _drwho_tardis.GAMETYPE == "rp" then
--[[
if core.get_modpath("rp_armor") then
-- Will have to wait until we have the textures for them though
armor.register_armor_set("drwho_tardis", "dalek", {
	craftitem = "drwho_tardis:dalekanium_ingot",
	descriptions = {S("Dalekanium Helmet"), S("Dalekanium Chestplate"), S("Dalekanium Boots")},
	protections = 24, 
	full_suit_bonus = 5, 
	sound_equip = "rp_armor_equip_metal",
	sound_unequip = "rp_armor_unequip_metal",
	sound_pitch = 0.85,
	inventory_image_prefix = "rp_drwho_tardis",
})
end
--]]
end -- of game check