-- CONTENTS
-- All craftitems
-- Only the CRAFTitems, none of the actual items in-game
-- Includes the TARDIS biscuit

local S = core.get_translator("drwho_tardis")

-- ALL CRAFTITEMS

core.register_craftitem("drwho_tardis:artron_crystal", {
    description = S("Artron Crystal"),
    inventory_image = "artron_crystal.png",
    groups = {},
    _tt_help = S("A crystal imbued with Artron energy")
})
core.register_node("drwho_tardis:spacetime", {
    description = S("Compressed Spacetime"),
    tiles = {"tardis_spacetime.png"},
    groups = {cracky = 1},
    is_ground_content = false,
    _tt_help = S("Semi-unstable piece of spacetime compressed into a cube")
})
core.register_craftitem("drwho_tardis:circuitry_board", {
    description = S("Tardis Circuitry"),
    inventory_image = "tardis_circuit_board.png",
    groups = {},
    _tt_help = S("An essential component of any Tardis")
})
core.register_craftitem("drwho_tardis:biscuit", {
    description = S("Biscuit"),
    inventory_image = "tardis_biscuit.png",
    on_use = core.item_eat(8),
    _rp_hunger_food = 8, -- RePixture compat
    _rp_hunger_sat = 14, -- `rp_hunger`
    _tt_help = S("Is this healthy?"),
})
core.register_craftitem("drwho_tardis:azbantium_shard", {
    description = S("Azbantium Shard"),
    inventory_image = "azbantium_shard.png",
    _tt_help = S("A shard of a mineral 400 times stronger than diamond"),
})
core.register_craftitem("drwho_tardis:dalekanium_ingot", {
    description = S("Dalekanium Ingot"),
    inventory_image = "dalekanium_ingot.png",
    groups = {dalekanium = 1},
})
core.register_node("drwho_tardis:azbantium", {
    description = S("Azbantium"),
    light_source = 4,
    tiles = {"azbantium.png"},
    groups = {azbantium = 1},
    is_ground_content = false,
    _tt_help = S("A mineral 400 times stronger than diamond"),
})