# Contributing to drwho_tardis

We strive to provide a kind and welcoming place for anyone to contribute to this project,
no matter their skills or background.

## Report bugs

Sometimes things go wrong, or the game crashes. 
We would prefer it if this never happens, but we can only fix them if we know they exist.

You can [report bugs](https://codeberg.org/Skivling/DrWho_Tardis/issues) on Codeberg by selecting "New Issue".
Please provide as much information about it as you can, especially including any error messages.
Note that you'll need to create an account on Codeberg to report bugs.

## Request new features

You can make a [feature request](https://codeberg.org/Skivling/DrWho_Tardis/issues) by selecting "New Issue" on Codeberg.

It would be nice if you search the Issues to check that the feature hasn't already been requested.
If it has been, feel free to discuss your ideas and opinions about it!

## Create pixel art textures

If you are a pixel artist, you can help greatly by creating new or updated textures for the mod.
See [this list](https://codeberg.org/Skivling/DrWho_Tardis/issues/24) and discussion for ideas.

## Create 3D models

Do you know what would make this mod awesome? More 3D models.
If you are experienced in tools such as Blender or BlockBench, you can help by creating
revamped models for the Daleks, Cybermen, the TARDIS, or even [3D console nodes](https://codeberg.org/Skivling/DrWho_Tardis/issues/54)! 
Discuss on [this issue](https://codeberg.org/Skivling/DrWho_Tardis/issues/24).

## Translate the mod

If you speak more than one language, you can help make the mod playable by 
international users by [translating](https://translate.codeberg.org/projects/drwho_tardis/) on Codeberg Translate.
Feel free to add a new language, and focus on translating the "glossary" terms first.

## Contribute code

DrWho_Tardis is a [Luanti](https://luanti.org) mod, and is written in the [Lua](https://lua.org) programming language.
If you're able to write code and develop features, that would be greatly appreciated!

Head over to the [Issues](https://codeberg.org/Skivling/DrWho_Tardis/issues) on Codeberg
to find a feature you'd like to help with, or a bug you'd like to fix.

## Useful links

- [Codeberg Issues](https://codeberg.org/Skivling/DrWho_Tardis/issues): bug reports, feature requests.
- [Codeberg Translate](https://translate.codeberg.org/projects/drwho_tardis/): translation.
- [Luanti ContentDB](https://content.luanti.org/packages/skivling/drwho_tardis): download, play, review.
- [Download statistics](https://content.luanti.org/packages/Skivling/drwho_tardis/stats/): if you're interested.
- [Luanti forum topic](https://forum.luanti.org/viewtopic.php?t=30459): discussion, feature requests.
- [Matrix space](https://matrix.to/#/%23drwho_tardis:matrix.org): chat with the developers [prefer the forum or Codeberg].

