-- CONTENTS
-- Dalek Arm Gun weapon

local S = core.get_translator("drwho_tardis")

if core.get_modpath("mobs") then

-- speed of bullets
drwho_tardis.ARMGUN_VELOCITY = 20
-- minimum time between firing gun
drwho_tardis.ARMGUN_INTERVAL = 2

-- https://tardis.wiki/wiki/Gunstick
core.register_tool("drwho_tardis:armgun",{
    description = S("Dalek Arm"),
    _tt_help = S("A gunstick, previously a Dalek's left arm"),
    groups = {},
    inventory_image = "drwho_tardis_armgun.png",
    wield_image = "drwho_tardis_armgun.png^[transformR90",
    sound = {
        punch_use = "Laser",
        punch_use_air = "Laser",
    },
    on_use = function(itemstack, user, pointed_thing)
        local item_meta = itemstack:get_meta()

        if item_meta:get_int("min_fire_time") > os.clock() then
            return itemstack
        end

        local pos = user:get_pos()
        local dir = user:get_look_dir()
        local vel = vector.multiply(dir, drwho_tardis.ARMGUN_VELOCITY)

        pos.y = pos.y+1.5
        pos = vector.add(pos, dir)

        local projectile = core.add_entity(pos, "drwho_tardis:glaser")
        projectile:set_velocity(vel)

        local ent = projectile:get_luaentity()
        if ent then
            ent.fired_by_player = user:get_player_name()
        end

        itemstack:add_wear(250)
        item_meta:set_int("min_fire_time", os.clock()+drwho_tardis.ARMGUN_INTERVAL)
        return itemstack
    end,
})

-- reset min_fire_time when player joins
-- it appears this isn't necessary, but I'll keep it just in case bugs show up
--[[
core.register_on_joinplayer(function(player, last_login)
    for item in ipairs(player:get_inventory():get_list("main")) do
        if item == "drwho_tardis:armgun" then
            item:get_meta():set_int("min_fire_time", 0)
        end
    end
end)
]]--

end -- if `mobs` is enabled