# DrWho_Tardis API

This mod has a couple API functions to make life easier for developers of it, and also support other mods adding their own things to it.

Please note: 

- The functions use a colon `:`, not a dot `.` after `drwho_tardis`

- Usually `name` is a string of the player name, `id` is a string of the player name that owns a certain Tardis, `player` is the player object, and `user` is an internally used reference to their userdata.

- We will refer to the player piloting the TARDIS as the pilot. 

- Error messages (`errmsg` or `msg`) returned are NOT translated, unless explicitly stated.

- These API may change in future updates, **especially v1.3.0**. After that update, most API should be stable.

## Public API Functions

### `drwho_tardis:register_tardis_exterior(def)`

Makes it very simple to add another TARDIS exterior, which is also added to the exterior console unit.

#### Parameters

- `def`: A table with all possible parameters in it:
  
  **Required:**
  
  - `name`: The short name for the exterior. It will be inserted into the itemstring as so: `drwho_tardis:tardis_<name>` and `drwho_tardis:tardis_<name>_locked`. This should NOT be translated.
  
  - `texture`: The texture used for the TARDIS. Defaults to using the "mesh" format, just use one of the existing textures as a base. If you want to use "nodebox" to draw a node's texture on it, set that in `drawtype`.
  
  **Optional:**
  
  - `light`: (default: 10): Allows you to make the exterior glow less, more, or not at  all (0). Make sure it is a value between 0 and 14.
  
  - `description`: (default: "Tardis"): The player-facing title of the actual item. Not recommended to be changed. If changed, this SHOULD be translated.
  
  - `title`: (default: `name`^): The title of the exterior when listed on the exterior console unit. Defaults to `name`, but that is usually all lowercase so it is a good idea to set this with a capitalised word. This SHOULD be translated.
  
  - `drawtype`: (default: "mesh"): As mentioned above, this allows the modder to set the drawtype to "nodebox". Then you can pass a single node texture to `texture` which will be put all over the TARDIS. This is used in the default Stone, Leaves and Invisible textures.
  
  - `groups`: must have `tardis = 1` and should have `not_in_creative_inventory = 1` as well. The only Tardis that is in creative inventory is the default one.

#### Additional notes

- Does not return anything. 
- Ensure that the `name` is unique, otherwise it will override the previous one with that name and break some things.

#### Example usage

```lua
-- Exterior with mesh texture
drwho_tardis:register_tardis_exterior({
	name = "green",
	texture = "tardis_green.png",
	title = S("Green"),
	author = "Skivling"
})

-- Exterior using existing textures (Nodebox drawtype)
drwho_tardis:register_tardis_exterior({
	name = "stone",
	texture = "default_stone.png",
	drawtype = "nodebox",
	light = 0,
	title = S("Stone"),
	author = "PiDemon"
})
```

### `drwho_tardis:register_in_door_style(def)`

Allows you to create custom styles to be used as Tardis interior exit doors.

#### Parameters

- `def` (table):
  - `texture`: The texture for the door.
  - `description`: The player-facing name. This SHOULD be translated.
  - `itemstring`: The itemstring of the door.

#### Example usage

```lua
drwho_tardis:register_in_door_style({
	texture = "drwho_tardis_inside_door_b.png",
	description = S("Tardis Interior Exit Door (style B)"),
	itemstring = "drwho_tardis:in_door_b"
})
```

### `drwho_tardis:register_sonic_device(def)`

Registers a sonic device, whether that be a screwdriver or lipstick (Sarah Jane's, planned). Any item that has the functionality of a sonic.

#### Parameters

- `def` is a table with all the parameters in it:

**Required:**

- `gentype`: Tell the function if you are setting your own texture (`custom`), choosing from the 1/3 textures (`choose`), or making it random (`random`). 
  
  - If you do the arithmetic for randomising the numbers before giving the values to the function, set it to `choose`.

- `sonictype`: Either "screwdriver" or a custom one, such as "lipstick". It will default to "screwdriver" but should be specified.

- `no_creative`: If `true`, the new sonic device will *not* appear in the creative inventory. If `false`, it will appear in the creative inventory. 
  
  - This can be useful for player-only sonics, or if you are registering lots that don't need to flood the inventory.

**Optional:**

- `texture`: If the modder wants to use a custom texture that does not use the sonic screwdriver section textures. If so, a `customname` and `customdescription` must be given.

- `top`: The number for what texture to be used in the top third of a sonic, defaults to random.

- `mid`: The number for what texture to be used in the middle third of a sonic, defaults to random.

- `bottom`: The number for what texture to be used in the bottom third of a sonic, defaults to random.

- `customname`: This is the itemstring. It defaults to `"drwho_tardis:sonic_"..sonictype.."_"..top.."_"..mid.."_"..bottom`, so if you want it to be part of your mod's modname space, you must use this value, as well as appending the modname with `:` to tell the engine to not care that the modname isn't `drwho_tardis` even though it appears to be registered from that because of the function. 
  
  - For example, `:extra_sonics:sonic_playing_cards_3` if, for some reason you wanted a pack of cards to have sonic ability.  Actually, that doesn't sound like a bad idea...

- `tool_capabilities`: A table, allowing you to customize the capabilities of that particular sonic. `full_punch_interval`, `groupcaps.sonic` allows you to change the `uses` and `maxlevel` of it, the higher they are the more durability the sonic has.

- `sounds`: Must be a table where the value `sonic_use` is a custom sound file to play when the sonic is used, and includes the `max_hear_distance`.

 

Returns the full `item_name`.

- It may include the extra `:` if you put your own modname in the `customname`, if so you can remove it with `item_name = item_name:match"^.-:(.+)"`.

#### Additional notes

* A different API may be added in the future that allows custom sonic functions to be added as long as they don't break the default ones.

- The names of each variable in `def` will most likely change in version `1.3.0` when APIs are cleaned up. 
  
#### Example usage:

```lua
-- Register sonic playing cards as part of the mod 'extra_sonics'
drwho_tardis:register_sonic_device({
    gentype = "custom", -- We are specifying the texture
    texture = "extra_sonics_playing_cards.png",
    sonictype = "playing_cards",
    no_creative = false, -- We want it to appear in the creative inventory
    customname = ":extra_sonics:sonic_playing_cards", -- itemstring
    customdescription = "Sonic Playing Cards", -- player-facing name
})
```



### `drwho_tardis.get:tardis_ext_position(name)`

Finds the exterior position of a certain player's Tardis. Returns:

- `success` is a boolean value if it worked or not

- `errmsg` is a string which has an error message if `success` is false.

- `pos` is the position of the Tardis.

### `drwho_tardis.get:interior_type(name)`

Returns the interior `type` of a player's Tardis, but returns `"old"` even if they don't have a Tardis.
Most interiors have a size of 42x42x42.

- `type` is a string which corresponds to the interior type they have. Default types:

    - `default`: The default Tardis interior, including a console room, various other rooms and lots of space.
    - `basic`: The same console room as `default`, but without prebuilt corridors and rooms.
    - `default_22`: The old default in v1.2.0. It is only 22x22x22 nodes large.
    - `old`: All Tardises made before v1.2.0. A simple cube.
    - `green`: A small console room using the green and grey metal from scifi_nodes.

### `drwho_tardis.get:interior_depth()`

Returns the default interior depth that is used in new Tardises. It is an integer, probably `-10000` or `-50` depending on the gametype.

### `drwho_tardis.get:exterior_list()`

Returns a list of the available exterior types for a Tardis.

### `drwho_tardis.get:power(name)`

Returns the current power level of a player's Tardis.

---

## Internal Functions

These functions are mostly used within the mod itself. Any that are prefixed with `_drwho_tardis` cannot be used by any other mod.

### `drwho_tardis.fourDir_to_dir(dir)`

Takes a 4dir param2 value (`dir`, between 0 - 3) and returns it as a degree out of 360º. 0,1,2,3 are N,E,S,W respectively.

### `drwho_tardis.fourDir_to_dir_flipped(dir)`

Takes a 4dir param2 value (`dir`, between 0 - 3) and converts it to a degree out of 360º, then flips North and South by 180º.

### `drwho_tardis.shift_1_node_from_4dir(pos, dir)`

Takes a position `pos` and a 4dir param2 value (`dir`, between 0 - 3), then returns that position shifted by 1 node in that direction.

### `drwho_tardis.serialize_pos(pos, posy, posz)`

Returns a serialized version of the entered `pos`, like `"(35, -12, 155)"`. `pos` can be a table, or use all three arguments as the x, y and z values respectively. 

```lua
drwho_tardis.serialize_pos(vector.new(35,-12,155))
-- return "(35, -12, 155)"

drwho_tardis.serialize_pos(35, -12, 155)
-- return "(35, -12, 155)"
```

### `_drwho_tardis.log(input)`

Always use this logging function when debugging and testing code in this mod. 
It only prints if the version number includes `dev`, so it's disabled on release versions.

### `_drwho_tardis:verify_mods_for_interior(type)`

Checks that all mods required for a certain interior schematic `type` are enabled.

Returns `verified` (boolean), `errmsg` (empty string), `missing_mods` (list of missing mods).

### `_drwho_tardis:place_tardis_interior(id, type, pos)`

Places a Tardis interior for a certain player `id`.

Returns `success` (boolean), `errmsg` (string), `type` (same that was entered).

### `_drwho_tardis:init_interior_door(id, exit_door_pos)`

Sets correct metadata and intiates the node timer for a Tardis interior exit door.

Returns `success` (boolean), `exit_door_pos` (same that was entered)

### `_drwho_tardis:rebuild_tardis_interior(id)`

Rebuilds a certain player `id`'s Tardis interior. Returns:

- `success`: boolean if it worked
- `errmsg`: Error message if applicable
- `exit_door_pos`: Position of the interior exit door. If function failed, it will be the `type` of their interior.

### `_drwho_tardis.is_time_rotor(id, pos)`

Checks if a player has a Time Rotor in their Tardis. `id` is required, `pos` is not. Returns:

- `success`: `true` if they have one, `false` if they don't 
- `errmsg`: `"rotor is there"` if they have one, `"rotor is not there"` if they don't, or the error message `"r_pos doesn't exist"`.
- `r_pos`: Position (or expected pos) of the Time Rotor.

### `_drwho_tardis.update_tardis_global_table(id, anchor_pos)`

Saves tardis interior position in global reference table so that future Tardis interiors don't overlap it.
`anchor_pos` is the position at which the schematic is placed.

Returns `success`.

### `_drwho_tardis.validate_interior_pos(id, pos)`

Validates if a certain position is inside a Tardis. Returns:

- `success`: `true` if pos is not close to existing Tardis interiors. 
             `false` if pos is too close and would overlap/partially destroy someone elses'.

### `_drwho_tardis.switch_time_rotor(id, on_off, send_msg)`

Starts/stops time rotor animation.

- `id`: Name of Tardis owner.
- `on_off`: `"on"` to start animation, `"off"` to stop animation. Required parameter.
- `send_msg`: Default `true`. When `true`, a warning will be sent to the player if their Time Rotor is not there.

Returns `success` and `r_pos`.

### `_drwho_tardis.toggle_int_door(id, on_off)`

Locks or unlocks the interior door of `id`'s Tardis. If `on_off` is not given, it will toggle. If the door is not there, it will be created. Returns:

- `success`: Always `true`. 
- `msg`: `"Interior door locked"` or `"Interior door unlocked"`

### `_drwho_tardis.toggle_mavity(id)`

Toggles the antigrav system for a player `id` (`user.respect_mavity`). Returns:

- `success`: Always `true`. If the player doesn't exist yet, the function will still run and set the userdata value.
- `msg`: `"Antigrav system disabled"`, `"Antigrav system enabled and set to sink in liquids"`, or `"Antigrav system enabled but won't sink in water"`. This string IS translated.
- `mavity`: The new value of `user.respect_mavity`. Can be `"yes"`, `"no"` or `"sink"`.