local S = minetest.get_translator("betterlocks")
local Sdoors = minetest.get_translator("doors")

betterlocks = {}

--aliases for /give i guess
minetest.register_alias("titaniumblock", "betterlocks:titaniumblock")
minetest.register_alias("titanium", "betterlocks:titaniumblock")
minetest.register_alias("stone_with_titanium", "betterlocks:stone_with_titanium")
minetest.register_alias("titanium_ore", "betterlocks:stone_with_titanium")
minetest.register_alias("titaniumore", "betterlocks:stone_with_titanium")
minetest.register_alias("titanium_ingot", "betterlocks:titanium_ingot")
minetest.register_alias("titaniumingot", "betterlocks:titanium_ingot")
minetest.register_alias("betterlocks:titaniumingot", "betterlocks:titanium_ingot")
--nodes
minetest.register_node("betterlocks:stone_with_titanium", {
	description = S("Titanium Ore"),
	tiles = {"default_stone.png^default_mineral_titanium.png"},
	groups = {cracky = 3},
	sounds = default.node_sound_stone_defaults(),
})
minetest.register_node("betterlocks:titaniumblock", {
	description = S("Titanium Block"),
	tiles = {"default_titanium_block.png"},
	is_ground_content = false,
	groups = {cracky = 1, level = 3},
	sounds = default.node_sound_metal_defaults(),
})
--items
minetest.register_craftitem("betterlocks:titanium_ingot", {
	description = S("Titanium Ingot"),
	inventory_image = "default_titanium_ingot.png"
})
--mapgen
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "betterlocks:stone_with_titanium",
	wherein        = "default:stone",
	clust_scarcity = 14 * 14 * 14,
	clust_num_ores = 2,
	clust_size     = 1,
	y_max          = -100,
	y_min          = -255,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "betterlocks:stone_with_titanium",
	wherein        = "default:stone",
	clust_scarcity = 13 * 13 * 13,
	clust_num_ores = 3,
	clust_size     = 1,
	y_max          = -256,
	y_min          = -31000,
})
--crafts
minetest.register_craft({
	type = "cooking",
	output = "betterlocks:titanium_ingot",
	recipe = "betterlocks:stone_with_titanium",
})
minetest.register_craft({
	output = "betterlocks:titaniumblock",
	recipe = {
		{"betterlocks:titanium_ingot", "betterlocks:titanium_ingot", "betterlocks:titanium_ingot"},
		{"betterlocks:titanium_ingot", "betterlocks:titanium_ingot", "betterlocks:titanium_ingot"},
		{"betterlocks:titanium_ingot", "betterlocks:titanium_ingot", "betterlocks:titanium_ingot"},
	}
})

local function replace_old_owner_information(pos)
	local meta = minetest.get_meta(pos)
	local owner = meta:get_string("doors_owner")
	if owner and owner ~= "" then
		meta:set_string("owner", owner)
		meta:set_string("doors_owner", "")
	end
end

local function is_doors_upper_node(pos)
	return minetest.get_node(pos).name == "doors:hidden"
end

local transform = {
	{
		{v = "_a", param2 = 3},
		{v = "_a", param2 = 0},
		{v = "_a", param2 = 1},
		{v = "_a", param2 = 2},
	},
	{
		{v = "_c", param2 = 1},
		{v = "_c", param2 = 2},
		{v = "_c", param2 = 3},
		{v = "_c", param2 = 0},
	},
	{
		{v = "_b", param2 = 1},
		{v = "_b", param2 = 2},
		{v = "_b", param2 = 3},
		{v = "_b", param2 = 0},
	},
	{
		{v = "_d", param2 = 3},
		{v = "_d", param2 = 0},
		{v = "_d", param2 = 1},
		{v = "_d", param2 = 2},
	},
}

local function on_place_node(place_to, newnode,
	placer, oldnode, itemstack, pointed_thing)
	for _, callback in ipairs(minetest.registered_on_placenodes) do
		local place_to_copy = {x = place_to.x, y = place_to.y, z = place_to.z}
		local newnode_copy =
			{name = newnode.name, param1 = newnode.param1, param2 = newnode.param2}
		local oldnode_copy =
			{name = oldnode.name, param1 = oldnode.param1, param2 = oldnode.param2}
		local pointed_thing_copy = {
			type  = pointed_thing.type,
			above = vector.new(pointed_thing.above),
			under = vector.new(pointed_thing.under),
			ref   = pointed_thing.ref,
		}
		callback(place_to_copy, newnode_copy, placer,
			oldnode_copy, itemstack, pointed_thing_copy)
	end
end

local function can_dig_door(pos, digger)
	replace_old_owner_information(pos)
	return default.can_interact_with_node(digger, pos)
end

local function add_zeros(stringy, length)
    if string.len(tonumber(stringy)) < length then
        local seros = length - #tostring(stringy)
        return string.rep("0", seros) .. stringy
    else
        return stringy
    end
end

function betterlocks.register(name, def)
	if not name:find(":") then
		name = "doors:" .. name
	end

	minetest.register_lbm({
		name = ":doors:replace_" .. name:gsub(":", "_"),
		nodenames = {name.."_b_1", name.."_b_2"},
		action = function(pos, node)
			local l = tonumber(node.name:sub(-1))
			local meta = minetest.get_meta(pos)
			local h = meta:get_int("right") + 1
			local p2 = node.param2
			local replace = {
				{{type = "a", state = 0}, {type = "a", state = 3}},
				{{type = "b", state = 1}, {type = "b", state = 2}}
			}
			local new = replace[l][h]

			minetest.swap_node(pos, {name = name .. "_" .. new.type, param2 = p2})
			meta:set_int("state", new.state)

			local p3 = p2
			if new.state >= 2 then
				p3 = (p3 + 3) % 4
			end
			if new.state % 2 == 1 then
				if new.state >= 2 then
					p3 = (p3 + 1) % 4
				else
					p3 = (p3 + 3) % 4
				end
			end

			minetest.set_node({x = pos.x, y = pos.y + 1, z = pos.z},
				{name = "doors:hidden", param2 = p3})
		end
	})

	minetest.register_craftitem(":" .. name, {
		description = def.description,
		inventory_image = def.inventory_image.."^betterlocks_override_inv.png",
		groups = table.copy(def.groups),
		on_place = function(itemstack, placer, pointed_thing)
			local pos

			if pointed_thing.type ~= "node" then
				return itemstack
			end

			local doorname = itemstack:get_name()
			local node = minetest.get_node(pointed_thing.under)
			local pdef = minetest.registered_nodes[node.name]
			if pdef and pdef.on_rightclick and
					not (placer and placer:is_player() and
					placer:get_player_control().sneak) then
				return pdef.on_rightclick(pointed_thing.under,
						node, placer, itemstack, pointed_thing)
			end

			if pdef and pdef.buildable_to then
				pos = pointed_thing.under
			else
				pos = pointed_thing.above
				node = minetest.get_node(pos)
				pdef = minetest.registered_nodes[node.name]
				if not pdef or not pdef.buildable_to then
					return itemstack
				end
			end

			local above = {x = pos.x, y = pos.y + 1, z = pos.z}
			local top_node = minetest.get_node_or_nil(above)
			local topdef = top_node and minetest.registered_nodes[top_node.name]

			if not topdef or not topdef.buildable_to then
				return itemstack
			end

			local pn = placer and placer:get_player_name() or ""
			if minetest.is_protected(pos, pn) or minetest.is_protected(above, pn) then
				return itemstack
			end

			local dir = placer and minetest.dir_to_facedir(placer:get_look_dir()) or 0

			local ref = {
				{x = -1, y = 0, z = 0},
				{x = 0, y = 0, z = 1},
				{x = 1, y = 0, z = 0},
				{x = 0, y = 0, z = -1},
			}

			local aside = {
				x = pos.x + ref[dir + 1].x,
				y = pos.y + ref[dir + 1].y,
				z = pos.z + ref[dir + 1].z,
			}

			local state = 0
			if minetest.get_item_group(minetest.get_node(aside).name, "door") == 1 then
				state = state + 2
				minetest.set_node(pos, {name = doorname .. "_b", param2 = dir})
				minetest.set_node(above, {name = "doors:hidden", param2 = (dir + 3) % 4})
			else
				minetest.set_node(pos, {name = doorname .. "_a", param2 = dir})
				minetest.set_node(above, {name = "doors:hidden", param2 = dir})
			end

			local meta = minetest.get_meta(pos)
			meta:set_int("state", state)

			meta:set_string("owner", pn)

			if def.protected and not def.locker then
				meta:set_string("infotext", def.description .. "\n" .. S("Owned by @1", pn))
			end

			if def.locker then
				meta:set_string("infotext", def.description)
			end

			if not minetest.is_creative_enabled(pn) then
				itemstack:take_item()
			end

			minetest.sound_play(def.sounds.place, {pos = pos}, true)

			on_place_node(pos, minetest.get_node(pos),
				placer, node, itemstack, pointed_thing)

			return itemstack
		end
	})
	def.inventory_image = nil

	if def.recipe then
		minetest.register_craft({
			output = name,
			recipe = def.recipe,
		})
	end
	def.recipe = nil

	if not def.sounds then
		def.sounds = default.node_sound_wood_defaults()
	end

	if not def.sound_open then
		def.sound_open = "doors_door_open"
	end

	if not def.sound_close then
		def.sound_close = "doors_door_close"
	end

	if not def.gain_open then
		def.gain_open = 0.3
	end

	if not def.gain_close then
		def.gain_close = 0.3
	end

	def.groups.not_in_creative_inventory = 1
	def.groups.door = 1
	def.drop = name
	def.door = {
		name = name,
		sounds = {def.sound_close, def.sound_open},
		gains = {def.gain_close, def.gain_open},
	}
	if not def.on_rightclick and not def.locker then
		def.on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
			doors.door_toggle(pos, node, clicker)
			return itemstack
		end
	end
	def.after_dig_node = function(pos, node, meta, digger)
		local above = pos:offset(0, 1, 0)
		if is_doors_upper_node(above) then
			minetest.remove_node(above)
		end
		minetest.check_for_falling(above)
	end
	def.on_rotate = function(pos, node, user, mode, new_param2)
		return false
	end

	if def.protected and not def.locker then
		def.can_dig = can_dig_door
		def.on_blast = function() end
		def.on_key_use = function(pos, player)
			local door = doors.get(pos)
			door:toggle(player)
		end
		def.on_empty_key_use = function(pos, player, newsecret)
			replace_old_owner_information(pos)
			local meta = minetest.get_meta(pos)
			local owner = meta:get_string("owner")
			local pname = player:get_player_name()

			if owner ~= pname then
				minetest.record_protection_violation(pos, pname)
				minetest.chat_send_player(pname, S("You do not own this locked door."))
				return nil
			end

			local secret = meta:get_string("key_lock_secret")
			if secret == "" then
				secret = newsecret
				meta:set_string("key_lock_secret", secret)
			end

			return secret, S("a locked door"), owner
		end
		def.node_dig_prediction = ""
	elseif def.locker then
		def.can_dig = can_dig_door
		def.on_blast = function() end
		def.on_key_use = function(pos, player)
			local door = doors.get(pos)
			local itemstack = player:get_wielded_item()
			local meta = minetest.get_meta(pos)
			local imeta = itemstack:get_meta()
			local name = itemstack:get_name()
			if not ((name == "betterlocks:key") and (meta:get_string("key_code") == imeta:get_string("key_code"))) then
				return
			end
			door:toggle(player)
		end
		def.on_empty_key_use = function(pos, player, key_code)
			local meta = minetest.get_meta(pos)
			if (meta:get_string("key_code") == "") or (meta:get_string("key_code") == nil) then
				return
			end
		end
	else
		def.on_blast = function(pos, intensity)
			minetest.remove_node(pos)
			local above = pos:offset(0, 1, 0)
			if is_doors_upper_node(above) then
				minetest.remove_node(above)
			end
			return {name}
		end
	end

	def.on_destruct = function(pos)
		local above = pos:offset(0, 1, 0)
		if is_doors_upper_node(above) then
			minetest.remove_node(above)
		end
		minetest.add_item(pos, name)
		if string.find(name, "glass") then
			minetest.sound_play("doors_glass_door_close", {pos = pos, pitch = 0.6, max_hear_distance = 10}, true)
		else
			minetest.sound_play("doors_door_close", {pos = pos, pitch = 0.6, max_hear_distance = 10}, true)
		end
	end

	def.drawtype = "mesh"
	def.paramtype = "light"
	def.paramtype2 = "facedir"
	def.sunlight_propagates = true
	def.walkable = true
	def.is_ground_content = false
	def.buildable_to = false
	def.selection_box = {type = "fixed", fixed = {-1/2,-1/2,-1/2,1/2,3/2,-6/16}}
	def.collision_box = {type = "fixed", fixed = {-1/2,-1/2,-1/2,1/2,3/2,-6/16}}
	def.use_texture_alpha = def.use_texture_alpha or "clip"

	def.mesh = "door_a.b3d"
	minetest.register_node(":" .. name .. "_a", table.copy(def))

	def.mesh = "door_b.b3d"
	minetest.register_node(":" .. name .. "_b", table.copy(def))

	def.mesh = "door_b.b3d"
	minetest.register_node(":" .. name .. "_c", table.copy(def))

	def.mesh = "door_a.b3d"
	minetest.register_node(":" .. name .. "_d", table.copy(def))

	doors.registered_doors[name .. "_a"] = true
	doors.registered_doors[name .. "_b"] = true
	doors.registered_doors[name .. "_c"] = true
	doors.registered_doors[name .. "_d"] = true
end

minetest.register_craftitem("betterlocks:empty_key", {
	description = S("Empty Key"),
	inventory_image = "betterlocks_key_empty.png",
	on_use = function(itemstack, user, pointed_thing)
		if pointed_thing.type ~= "node" then
			return itemstack
		end
		local pos = pointed_thing.under
		local node = minetest.get_node(pos)
		if not node then
			return itemstack
		end
		local node_reg = minetest.registered_nodes[node.name]
		local on_empty_key_use = node_reg and node_reg.on_empty_key_use
		if not on_empty_key_use then
			return itemstack
		end
		local key_code = tostring(add_zeros(math.random(1, 99999999), 8))
		local locked, _, _ = on_empty_key_use(pos, user, key_code)
		local nmeta = minetest.get_meta(pos)
		--minetest.chat_send_all(dump(key_code).." "..dump(nmeta:get_string("key_code")))
		if nmeta:get_string("key_code") == "" then
			local inv = minetest.get_inventory({type="player", name=user:get_player_name()})
			itemstack:take_item()
			local new_stack = ItemStack("betterlocks:key")
			local meta = new_stack:get_meta()
			meta:set_string("key_code", key_code)
			meta:set_string("description", minetest.registered_craftitems["betterlocks:key"].description.."\nID: "..key_code)
			nmeta:set_string("infotext", nmeta:get_string("infotext").."\nID: "..key_code)
			nmeta:set_string("key_code", key_code)

			if itemstack:get_count() == 0 then
				itemstack = new_stack
			else
				if inv:add_item("main", new_stack):get_count() > 0 then
					minetest.add_item(user:get_pos(), new_stack)
				end
			end
			return itemstack
		end
	end,
})

minetest.register_craftitem("betterlocks:key", {
	description = S("Attached Key"),
	inventory_image = "betterlocks_key.png",
	groups = {not_in_creative_inventory = 1},
	on_place = function(itemstack, user, pointed_thing)
		if pointed_thing.type ~= "node" then
			return itemstack
		end
		local pos = pointed_thing.under
		local node = minetest.get_node(pos)
		if not node then
			return itemstack
		end
		local node_reg = minetest.registered_nodes[node.name]
		local on_key_use = node_reg and node_reg.on_key_use
		if not on_key_use then
			return itemstack
		end
		--local key_code = add_zeros(math.random(1, 99999999), 8)
	    local key_code = itemstack:get_meta():get_string("key_code")
		--minetest.chat_send_all(dump(key_code))
		local locked, _, _ = on_key_use(pos, user, key_code)
		return itemstack
	end,
	on_use = function(itemstack, user, pointed_thing)
		if pointed_thing.type ~= "node" then
			return itemstack
		end
		local pos = pointed_thing.under
		local node = minetest.get_node(pos)
		if not node then
			return itemstack
		end
		if not (minetest.get_meta(pos):get_string("key_code") == itemstack:get_meta():get_string("key_code")) then
			return
		end
		minetest.remove_node(pos)
		local inv = minetest.get_inventory({type="player", name=user:get_player_name()})
		itemstack:take_item()
		local new_stack = ItemStack("betterlocks:empty_key")
		if itemstack:get_count() == 0 then
			itemstack = new_stack
		else
			if inv:add_item("main", new_stack):get_count() > 0 then
				minetest.add_item(user:get_pos(), new_stack)
			end
		end
		return itemstack
	end,
})

minetest.register_craft({
	output = "betterlocks:locker",
	recipe = {
		{"default:gold_ingot", "default:gold_ingot", "default:gold_ingot"},
		{"default:gold_ingot", "", "default:gold_ingot"},
		{"default:steel_ingot", "betterlocks:titaniumblock", "default:steel_ingot"},
	},
})


minetest.register_craft({
	output = "betterlocks:empty_key",
	recipe = {
		{"betterlocks:titanium_ingot", "betterlocks:titanium_ingot", "betterlocks:titanium_ingot"},
		{"betterlocks:titanium_ingot", "", "default:steel_ingot"},
		{"", "", "default:tin_ingot"},
	},
})

minetest.register_craftitem("betterlocks:locker", {
	description = S("Lock"),
	inventory_image = "betterlocks_locker.png",
})

minetest.register_on_punchnode(function(pos, node, puncher, pointed_thing)
	local itemstack = puncher:get_wielded_item()
	local name = puncher:get_player_name()
	local meta = minetest.get_meta(pos)
	--minetest.chat_send_all(dump(meta:get_string("owner")).." "..name)
	if meta:get_string("key_code") == "" then
		if string.find(node.name, "betterlocks:door_wood") then
			if string.find(itemstack:get_name(), "axe_") then
				minetest.remove_node(pos)
				itemstack:add_wear(500)
				puncher:set_wielded_item(itemstack)
			end
		elseif string.find(node.name, "betterlocks:door_glass") then
			if string.find(itemstack:get_name(), "pick_") then
				minetest.remove_node(pos)
				itemstack:add_wear(500)
				puncher:set_wielded_item(itemstack)
			end
		end
	end
end)

-- Doors --
betterlocks.register("betterlocks:door_wood", {
	tiles = {{ name = "doors_door_wood.png^bettelocks_override.png", backface_culling = true }},
	description = S("Locked").." "..Sdoors("Wooden Door"),
	inventory_image = "doors_item_wood.png",
	locker = true,
	groups = {node = 1, cracky = 0, flammable = 2},
	gain_open = 0.06,
	gain_close = 0.13,
	recipe = {
		{"doors:door_wood", "betterlocks:locker"},
	}
})
betterlocks.register("betterlocks:door_glass", {
	tiles = {"doors_door_glass.png^bettelocks_override.png"},
	description = S("Locked").." "..Sdoors("Glass Door"),
	inventory_image = "doors_item_glass.png",
	locker = true,
	groups = {node = 1, cracky=0},
	sounds = default.node_sound_glass_defaults(),
	sound_open = "doors_glass_door_open",
	sound_close = "doors_glass_door_close",
	gain_open = 0.3,
	gain_close = 0.25,
	recipe = {
		{"doors:door_glass", "betterlocks:locker"},
	}
})
