deltatime = {
    time = 0
}

-- Getting and adding deltatime
minetest.register_globalstep(function(dtime)
    local delta = deltatime.time
    if dtime then
        deltatime.time = delta+dtime
    end
end)

-- Get the deltatime function
function deltatime.get(param)
    -- Checks if param is wrong and gives total deltatime, or checks for seconds/minutes and hours
    if (param == "s") or (param == "sec") or (param == "secs") or (param == "second") or (param == "seconds") then
        -- Returns seconds
        return deltatime.time
    elseif (param == "m") or (param == "min") or (param == "mins") or (param == "minute") or (param == "minutes") then
        -- Returns minutes
        return deltatime.time/60
    elseif (param == "h") or (param == "hour") or (param == "hours") then
        -- Returns hours
        return deltatime.time/3600
    else
        -- Returns the deltatime that we getting from globalstep
        return deltatime.time
    end
end

-- Adding time in deltatime
function deltatime.add(sec, min, hour)
    -- New variable for adding a time
    local time = 0
    
    -- Checks if some params are nil
    if (sec == nil) or (min == nil) or (hour == nil) then
        -- Adding seconds
        if (sec > 0) then
            time = time+sec
        end

        -- Adding some minutes
        if (min > 0) then
            time = time+(60*min)
        end

        -- Adds hours
        if (hour > 0) then
            time = time+(3600*hour)
        end
    else
        -- Error if some param are nil
        error("Params cannot be nil!")
    end

    -- Final setting the time
    deltatime.time = deltatime.time+time
end

-- Adds command for debuggers
minetest.register_chatcommand("deltatime", {
    params = "[seconds|minutes|hours] [value]",
    description = "Check and sets deltatime in-game!",
    privs = {time = true},
    func = function(name, param)
        -- Gets params
        local unit, _, value = string.match(param, "(%S*)(%s*)(%S*)")
        unit = unit ~= "" and unit or nil
        value = value ~= "" and value or nil

        -- Checks for unit
        if unit then
            -- Checks if value is exist
            if value then
                -- Converts to REAL number
                value = tonumber(value)

                -- Checks for incorrection
                if not value then
                    return false, "Value must to be number"
                end

                -- Checks for debug privilege, which has a player or not
                if minetest.check_player_privs(name, {debug = true}) then
                    -- Detection of unit
                    if unit == "seconds" then
                        -- Sets value and sends a message
                        deltatime.time = value
                        return true, "Deltatime sets in ".. value .." seconds"
                    elseif unit == "minutes" then
                        -- Sets value and sends a message
                        deltatime.time = value*60
                        return true, "Deltatime sets in ".. value .." minutes"
                    elseif unit == "hours" then
                        -- Sets value and sends a message
                        deltatime.time = value*3600
                        return true, "Deltatime sets in ".. value .." hours"
                    else
                        -- If unit is incorrect, it sends message with some tips
                        return false, "Incorrect unit. Use 'seconds', 'minutes' or 'hours'!"
                    end
                else
                    -- Tells about, that you doesnt have a needed privilege
                    return false, "Your privileges are insufficient."
                end
            else
                -- Detection of unit
                if unit == "seconds" then
                    -- Rounds and sends a message
                    return true, "Deltatime is about ".. math.round(deltatime.time) .." seconds(-s)"
                elseif unit == "minutes" then
                    -- Rounds and sends a message
                    return true, "Deltatime is about ".. math.round(deltatime.time/60) .." minute(-s)"
                elseif unit == "hours" then
                    -- Rounds and sends a message
                    return true, "Deltatime is about " .. math.round(deltatime.time/3600) .. " hour(-s)"
                else
                    -- Tells about error
                    return false
                end
            end
        else
            -- Sends a message about deltatime
            return true, "Deltatime is ".. deltatime.time
        end
    end
})