local FORMNAME = "essentials:rename_me"
hide_names = {}

minetest.register_on_chat_message(function(name, message)
	local new_name = hide_names[name]
	if new_name then
		minetest.chat_send_all("<".. core.colorize(color, new_name) .."> ".. message)
		return true
	end
end)

function show_rename_menu(name)
	local formspec = [[
        formspec_version[6]
        size[4.5,9.6]
        field[0.1,4.3;4.3,1.1;new_name;New name;]
        button[0.1,7.2;4.3,1.2;rename;Rename]
        image_button_exit[3.4,8.5;1,1;close_btn.png;close_btn;]
        field[0.1,5.9;4.3,1.1;color;Color;]
        image[0.4,0.1;3.7,3.7;sussy_amogus_name.png]
    ]]

	minetest.show_formspec(name, FORMNAME, formspec)
end

minetest.register_on_player_receive_fields(function(player, formname, field)
    local name = player:get_player_name();
    local new_name = field.new_name
    local color = field.color
	if formname ~= FORMNAME then
		return
	end

    if field.close_btn then
        minetest.sound_play("clicked")
    end

    if field.rename then
        if core.is_singleplayer() then
            minetest.chat_send_player(name, core.colorize("red", "Cannot rename in singleplayer"))
            minetest.sound_play("error")
        else
            if new_name == "" then
                minetest.chat_send_player(name, core.colorize("red", "New name cannot be empty!"))
                minetest.sound_play("error")
            elseif color == "" then
                hide_names[name] = new_name
                minetest.chat_send_player(name, core.colorize("green", "Name changed to '".. new_name .."'"))
                minetest.sound_play("done")
                player:set_properties({
                    nametag = "*".. new_name,
                    nametag_color = "#AAAAAA"
                })
                minetest.close_formspec(name, formname)
            else
                hide_names[name] = new_name
                minetest.chat_send_player(name, core.colorize("green", "Name changed to '".. new_name .."' with ").. core.colorize(color, "Color ".. color))
                minetest.sound_play("done")
                player:set_properties({
                    nametag = core.colorize("#AAAAAA", "*").. core.colorize(color, new_name)
                })
                minetest.close_formspec(name, formname)
            end
        end
    end
end)
