local have_spawn_command = minetest.get_modpath("spawn_command")
local enable_damage = core.settings:get_bool("enable_damage")

invisible = function(player, toggle)
    player = minetest.get_player_by_name(player);
	invisibility[player] = toggle
	local prop
	if toggle == true then
		prop = {
			visual_size = {x = 0, y = 0}
		}
		player:set_nametag_attributes({
			color = {a = 0, r = 255, g = 255, b = 255}
		})
	elseif toggle == false then
		prop = {
			visual_size = {x = 1, y = 1}
		}
		player:set_nametag_attributes({
			color = {a = 255, r = 255, g = 255, b = 255}
		})
	end

	player:set_properties(prop)
end

minetest.register_on_leaveplayer(function(player)
	local name = player:get_player_name()

	if invisibility[name] then
		invisibility[name] = false
	end
end)

-- 'spawn_command' mod
if have_spawn_command then
    function set_the_spawn(name, param)
		local p = {}
        local posmessage = {x = 0, y = 0, z = 0}
        local player = minetest.get_player_by_name(name);
        local pos = player:get_pos();
        local static_spawnpoint = minetest.setting_get_pos("static_spawnpoint");
        local spawn_pos = vector.round(spawn_command.pos);
        p.x, p.y, p.z = string.match(param, "^([%d.~-]+)[, ] *([%d.~-]+)[, ] *([%d.~-]+)$");
		p = core.parse_coordinates(p.x, p.y, p.z, pos);

        if player == nil then
            return false
        end

		if p and p.x and p.y and p.z then
            spawn_command.pos = {x = p.x, y = p.y, z = p.z};
            static_spawnpoint = {x = p.x, y = p.y, z = p.z};
            posmessage = {x = p.x, y = p.y, z = p.z};
            minetest.chat_send_player(name, core.colorize("#00FF06", "Spawn sets successful at ".. posmessage.x .." ".. posmessage.y .." ".. posmessage.z .."!"))
            minetest.sound_play("done", name)
        elseif param == "" then
            spawn_pos = vector.round(pos);
            spawn_command.pos = spawn_pos;
            static_spawnpoint = spawnpos;
            minetest.chat_send_player(name, core.colorize("#00FF06", "Spawn sets successful at ".. spawn_pos.x .." ".. spawn_pos.y .." ".. spawn_pos.z .."!"))
            minetest.sound_play("done", name)
        else
            minetest.chat_send_player(name, core.colorize("red", "Wrong position!"))
            minetest.sound_play("error", name)
        end
    end
minetest.register_chatcommand("setspawn", {
    params = "<X>,<Y>,<Z>",
    description = "Sets a spawn point.",
    privs = {server = true},
    func = set_the_spawn,
})
end
-- end

minetest.register_chatcommand("ip", {
    params = "<name>",
    description = "Show the IP of a player.",
    privs = {server = true},
    func = function(name, param)
		if param == "" then
			minetest.chat_send_player(name, "Your IP of is ".. minetest.get_player_ip(name))
            minetest.sound_play("done", name)
			return
        end
        if minetest.get_player_by_name(param) == nil then
			minetest.chat_send_player(name, core.colorize("red", "Player ".. param .." not found!"))
            minetest.sound_play("error", name)
			return
		end
		minetest.chat_send_player(name, "IP of ".. param .." is ".. minetest.get_player_ip(param))
        minetest.sound_play("done", name)
    end,
})

minetest.register_chatcommand("broadcast", {
    params = "<message>",
    description = "Send GLOBAL message in chat.",
    privs = {server = true},
    func = function(name, param)
        if param == "" then
            core.chat_send_player(name, core.colorize("red", "Message cannot be empty!"))
            minetest.sound_play("error", name)
        else
            core.chat_send_all(core.colorize("#00FFC6", param))
            minetest.sound_play("broadcast")
        end
    end,
})

if enable_damage then
    core.register_privilege("god", {
        description = "Can use /god command",
        give_to_singleplayer = false,
    })
    
    function god_mode(name, param)
        local player = minetest.get_player_by_name(name)
        local ag = player:get_armor_groups()
        if not ag["immortal"] then
            ag["immortal"] = 1
            core.chat_send_player(name, "God mode enabled")
            minetest.sound_play("god_enabled", name)
        else
            ag["immortal"] = nil
            core.chat_send_player(name, "God mode disabled")
            minetest.sound_play("god_disabled", name)
        end
        player:set_armor_groups(ag)
    end

    minetest.register_chatcommand("god", {
        description = "Enable/Disabe the god mode.",
        privs = {god = true},
        func = god_mode
    })
end

minetest.register_chatcommand("ban_menu", {
    description = "Open the ban menu.",
    privs = {ban = true},
    func = function(name, param)
        if core.is_singleplayer() then
            minetest.chat_send_player(name, core.colorize("red", "You cannot ban in single mode!"))
            minetest.sound_play("error", name)
        else
            show_ban_menu(name)
        end
    end
})

minetest.register_chatcommand("kick_menu", {
    description = "Open the kick menu.",
    privs = {kick = true},
    func = function(name, param)
        if core.is_singleplayer() then
            minetest.chat_send_player(name, core.colorize("red", "You cannot kick in single mode!"))
            minetest.sound_play("error", name)
        else
            show_kick_menu(name)
        end
    end
})

--minetest.register_chatcommand("mute_menu", {
--    description = "Open the mute menu.",
--    privs = {mute = true},
--    func = function(name, param)
--        if core.is_singleplayer() then
--            minetest.chat_send_player(name, core.colorize("red", "You cannot mute in single mode!"))
--        else
--            show_mute_menu(name)
--        end
--    end
--})

minetest.register_chatcommand("getpos", {
    params = "<name>",
    description = "Allows the player to find out the position of another player.",
    privs = {server = true},
    func = function(name, param)
        local player = minetest.get_player_by_name(param);

		if param == "" then
			minetest.chat_send_player(name, core.colorize("red", "Player name cannot be empty!"))
            minetest.sound_play("error", name)
			return
        elseif minetest.get_player_by_name(param) == nil then
			minetest.chat_send_player(name, core.colorize("red", "Player ".. param .." not found!"))
            minetest.sound_play("error", name)
			return
		else
            local pos = player:get_pos();
            local round_pos = vector.round(pos);
		    minetest.chat_send_player(name, "Position of ".. param .." is ".. round_pos.x .." ".. round_pos.y .." ".. round_pos.z)
            minetest.sound_play("done", name)
        end
    end,
})

minetest.register_chatcommand("rename_me", {
	description = "Show the rename menu.",
	privs = {rename = true},
	func = function(name, param)
        show_rename_menu(name)
	end
})

--[[minetest.register_chatcommand("v", {
	params = "<name>",
	description = "Make player invisible",
	privs = {server = true},
	func = function(name, param)
        local player = minetest.get_player_by_name(param)
        if param == "" then
		    if invisibility[name] then
			    invisible(name, false)
                minetest.chat_send_player(name, "Now you are visible!")
                minetest.sound_play("done", name)
            elseif not invisibility[name] then
			    invisible(name, true)
                minetest.chat_send_player(name, core.colorize("#AAAAAA", "Now you are invisible!"))
                minetest.sound_play("done", name)
		    end
        elseif not player then
			minetest.chat_send_player(name, core.colorize("red", "Player ".. param .." not found!"))
            minetest.sound_play("error", name)
        else
            if invisibility[param] then
			    invisible(param, false)
                minetest.chat_send_player(name, "Now player ".. param .." are visible!")
                minetest.chat_send_player(player, "Now you visible from ".. name .."!")
                minetest.sound_play("done", name)
                minetest.sound_play("done", player)
		    elseif not invisibility[param] then
			    invisible(param, true)
                minetest.chat_send_player(name, core.colorize("#AAAAAA", "Now player ".. param .." are invisible!"))
                minetest.chat_send_player(name, core.colorize("#AAAAAA", "Now you are invisible from ".. name .."!"))
                minetest.sound_play("done", name)
                minetest.sound_play("done", player)
		    end
        end
	end
})]]--
