local S = minetest.get_translator("bucket")
local Sfake = minetest.get_translator("fake_liquid")
local Sdef = minetest.get_translator("default")

minetest.register_alias("fake_bucket_water", "fake_liqiud:bucket_water")
minetest.register_alias("fake_bucket_lava", "fake_liqiud:bucket_lava")

fake_liquid= {}
fake_liquid.liquids = {}

function fake_liquid.particle_spawn(pos)
    minetest.add_particlespawner({1, 0.1,
                    minpos = {x = pos.x-0.35, y = pos.y, z = pos.z-0.35},
                    maxpos = {x = pos.x+0.35, y = pos.y, z = pos.z+0.35},
                    minvel = {x = 0, y = 0.2, z = 0},
                    maxvel = {x = 0, y = 0.7, z = 0},
                    minacc = {x = 0, y = 0.35, z = 0},
                    maxacc = {x = 0, y = 0.9, z = 0},
                    minexptime = 1,
                    maxexptime = 1.4,
                    minsize = 2,
                    maxsize = 2.5,
                    collisiondetection = false,
                    texture = "heart.png",
                    vertical = false
                })
end

minetest.register_craft({
	type = "shapeless",
	output = "fake_liquid:bucket_water",
	recipe = {
		"bucket:bucket_water",
        "fake_liquid:poison",
	},
})

minetest.register_craft({
	type = "shapeless",
	output = "fake_liquid:bucket_river_water",
	recipe = {
		"bucket:bucket_river_water",
        "fake_liquid:poison",
	},
})

minetest.register_craft({
	type = "shapeless",
	output = "fake_liquid:bucket_lava 2",
	recipe = {
    	"bucket:bucket_water",
		"bucket:bucket_lava",
        "fake_liquid:health",
	},
})

bucket.register_liquid(
	"fake_liquid:water_source",
	"fake_liquid:water_flowing",
	"fake_liquid:bucket_water",
	"fake_liquid_bucket_water.png",
	S("Water Bucket").." "..Sfake("(Fake)"),
	{tool = 1, water_bucket = 1}
)

bucket.register_liquid(
	"fake_liquid:river_water_source",
	"fake_liquid:river_water_flowing",
	"fake_liquid:bucket_river_water",
	"fake_liquid_bucket_river_water.png",
	S("River Water Bucket").." "..Sfake("(Fake)"),
	{tool = 1, water_bucket = 1},
	true
)

bucket.register_liquid(
	"fake_liquid:lava_source",
	"fake_liquid:lava_flowing",
	"fake_liquid:bucket_lava",
	"fake_liquid_bucket_lava.png",
	S("Lava Bucket").." "..Sfake("(Fake)"),
	{tool = 1}
)

minetest.register_node("fake_liquid:water_source", {
	description = Sdef("Water Source")..Sfake(" (Fake)"),
	drawtype = "liquid",
	waving = 3,
	tiles = {
		{
			name = "default_water_source_animated.png",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "default_water_source_animated.png",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "source",
	liquid_alternative_flowing = "fake_liquid:water_flowing",
	liquid_alternative_source = "fake_liquid:water_source",
	liquid_viscosity = 1,
	damage_per_second = 5,
	post_effect_color = {a = 103, r = 30, g = 60, b = 90},
	groups = {water = 3, liquid = 3,
	cools_lava = 1},
	sounds = default.node_sound_water_defaults(),
})

minetest.register_node("fake_liquid:water_flowing", {
	description = Sdef("Flowing Water").." "..Sfake("(Fake) "),
	drawtype = "flowingliquid",
	waving = 3,
	tiles = {"default_water.png"},
	special_tiles = {
		{
			name = "default_water_flowing_animated.png",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
		{
			name = "default_water_flowing_animated.png",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	paramtype2 = "flowingliquid",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "flowing",
	liquid_alternative_flowing = "fake_liquid:water_flowing",
	liquid_alternative_source = "fake_liquid:water_source",
	liquid_viscosity = 1,
	damage_per_second = 4,
	post_effect_color = {a = 103, r = 30, g = 60, b = 90},
	groups = {water = 3, liquid = 3, not_in_creative_inventory = 1, 
cools_lava = 1},
	sounds = default.node_sound_water_defaults(),
})


minetest.register_node("fake_liquid:river_water_source", {
	description = Sdef("River Water Source")..Sfake(" (Fake)"),
	drawtype = "liquid",
	tiles = {
		{
			name = "default_river_water_source_animated.png",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "default_river_water_source_animated.png",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "source",
	liquid_alternative_flowing = "fake_liquid:river_water_flowing",
	liquid_alternative_source = "fake_liquid:river_water_source",
	liquid_viscosity = 1,
	liquid_renewable = false,
	liquid_range = 2,
	damage_per_second = 3,
	post_effect_color = {a = 103, r = 30, g = 76, b = 90},
	groups = {water = 3, liquid = 3, cools_lava = 1},
	sounds = default.node_sound_water_defaults(),
})

minetest.register_node("fake_liquid:river_water_flowing", {
	description = Sdef("Flowing River Water").." "..Sfake("(Fake) "),
	drawtype = "flowingliquid",
	tiles = {"default_river_water.png"},
	special_tiles = {
		{
			name = "default_river_water_flowing_animated.png",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
		{
			name = "default_river_water_flowing_animated.png",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	paramtype2 = "flowingliquid",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "flowing",
	liquid_alternative_flowing = "fake_liquid:river_water_flowing",
	liquid_alternative_source = "fake_liquid:river_water_source",
	liquid_viscosity = 1,
	liquid_renewable = false,
	damage_per_second = 2,
	liquid_range = 2,
	post_effect_color = {a = 103, r = 30, g = 76, b = 90},
	groups = {water = 3, liquid = 3, not_in_creative_inventory = 1,
		cools_lava = 1},
	sounds = default.node_sound_water_defaults(),
})

minetest.register_node("fake_liquid:lava_source", {
	description = Sdef("Lava Source")..Sfake(" (Fake)"),
	drawtype = "liquid",
	tiles = {
		{
			name = "default_lava_source_animated.png",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 3.0,
			},
		},
		{
			name = "default_lava_source_animated.png",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 3.0,
			},
		},
	},
	paramtype = "light",
	light_source = default.LIGHT_MAX - 1,
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "source",
	liquid_alternative_flowing = "fake_liquid:lava_flowing",
	liquid_alternative_source = "fake_liquid:lava_source",
	liquid_viscosity = 7,
	liquid_renewable = false,
	post_effect_color = {a = 191, r = 255, g = 64, b = 0},
	groups = {lava = 3, liquid = 2, igniter = 1},
})

minetest.register_node("fake_liquid:lava_flowing", {
	description = Sdef("Flowing Lava").." "..Sfake("(Fake) "),
	drawtype = "flowingliquid",
	tiles = {"default_lava.png"},
	special_tiles = {
		{
			name = "default_lava_flowing_animated.png",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 3.3,
			},
		},
		{
			name = "default_lava_flowing_animated.png",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 3.3,
			},
		},
	},
	paramtype = "light",
	paramtype2 = "flowingliquid",
	light_source = default.LIGHT_MAX - 1,
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "flowing",
	liquid_alternative_flowing = "fake_liquid:lava_flowing",
	liquid_alternative_source = "fake_liquid:lava_source",
	liquid_viscosity = 7,
	liquid_renewable = false,
	post_effect_color = {a = 191, r = 255, g = 64, b = 0},
	groups = {lava = 3, liquid = 2, igniter = 1,
		not_in_creative_inventory = 1},
})

minetest.register_globalstep(function(dtime)
    for i, player in pairs(minetest.get_connected_players()) do
        local node = minetest.get_node(player:get_pos())
        --core.chat_send_all(dump(node))
        if node.name == "fake_liquid:lava_source" or node.name == "fake_liquid:lava_flowing" then
            minetest.after(1, function()
                player:set_hp(player:get_hp()+1)
                local pos = player:get_pos()
                fake_liquid.particle_spawn(pos)
            end)
        end
    end
end)

minetest.register_craftitem("fake_liquid:poison", {
	description = Sfake("Poison"),
	inventory_image = "fake_liquid_poison.png",
})
minetest.register_craft({
	type = "shapeless",
	output = "fake_liquid:poison 3",
	recipe = {
		"group:grass",
        "dye:green",
		"default:diamond",
        "default:mese_crystal",
        "vessels:glass_bottle",
	},
})

minetest.register_craftitem("fake_liquid:health", {
	description = Sfake("Health"),
	inventory_image = "fake_liquid_health.png",
	on_use = function(itemstack, user, pointed_thing)
	if user:get_hp() < 20 then
	    user:set_hp(10 * 2)
	    itemstack:take_item()
	    local pos = user:get_pos()
	    for i, ten in ipairs({1,2,3,4,5,6,7,8,9,10}) do
	    minetest.add_particlespawner({20, 0,
                    minpos = {x = pos.x-0.35, y = pos.y+0.5, z = pos.z-0.35},
                    maxpos = {x = pos.x+0.35, y = pos.y+0.5, z = pos.z+0.35},
                    minvel = {x = 0, y = 0.2, z = 0},
                    maxvel = {x = 0, y = 0.7, z = 0},
                    minacc = {x = 0, y = 0.35, z = 0},
                    maxacc = {x = 0, y = 0.9, z = 0},
                    minexptime = 1,
                    maxexptime = 1.4,
                    minsize = 2,
                    maxsize = 2.5,
                    collisiondetection = false,
                    texture = "heart.png",
                    vertical = false
                })
                end
	    return itemstack
	end
	end,
})
minetest.register_craft({
	type = "shapeless",
	output = "fake_liquid:health",
	recipe = {
		"group:grass",
        "dye:red",
		"default:steel_ingot",
        "default:mese_crystal",
        "vessels:glass_bottle",
	},
})