local S = minetest.get_translator("fire_extinguisher")
fire_extinguisher = {}

function fire_extinguisher.water(itemstack, user, pointed_thing, rad, prog)
    local pos = user:get_pos()
    local radius = 3 or rad
    -- Thing, that prevent item to break
    local extinguished = false
    
    for dx = -radius, radius do
        for dz = -radius, radius do
            for dy = -radius, radius do
                local npos = {x = pos.x+dx, y = pos.y+dy, z = pos.z+dz}
                local node = minetest.get_node(npos)
                if (node.name == "fire:basic_flame") then
                    prog = prog + (0.1 * rad)
                    minetest.remove_node(npos)
                    extinguished = true
                end
            end
        end
    end

    if extinguished then
        local amount = math.floor(65535 * (prog / 100))
        local mwear = itemstack:get_wear()
        local wear = mwear + amount
		minetest.sound_play("default_cool_lava", {pos = pos, max_hear_distance = 16})
        itemstack:set_wear(wear)
        user:set_wielded_item(itemstack)
    end
end

minetest.register_tool("fire_extinguisher:small", {
    description = S("Fire extinguisher"),
    groups = {tool = 1},
    inventory_image = "fire_extinguisher_small.png",
    stack_max = 1,
    range = 4.5,
    wear_color = {
        blend = "linear",
        color_stops = {
            [0.0] = "#ffffff",
            [0.5] = "#30ffee",
            [1.0] = "#34cceb",
        }
    },
    on_use = function(itemstack, user, pointed_thing)
        fire_extinguisher.water(itemstack, user, pointed_thing, 4, 10)
    end,
})

minetest.register_tool("fire_extinguisher:big", {
    description = S("Big Fire extinguisher"),
    groups = {tool = 1},
    inventory_image = "fire_extinguisher_big.png",
    stack_max = 1,
    range = 4.5,
    wear_color = {
        blend = "linear",
        color_stops = {
            [0.0] = "#ffffff",
            [0.5] = "#30ffee",
            [1.0] = "#34cceb",
        }
    },
    wield_size = {x = 4, y = 4, z = 4},
    on_use = function(itemstack, user, pointed_thing)
        fire_extinguisher.water(itemstack, user, pointed_thing, 8, 4)
    end,
})

minetest.register_craft({
    output = "fire_extinguisher:small",
    recipe = {
        {"default:steel_ingot", "dye:red", "default:steel_ingot"},
        {"dye:red", "bucket:bucket_water", "dye:red"},
        {"dye:red", "bucket:bucket_water", "dye:red"},
    },
})


minetest.register_craft({
    output = "fire_extinguisher:big",
    recipe = {
        {"default:steel_ingot", "dye:red", "default:steel_ingot"},
        {"dye:red", "fire_extinguisher:small", "dye:red"},
        {"default:tin_ingot", "fire_extinguisher:small", "default:tin_ingot"},
    },
})