hardcore_mode = {
    players_died = {}
}
local modname = core.get_current_modname()
local modpath = core.get_modpath(modname)
local S = core.get_translator(modname)

dofile(modpath .. "/api.lua")

local function kick(ip)
    local reason = hardcore_mode.died(ip)
    local kicked = nil
    if reason then
        if core.is_singleplayer() then
            kicked = S("@n@n@nYou died in hardcore mode!@n(Reason: @1)@n@nYou can only delete this world.", reason.type)
        else
            kicked = S("@n@n@nYou died in hardcore mode!@n(Reason: @1)@n@nR.I.P. you", reason.type)
        end
    end
    return kicked
end

core.register_on_prejoinplayer(function(_, ip)
    local kicked = kick(ip)
    if kicked then return kicked end
end)

core.register_on_dieplayer(function(player, reason)
    local name = player:get_player_name()
    local ip = core.get_player_ip(name)
    hardcore_mode.add(ip, reason)
    local kicked = kick(ip)
    if kicked then
        core.kick_player(name, kicked)
    end
    if not core.is_singleplayer() then
        core.chat_send_all(S("@1 died in hardcore mode!", name))
    end
end)