local worldpath = core.get_worldpath() .. "/"
local data = "hardcore_mode.json"

local function read_file(path)
    local f = io.open(path, "r")
    if not f then
        return nil
    end
    local txt = f:read("*all")
    f:close()
    return txt
end

local function write_file(path, content)
    local f = io.open(path, "w")
    f:write(content)
    f:close()
end

function hardcore_mode.save()
    local tbl = hardcore_mode.players_died
    local content = core.write_json(tbl)
    local path = worldpath .. data
    write_file(path, content)
end

function hardcore_mode.load()
    local content = read_file(worldpath .. data)
    if not content then
        return false
    end
    local tbl = core.parse_json(content)
    if not tbl then
        return false
    end
    hardcore_mode.players_died = tbl
    return true
end

function hardcore_mode.add(ip, reason)
    if not hardcore_mode.players_died[ip] then
        hardcore_mode.players_died[ip] = reason
        hardcore_mode.save()
    end
end

function hardcore_mode.died(ip)
    return hardcore_mode.players_died[ip]
end

core.register_on_mods_loaded(function()
    hardcore_mode.load()
end)